/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class ChangeExtendsImplementsQuickFix
extends PsiUpdateModCommandAction<GrTypeDefinition> {
    public ChangeExtendsImplementsQuickFix(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)aClass);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("change.implements.and.extends.classes", new Object[0]);
        if (string == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull GrTypeDefinition typeDef, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(2);
        }
        if (typeDef == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(4);
        }
        LinkedHashSet<String> classes2 = new LinkedHashSet<String>();
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownClasses = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownInterfaces = new LinkedHashSet<String>();
        GrExtendsClause extendsClause = typeDef.getExtendsClause();
        GrImplementsClause implementsClause = typeDef.getImplementsClause();
        Project project = context.project();
        if (extendsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(extendsClause.getReferenceElementsGroovy(), classes2, interfaces, typeDef.isInterface() ? unknownInterfaces : unknownClasses);
            extendsClause.delete();
        }
        if (implementsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(implementsClause.getReferenceElementsGroovy(), classes2, interfaces, unknownInterfaces);
            implementsClause.delete();
        }
        if (typeDef.isInterface()) {
            interfaces.addAll(classes2);
            unknownInterfaces.addAll(unknownClasses);
            ChangeExtendsImplementsQuickFix.addNewClause(typeDef, interfaces, unknownInterfaces, project, true);
        } else {
            ChangeExtendsImplementsQuickFix.addNewClause(typeDef, classes2, unknownClasses, project, true);
            ChangeExtendsImplementsQuickFix.addNewClause(typeDef, interfaces, unknownInterfaces, project, false);
        }
    }

    private static void collectRefs(GrCodeReferenceElement[] refs, Collection<? super String> classes2, Collection<? super String> interfaces, Collection<? super String> unknown) {
        for (GrCodeReferenceElement ref2 : refs) {
            PsiElement extendsElement = ref2.resolve();
            String canonicalText = ref2.getCanonicalText();
            if (extendsElement instanceof PsiClass) {
                if (((PsiClass)extendsElement).isInterface()) {
                    interfaces.add(canonicalText);
                    continue;
                }
                classes2.add(canonicalText);
                continue;
            }
            unknown.add(canonicalText);
        }
    }

    private static void addNewClause(@NotNull GrTypeDefinition typeDef, @NotNull Collection<String> elements, @NotNull Collection<String> additional, @NotNull Project project, boolean isExtends) throws IncorrectOperationException {
        GrReferenceList clause;
        if (typeDef == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(6);
        }
        if (additional == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(8);
        }
        if (elements.isEmpty() && additional.isEmpty()) {
            return;
        }
        @NlsSafe StringBuilder classText = new StringBuilder();
        classText.append("class A ");
        classText.append(isExtends ? "extends " : "implements ");
        for (String str : elements) {
            classText.append(str);
            classText.append(", ");
        }
        for (String str : additional) {
            classText.append(str);
            classText.append(", ");
        }
        classText.delete(classText.length() - 2, classText.length());
        classText.append(" {}");
        GrTypeDefinition definition = GroovyPsiElementFactory.getInstance(project).createTypeDefinition(classText.toString());
        GrReferenceList grReferenceList = clause = isExtends ? definition.getExtendsClause() : definition.getImplementsClause();
        assert (clause != null);
        PsiElement addedClause = typeDef.addBefore(clause, typeDef.getBody());
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedClause);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNewClause";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

