/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GrDeprecatedAPIUsageInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref2) {
                if (ref2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(ref2);
                PsiElement resolveResult2 = 1.getResolveElement(ref2);
                this.checkRef(resolveResult2, ref2.getReferenceNameElement(), ref2.getReferenceName());
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement ref2) {
                if (ref2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitCodeReferenceElement(ref2);
                PsiElement resolveResult2 = 1.getResolveElement(ref2);
                this.checkRef(resolveResult2, ref2.getReferenceNameElement(), ref2.getReferenceName());
            }

            @Override
            public void visitArgumentLabel(@NotNull GrArgumentLabel argumentLabel) {
                if (argumentLabel == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitArgumentLabel(argumentLabel);
                PsiElement resolveResult2 = 1.getResolveElement(argumentLabel);
                if (resolveResult2 instanceof GrAccessorMethod) {
                    resolveResult2 = ((GrAccessorMethod)resolveResult2).getProperty();
                }
                this.checkRef(resolveResult2, argumentLabel.getNameElement(), argumentLabel.getName());
            }

            @Override
            public void visitNewExpression(@NotNull GrNewExpression ref2) {
                if (ref2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitNewExpression(ref2);
                PsiMethod resolvedCall = ref2.resolveMethod();
                if (resolvedCall == null || 1.isDeprecated((PsiElement)resolvedCall.getContainingClass())) {
                    return;
                }
                GrCodeReferenceElement referenceElement = ref2.getReferenceElement();
                if (referenceElement != null) {
                    this.checkRef((PsiElement)resolvedCall, ref2.getReferenceElement(), referenceElement.getReferenceName());
                } else {
                    this.checkRef((PsiElement)resolvedCall, ref2, resolvedCall.getName());
                }
            }

            private void checkRef(PsiElement resolved, PsiElement elementToHighlight, String elementName) {
                if (1.isDeprecated(resolved)) {
                    this.registerError(elementToHighlight, GroovyBundle.message("0.is.deprecated", elementName), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }

            @Nullable
            private static PsiElement getResolveElement(GroovyReference reference) {
                GroovyResolveResult[] results;
                for (GroovyResolveResult result2 : results = reference.multiResolve(false)) {
                    PsiElement element = result2.getElement();
                    if (element == null) continue;
                    return element;
                }
                return null;
            }

            private static boolean isDeprecated(PsiElement resolved) {
                if (resolved instanceof PsiDocCommentOwner) {
                    return ((PsiDocCommentOwner)resolved).isDeprecated();
                }
                return resolved instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)resolved));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argumentLabel";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrDeprecatedAPIUsageInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArgumentLabel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

