/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyModifiersUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;
import org.jetbrains.plugins.groovy.template.expressions.StringParameterNameExpression;

public final class IntentionUtils {
    private static final Logger LOG = Logger.getInstance(IntentionUtils.class);

    public static void createTemplateForMethod(ChooseTypeExpression[] paramTypesExpressions, PsiMethod method, PsiClass owner, TypeConstraint[] constraints, boolean isConstructor, @NotNull PsiElement context) {
        if (context == null) {
            IntentionUtils.$$$reportNull$$$0(0);
        }
        ParameterNameExpression[] nameExpressions = new ParameterNameExpression[paramTypesExpressions.length];
        for (int i2 = 0; i2 < nameExpressions.length; ++i2) {
            nameExpressions[i2] = StringParameterNameExpression.Companion.getEMPTY();
        }
        ChooseTypeExpression returnTypeExpression = new ChooseTypeExpression(constraints, owner.getManager(), context.getResolveScope(), method.getLanguage() == GroovyLanguage.INSTANCE);
        IntentionUtils.createTemplateForMethod(paramTypesExpressions, nameExpressions, method, owner, returnTypeExpression, isConstructor, true, context);
    }

    public static void createTemplateForMethod(ChooseTypeExpression[] paramTypesExpressions, ParameterNameExpression[] paramNameExpressions, PsiMethod method, PsiClass owner, ChooseTypeExpression returnTypeExpression, boolean isConstructor, boolean isScrollToTemplate, final @Nullable PsiElement context) {
        final Project project = owner.getProject();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        builder.setScrollToTemplate(isScrollToTemplate);
        if (!isConstructor) {
            assert (typeElement != null);
            builder.replaceElement((PsiElement)typeElement, (Expression)returnTypeExpression);
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            PsiTypeElement parameterTypeElement = parameter.getTypeElement();
            builder.replaceElement((PsiElement)parameterTypeElement, (Expression)paramTypesExpressions[i2]);
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), (Expression)paramNameExpressions[i2]);
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiJavaToken lbrace = body.getLBrace();
            assert (lbrace != null);
            builder.setEndVariableAfter((PsiElement)lbrace);
        } else {
            builder.setEndVariableAfter((PsiElement)method.getParameterList());
        }
        method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        Template template = builder.buildTemplate();
        final PsiFile targetFile = owner.getContainingFile();
        final Editor newEditor = IntentionUtils.positionCursor(project, targetFile, (PsiElement)method);
        TextRange range = method.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        TemplateEditingAdapter templateListener = new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                    int offset = newEditor.getCaretModel().getOffset();
                    PsiMethod method1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                    if (context instanceof PsiMethod) {
                        PsiTypeParameter[] typeParameters;
                        for (PsiTypeParameter typeParameter : typeParameters = ((PsiMethod)context).getTypeParameters()) {
                            if (!CreateMethodFromUsageFix.checkTypeParam((PsiMethod)method1, (PsiTypeParameter)typeParameter)) continue;
                            JVMElementFactory factory = JVMElementFactories.getFactory((Language)method1.getLanguage(), (Project)method1.getProject());
                            PsiTypeParameterList list = method1.getTypeParameterList();
                            if (list == null) {
                                PsiTypeParameterList newList = factory.createTypeParameterList();
                                list = (PsiTypeParameterList)method1.addAfter((PsiElement)newList, (PsiElement)method1.getModifierList());
                            }
                            list.add((PsiElement)factory.createTypeParameter(typeParameter.getName(), typeParameter.getExtendsList().getReferencedTypes()));
                        }
                    }
                    if (method1 != null) {
                        try {
                            boolean hasNoReturnType;
                            boolean bl = hasNoReturnType = method1.getReturnTypeElement() == null && method1 instanceof GrMethod;
                            if (hasNoReturnType) {
                                ((GrMethod)method1).setReturnType((PsiType)PsiTypes.voidType());
                            }
                            if (method1.getBody() != null) {
                                FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
                                FileTemplate fileTemplate = templateManager.getCodeTemplate("Groovy New Method Body.groovy");
                                PsiClass containingClass = method1.getContainingClass();
                                LOG.assertTrue(!containingClass.isInterface() || GrTraitUtil.isTrait(containingClass), (Object)"Interface bodies should be already set up");
                                CreateFromUsageUtils.setupMethodBody((PsiMethod)method1, (PsiClass)containingClass, (FileTemplate)fileTemplate);
                            }
                            if (hasNoReturnType) {
                                ((GrMethod)method1).setReturnType(null);
                            }
                            if (method1 instanceof GrMethod && GroovyModifiersUtil.isDefUnnecessary((GrMethod)method1)) {
                                ((GrMethod)method1).getModifierList().setModifierProperty("def", false);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        CreateFromUsageUtils.setupEditor((PsiMethod)method1, (Editor)newEditor);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils$1", "templateFinished"));
            }
        };
        manager.startTemplate(newEditor, template, (TemplateEditingListener)templateListener);
    }

    public static Editor positionCursor(@NotNull Project project, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        if (project == null) {
            IntentionUtils.$$$reportNull$$$0(1);
        }
        if (targetFile == null) {
            IntentionUtils.$$$reportNull$$$0(2);
        }
        if (element == null) {
            IntentionUtils.$$$reportNull$$$0(3);
        }
        int textOffset = element.getTextOffset();
        VirtualFile virtualFile = targetFile.getVirtualFile();
        if (virtualFile != null) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile, textOffset);
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTemplateForMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "positionCursor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

