/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public final class ClosureParameterEnhancer
extends AbstractClosureParameterEnhancer {
    private static final Map<@NlsSafe String, @NlsSafe String> simpleTypes = new HashMap<String, String>();
    private static final Set<@NlsSafe String> iterations = new HashSet<String>();

    @Override
    @Nullable
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression closure, int index) {
        if (closure == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(0);
        }
        if (CompileStaticUtil.isCompileStatic(closure)) {
            return null;
        }
        return ClosureParameterEnhancer.inferType(closure, index);
    }

    @Nullable
    public static PsiType inferType(@NotNull GrFunctionalExpression expression, int index) {
        PsiElement parent2;
        if (expression == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(1);
        }
        if ((parent2 = expression.getParent()) instanceof GrStringInjection && index == 0) {
            return TypesUtil.createTypeByFQClassName("java.io.StringWriter", expression);
        }
        if (parent2 instanceof GrArgumentList) {
            parent2 = parent2.getParent();
        }
        if (!(parent2 instanceof GrMethodCall)) {
            return null;
        }
        String methodName = ClosureParameterEnhancer.findMethodName((GrMethodCall)parent2);
        GrExpression invokedExpression = ((GrMethodCall)parent2).getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return null;
        }
        GrParameter[] params = expression.getAllParameters();
        if (params.length == 1 && simpleTypes.containsKey(methodName)) {
            String typeText = simpleTypes.get(methodName);
            if (typeText.indexOf(60) < 0) {
                return TypesUtil.createTypeByFQClassName(typeText, expression);
            }
            return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createTypeFromText(typeText, (PsiElement)expression);
        }
        if (iterations.contains(methodName)) {
            if (params.length == 1) {
                return ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)expression);
            }
            if (params.length == 2 && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                if (index == 0) {
                    return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)true);
                }
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)true);
            }
        } else {
            if (GdkMethodUtil.isWithName(methodName) && params.length == 1) {
                return type2;
            }
            if ("eachWithIndex".equals(methodName)) {
                PsiType res = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)expression);
                if (params.length == 2 && res != null) {
                    if (index == 0) {
                        return res;
                    }
                    return TypesUtil.createTypeByFQClassName("java.lang.Integer", expression);
                }
                if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                    if (params.length == 2) {
                        if (index == 0) {
                            return ClosureParameterEnhancer.getEntryForMap(type2, expression.getProject(), expression.getResolveScope());
                        }
                        return TypesUtil.createTypeByFQClassName("java.lang.Integer", expression);
                    }
                    if (params.length == 3) {
                        if (index == 0) {
                            return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)true);
                        }
                        if (index == 1) {
                            return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)true);
                        }
                        return TypesUtil.createTypeByFQClassName("java.lang.Integer", expression);
                    }
                }
            } else if ("inject".equals(methodName) && params.length == 2) {
                if (index == 0) {
                    return TypesUtil.createTypeByFQClassName("java.lang.Object", expression);
                }
                PsiType res = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)expression);
                if (res != null) {
                    return res;
                }
                if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                    return ClosureParameterEnhancer.getEntryForMap(type2, expression.getProject(), expression.getResolveScope());
                }
            } else {
                if ("eachPermutation".equals(methodName) && params.length == 1) {
                    PsiType itemType = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)expression);
                    if (itemType != null) {
                        return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createTypeFromText("java.util.ArrayList<" + itemType.getCanonicalText() + ">", (PsiElement)expression);
                    }
                    return TypesUtil.createTypeByFQClassName("java.util.ArrayList", expression);
                }
                if ("withDefault".equals(methodName)) {
                    if (params.length == 1 && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                        return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)true);
                    }
                } else if ("sort".equals(methodName)) {
                    if (params.length < 3) {
                        return ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)expression);
                    }
                } else if ("withStream".equals(methodName)) {
                    PsiParameter[] parameters2;
                    PsiMethod method = ((GrMethodCall)parent2).resolveMethod();
                    if (method instanceof GrGdkMethod) {
                        return qualifier.getType();
                    }
                    if (method != null && (parameters2 = method.getParameterList().getParameters()).length > 0) {
                        return parameters2[0].getType();
                    }
                } else if ("withStreams".equals(methodName)) {
                    if (index == 0) {
                        return TypesUtil.createTypeByFQClassName("java.io.InputStream", expression);
                    }
                    if (index == 1) {
                        return TypesUtil.createTypeByFQClassName("java.io.OutputStream", expression);
                    }
                } else if ("withObjectStreams".equals(methodName)) {
                    if (index == 0) {
                        return TypesUtil.createTypeByFQClassName("java.io.ObjectInputStream", expression);
                    }
                    if (index == 1) {
                        return TypesUtil.createTypeByFQClassName("java.io.ObjectOutputStream", expression);
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    public static PsiType getEntryForMap(@Nullable PsiType map2, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(3);
        }
        PsiType key = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)map2, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value2 = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)map2, (String)"java.util.Map", (int)1, (boolean)true);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass entryClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Map.Entry", scope);
        if (entryClass == null) {
            if (key != null && key != PsiTypes.nullType() && value2 != null && value2 != PsiTypes.nullType()) {
                String text = String.format("%s<%s,%s>", "java.util.Map.Entry", key.getCanonicalText(), value2.getCanonicalText());
                PsiType psiType = factory.createTypeFromText(text, null);
                if (psiType == null) {
                    ClosureParameterEnhancer.$$$reportNull$$$0(4);
                }
                return psiType;
            }
            PsiClassType psiClassType = factory.createTypeByFQClassName("java.util.Map.Entry", scope);
            if (psiClassType == null) {
                ClosureParameterEnhancer.$$$reportNull$$$0(5);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = factory.createType(entryClass, new PsiType[]{key, value2});
        if (psiClassType == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(6);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType findTypeForIteration(@NotNull GrExpression qualifier, @NotNull PsiElement context) {
        PsiType iterType;
        if (qualifier == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(8);
        }
        if ((iterType = qualifier.getType()) == null) {
            return null;
        }
        PsiType type2 = ClosureParameterEnhancer.findTypeForIteration(iterType, context);
        if (type2 == null) {
            return null;
        }
        return PsiImplUtil.normalizeWildcardTypeByPosition(type2, qualifier);
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static PsiType findTypeForIteration(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(9);
        }
        PsiManager manager = context.getManager();
        GlobalSearchScope resolveScope = context.getResolveScope();
        if (type2 instanceof PsiArrayType) {
            return TypesUtil.boxPrimitiveType(((PsiArrayType)type2).getComponentType(), manager, resolveScope);
        }
        if (type2 instanceof GrTupleType) {
            PsiType[] types = ((GrTupleType)type2).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        if (type2 instanceof GrRangeType) {
            return ((GrRangeType)type2).getIterationType();
        }
        PsiType fromIterator = ClosureParameterEnhancer.findTypeFromIteratorMethod(type2, context);
        if (fromIterator != null) {
            return fromIterator;
        }
        PsiType extracted = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)true);
        if (extracted != null) {
            return extracted;
        }
        if (TypesUtil.isClassType(type2, "java.lang.String", "java.io.File")) {
            return PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)resolveScope);
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
            return ClosureParameterEnhancer.getEntryForMap(type2, manager.getProject(), resolveScope);
        }
        return type2;
    }

    @Nullable
    private static PsiType findTypeFromIteratorMethod(@Nullable PsiType type2, PsiElement context) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        GroovyResolveResult[] candidates = ResolveUtil.getMethodCandidates(type2, "iterator", context, PsiType.EMPTY_ARRAY);
        GroovyResolveResult candidate = PsiImplUtil.extractUniqueResult(candidates);
        PsiElement element = candidate.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiType returnType2 = PsiUtil.getSmartReturnType((PsiMethod)element);
        PsiType iteratorType = candidate.getSubstitutor().substitute(returnType2);
        return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)iteratorType, (String)"java.util.Iterator", (int)0, (boolean)false);
    }

    @Nullable
    private static String findMethodName(@NotNull GrMethodCall methodCall) {
        GrExpression expression;
        if (methodCall == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(10);
        }
        if ((expression = methodCall.getInvokedExpression()) instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)expression).getReferenceName();
        }
        return null;
    }

    static {
        simpleTypes.put("times", "java.lang.Integer");
        simpleTypes.put("upto", "java.lang.Integer");
        simpleTypes.put("downto", "java.lang.Integer");
        simpleTypes.put("step", "java.lang.Integer");
        simpleTypes.put("withObjectOutputStream", "java.io.ObjectOutputStream");
        simpleTypes.put("withObjectInputStream", "java.io.ObjectInputStream");
        simpleTypes.put("withOutputStream", "java.io.OutputStream");
        simpleTypes.put("withInputStream", "java.io.InputStream");
        simpleTypes.put("withDataOutputStream", "java.io.DataOutputStream");
        simpleTypes.put("withDataInputStream", "java.io.DataInputStream");
        simpleTypes.put("eachLine", "java.lang.String");
        simpleTypes.put("eachFile", "java.io.File");
        simpleTypes.put("eachDir", "java.io.File");
        simpleTypes.put("eachFileRecurse", "java.io.File");
        simpleTypes.put("traverse", "java.io.File");
        simpleTypes.put("eachDirRecurse", "java.io.File");
        simpleTypes.put("eachFileMatch", "java.io.File");
        simpleTypes.put("eachDirMatch", "java.io.File");
        simpleTypes.put("withReader", "java.io.Reader");
        simpleTypes.put("withWriter", "java.io.Writer");
        simpleTypes.put("withWriterAppend", "java.io.Writer");
        simpleTypes.put("withPrintWriter", "java.io.PrintWriter");
        simpleTypes.put("eachByte", "byte");
        simpleTypes.put("transformChar", "String");
        simpleTypes.put("transformLine", "String");
        simpleTypes.put("filterLine", "String");
        simpleTypes.put("accept", "java.net.Socket");
        simpleTypes.put("dropWhile", "java.lang.Character");
        simpleTypes.put("eachMatch", "java.lang.String");
        simpleTypes.put("replaceAll", "java.util.regex.Matcher");
        simpleTypes.put("replaceFirst", "java.util.regex.Matcher");
        simpleTypes.put("splitEachLine", "java.util.List<java.lang.String>");
        simpleTypes.put("withBatch", "groovy.sql.BatchingStatementWrapper");
        iterations.add("each");
        iterations.add("any");
        iterations.add("every");
        iterations.add("reverseEach");
        iterations.add("collect");
        iterations.add("collectAll");
        iterations.add("collectEntries");
        iterations.add("find");
        iterations.add("findAll");
        iterations.add("retainAll");
        iterations.add("removeAll");
        iterations.add("split");
        iterations.add("groupBy");
        iterations.add("groupEntriesBy");
        iterations.add("findLastIndexOf");
        iterations.add("findIndexValues");
        iterations.add("findIndexOf");
        iterations.add("count");
        iterations.add("takeWhile");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParameterEnhancer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParameterEnhancer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryForMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosureParameterType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEntryForMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTypeForIteration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findMethodName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

