/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.typing.GrCallTypeCalculator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmNextPreviousCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrCallTypeCalculator;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "receiver", "method", "Lcom/intellij/psi/PsiMethod;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "isNextPrevious", "", "Companion", "intellij.groovy.psi"})
public final class DgmNextPreviousCallTypeCalculator
implements GrCallTypeCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private static final String NEXT = "next";
    @NlsSafe
    @NotNull
    private static final String PREVIOUS = "previous";

    @Override
    @Nullable
    public PsiType getType(@Nullable PsiType receiver, @NotNull PsiMethod method, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement context) {
        PsiType type2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isNextPrevious(method)) {
            return null;
        }
        List<? extends Argument> list = arguments2;
        PsiType psiType = list != null && (list = (Argument)CollectionsKt.firstOrNull(list)) != null ? list.getType() : (type2 = null);
        if (!TypesUtil.isNumericType(type2)) {
            return null;
        }
        return GrBinaryExpressionUtil.getDefaultNumericResultType(TypeConstants.getTypeRank(type2), 4, context);
    }

    private final boolean isNextPrevious(PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (!Intrinsics.areEqual((Object)NEXT, (Object)name) && !Intrinsics.areEqual((Object)PREVIOUS, (Object)name)) {
            return false;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.codehaus.groovy.runtime.DefaultGroovyMethods")) {
            return false;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter psiParameter = (PsiParameter)ArraysKt.singleOrNull((Object[])psiParameterArray);
        if (psiParameter == null) {
            return false;
        }
        PsiParameter parameter = psiParameter;
        return parameter.getType().equalsToText("java.lang.Number");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmNextPreviousCallTypeCalculator$Companion;", "", "()V", "NEXT", "", "PREVIOUS", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

