/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/GrCollectionConstructorConverter;", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter;", "()V", "isConvertible", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/ConversionResult;", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "position", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter$Position;", "context", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "Companion", "intellij.groovy.psi"})
public final class GrCollectionConstructorConverter
extends GrTypeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (position != GrTypeConverter.Position.ASSIGNMENT && position != GrTypeConverter.Position.RETURN_VALUE || CompileStaticUtil.isCompileStatic(context)) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiType)actualType, (String)"java.util.Collection")) {
            return null;
        }
        PsiClassType psiClassType = targetType instanceof PsiClassType ? (PsiClassType)targetType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType constructedType = psiClassType;
        PsiClass psiClass = constructedType.resolve();
        if (psiClass == null) {
            return null;
        }
        PsiClass constructedClass = psiClass;
        boolean hasConstructor = Companion.hasCollectionApplicableConstructor(constructedClass, context);
        return hasConstructor ? ConversionResult.OK : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/GrCollectionConstructorConverter$Companion;", "", "()V", "hasCollectionApplicableConstructor", "", "constructedClass", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
    @SourceDebugExtension(value={"SMAP\nGrCollectionConstructorConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrCollectionConstructorConverter.kt\norg/jetbrains/plugins/groovy/lang/typing/GrCollectionConstructorConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1747#2,3:58\n*S KotlinDebug\n*F\n+ 1 GrCollectionConstructorConverter.kt\norg/jetbrains/plugins/groovy/lang/typing/GrCollectionConstructorConverter$Companion\n*L\n50#1:58,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasCollectionApplicableConstructor(@NotNull PsiClass constructedClass, @NotNull PsiElement context) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)constructedClass, (String)"constructedClass");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                List<PsiMethod> constructors = ConstructorsKt.getAllConstructors(constructedClass, context);
                if (constructors.isEmpty()) {
                    return false;
                }
                PsiClassType psiClassType = TypesUtil.createType("java.util.Collection", context);
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
                PsiClassType collectionType = psiClassType;
                Iterable $this$any$iv = constructors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl2 = false;
                        PsiParameter[] psiParameterArray = it.getParameterList().getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                        PsiParameter parameter = (PsiParameter)ArraysKt.singleOrNull((Object[])psiParameterArray);
                        PsiParameter psiParameter = parameter;
                        if (!(psiParameter != null && (psiParameter = psiParameter.getType()) != null ? psiParameter.isAssignableFrom((PsiType)collectionType) : false)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

