/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DelegatingFileSystem<P extends DelegatingFileSystemProvider<P, ?>>
extends FileSystem {
    @NotNull
    protected abstract FileSystem getDelegate();

    @NotNull
    protected FileSystem getDelegate(@NotNull String root) {
        if (root == null) {
            DelegatingFileSystem.$$$reportNull$$$0(0);
        }
        FileSystem fileSystem = this.getDelegate();
        if (fileSystem == null) {
            DelegatingFileSystem.$$$reportNull$$$0(1);
        }
        return fileSystem;
    }

    public String toString() {
        return String.format("%s(delegate=%s)", this.getClass().getName(), this.getDelegate());
    }

    public abstract P provider();

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.getDelegate().isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.getDelegate().getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return new Iterable<Path>(){
            final Iterable<Path> myIterable;
            {
                this.myIterable = DelegatingFileSystem.this.getDelegate().getRootDirectories();
            }

            @Override
            @NotNull
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    final Iterator<Path> myIterator;
                    {
                        this.myIterator = myIterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myIterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return ((DelegatingFileSystemProvider)DelegatingFileSystem.this.provider()).toDelegatePath(this.myIterator.next());
                    }
                };
            }
        };
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.getDelegate().getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.getDelegate().supportedFileAttributeViews();
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        if (first == null) {
            DelegatingFileSystem.$$$reportNull$$$0(2);
        }
        if (more == null) {
            DelegatingFileSystem.$$$reportNull$$$0(3);
        }
        Path path = ((DelegatingFileSystemProvider)this.provider()).toDelegatePath(this.getDelegate(first).getPath(first, more));
        if (path == null) {
            DelegatingFileSystem.$$$reportNull$$$0(4);
        }
        return path;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this.getDelegate().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.getDelegate().getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.getDelegate().newWatchService();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/DelegatingFileSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "more";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/DelegatingFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

