/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.performanceTesting;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/performanceTesting/ValidateGradleMatrixCompatibilityCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.gradle.java"})
public final class ValidateGradleMatrixCompatibilityCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "validateGradleMatrixCompatibility";
    @NotNull
    public static final String PREFIX = "%validateGradleMatrixCompatibility";

    public ValidateGradleMatrixCompatibilityCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String string = Registry.stringValue((String)"gradle.compatibility.config.url");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        String url = string;
        long expectedUpdateTime = System.currentTimeMillis() - Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)Registry.intValue((String)"gradle.compatibility.update.interval"), (DurationUnit)DurationUnit.SECONDS));
        String string2 = HttpRequests.request((String)url).productNameAsUserAgent().readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        String json = string2;
        String string3 = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullVersion(...)");
        IdeVersionedDataState ideVersionedDataState = GradleCompatibilityDataParser.INSTANCE.parseVersionedJson(json, string3);
        Intrinsics.checkNotNull((Object)ideVersionedDataState);
        GradleCompatibilityState expected2 = (GradleCompatibilityState)ideVersionedDataState;
        IdeVersionedDataState ideVersionedDataState2 = GradleJvmSupportMatrix.Companion.getInstance().getState();
        Intrinsics.checkNotNull((Object)ideVersionedDataState2);
        GradleCompatibilityState actual = (GradleCompatibilityState)ideVersionedDataState2;
        if (!actual.getSupportedGradleVersions().containsAll(expected2.getSupportedGradleVersions())) {
            throw new IllegalStateException("Supported gradle versions Expected: " + expected2.getSupportedGradleVersions() + " but " + actual.getSupportedGradleVersions() + " ");
        }
        if (!actual.getSupportedJavaVersions().containsAll(expected2.getSupportedJavaVersions())) {
            throw new IllegalStateException("Supported java versions Expected: " + expected2.getSupportedJavaVersions() + " but " + actual.getSupportedJavaVersions() + " ");
        }
        if (!actual.getCompatibility().containsAll(expected2.getCompatibility())) {
            throw new IllegalStateException("Compatibility Expected: " + expected2.getCompatibility() + " but " + actual.getCompatibility() + " ");
        }
        if (actual.getLastUpdateTime() < expectedUpdateTime) {
            throw new IllegalStateException("Last update time less then expected");
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/performanceTesting/ValidateGradleMatrixCompatibilityCommand$Companion;", "", "()V", "NAME", "", "PREFIX", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

