/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\u0013H\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0003*\u00020\u0013H\u0000\u001a\u000e\u0010\u0018\u001a\u00020\u0005*\u0004\u0018\u00010\u0019H\u0000\u001a\u000e\u0010\u001a\u001a\u00020\u0005*\u0004\u0018\u00010\u001bH\u0000\"\u001c\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u001f\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"DECLARATION_ALTERNATIVES", "Lcom/intellij/openapi/util/Key;", "", "", "DELEGATED_TYPE", "", "getDELEGATED_TYPE", "()Lcom/intellij/openapi/util/Key;", "projectTypeKey", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectAwareType;", "getProjectTypeKey", "saveProjectType", "Lcom/intellij/patterns/PatternCondition;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "getSaveProjectType", "()Lcom/intellij/patterns/PatternCondition;", "module", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/psi/PsiElement;", "getModule", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/module/Module;", "getLinkedGradleProjectPath", "getRootGradleProjectPath", "isGradleScript", "Lcom/intellij/psi/PsiFile;", "isResolvedInGradleScript", "Lcom/intellij/psi/PsiClass;", "intellij.gradle.java"})
public final class UtilKt {
    @NotNull
    private static final Key<GradleProjectAwareType> projectTypeKey;
    @NotNull
    private static final PatternCondition<GroovyMethodResult> saveProjectType;
    @NotNull
    private static final Key<Boolean> DELEGATED_TYPE;
    @JvmField
    @NotNull
    public static final Key<List<String>> DECLARATION_ALTERNATIVES;

    @NotNull
    public static final Key<GradleProjectAwareType> getProjectTypeKey() {
        return projectTypeKey;
    }

    @NotNull
    public static final PatternCondition<GroovyMethodResult> getSaveProjectType() {
        return saveProjectType;
    }

    @NotNull
    public static final Key<Boolean> getDELEGATED_TYPE() {
        return DELEGATED_TYPE;
    }

    public static final boolean isResolvedInGradleScript(@Nullable PsiClass $this$isResolvedInGradleScript) {
        return $this$isResolvedInGradleScript instanceof GroovyScriptClass && UtilKt.isGradleScript((PsiFile)((GroovyScriptClass)$this$isResolvedInGradleScript).getContainingFile());
    }

    public static final boolean isGradleScript(@Nullable PsiFile $this$isGradleScript) {
        PsiFile psiFile = $this$isGradleScript;
        return Intrinsics.areEqual(psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getExtension() : null, (Object)"gradle");
    }

    private static final Module getModule(PsiElement $this$module) {
        Module module;
        PsiFile psiFile = $this$module.getContainingFile();
        if (psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = psiFile.getVirtualFile()) != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            module = ProjectFileIndex.getInstance((Project)$this$module.getProject()).getModuleForFile((VirtualFile)it);
        } else {
            module = null;
        }
        return module;
    }

    @Nullable
    public static final String getLinkedGradleProjectPath(@NotNull PsiElement $this$getLinkedGradleProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinkedGradleProjectPath, (String)"<this>");
        return ExternalSystemApiUtil.getExternalProjectPath((Module)UtilKt.getModule($this$getLinkedGradleProjectPath));
    }

    @Nullable
    public static final String getRootGradleProjectPath(@NotNull PsiElement $this$getRootGradleProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getRootGradleProjectPath, (String)"<this>");
        return ExternalSystemApiUtil.getExternalRootProjectPath((Module)UtilKt.getModule($this$getRootGradleProjectPath));
    }

    static {
        Key key = Key.create((String)"gradle.current.project");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        projectTypeKey = key;
        saveProjectType = (PatternCondition)new PatternCondition<GroovyMethodResult>(){

            public boolean accepts(@NotNull GroovyMethodResult result, @Nullable ProcessingContext context) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    ProcessingContext processingContext = context;
                    if (processingContext == null) break block0;
                    GroovyMethodCandidate groovyMethodCandidate = result.getCandidate();
                    PsiType psiType = groovyMethodCandidate != null ? groovyMethodCandidate.getReceiverType() : null;
                    processingContext.put(UtilKt.getProjectTypeKey(), (Object)((Object)(psiType instanceof GradleProjectAwareType ? (GradleProjectAwareType)psiType : null)));
                }
                return true;
            }
        };
        Key key2 = Key.create((String)"gradle.delegated.type");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DELEGATED_TYPE = key2;
        Key key3 = Key.create((String)"gradle.declaration.alternatives");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        DECLARATION_ALTERNATIVES = key3;
    }
}

