/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalInputStream;", "Ljava/io/InputStream;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdTerminalSession;)V", "buffer", "Ljava/util/ArrayDeque;", "", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "read", "", "b", "", "off", "len", "waitData", "", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalInputStream
extends InputStream {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ArrayDeque<Byte> buffer;
    @NotNull
    private final Semaphore semaphore;

    public ThinClientTerminalInputStream(@NotNull Lifetime lifetime, final @NotNull RdTerminalSession model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.lifetime = lifetime;
        this.buffer = new ArrayDeque(1000);
        this.semaphore = new Semaphore();
        model.getOutput().advise(this.lifetime, (Function1)new Function1<List<? extends Byte>, Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull List<Byte> bytes) {
                Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
                if (!Intrinsics.areEqual((Object)model.getShared().getValueOrNull(), (Object)true)) {
                    return;
                }
                if (bytes.isEmpty()) {
                    return;
                }
                ArrayDeque arrayDeque = buffer;
                ThinClientTerminalInputStream thinClientTerminalInputStream = this;
                ArrayDeque arrayDeque2 = arrayDeque;
                synchronized (arrayDeque2) {
                    boolean bl = false;
                    Iterator<Byte> iterator = bytes.iterator();
                    while (iterator.hasNext()) {
                        byte b = ((Number)iterator.next()).byteValue();
                        thinClientTerminalInputStream.buffer.addLast(b);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                semaphore.up();
            }
        });
        model.getOutputConnected().set((Object)true);
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                semaphore.up();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        this.waitData();
        ArrayDeque<Byte> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            boolean bl = false;
            byte by = ((Number)this.buffer.removeFirst()).byteValue();
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.waitData();
        ArrayDeque<Byte> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            int index;
            boolean bl = false;
            for (index = 0; this.buffer.size() > 0 && index < len; ++index) {
                byte bb;
                Byte by;
                Byte by2 = by = this.buffer.removeFirst();
                if (by2 == null) break;
                Intrinsics.checkNotNull((Object)by2);
                b[off + index] = bb = by.byteValue();
            }
            int n = index > 0 ? index : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitData() {
        ArrayDeque<Byte> arrayDeque;
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        ArrayDeque<Byte> arrayDeque2 = arrayDeque = this.buffer;
        synchronized (arrayDeque2) {
            boolean bl = false;
            if (this.buffer.size() > 0) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.semaphore.down();
            this.semaphore.waitFor();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }
}

