/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.modcommand.ModCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.binding.FieldFormReference;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.binding.FormEnumConstantReference;
import com.intellij.uiDesigner.binding.FormPackageReference;
import com.intellij.uiDesigner.binding.ResourceBundleFileReference;
import com.intellij.uiDesigner.binding.ResourceBundleKeyReference;
import com.intellij.uiDesigner.binding.ResourceFileReference;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(FormReferenceProvider.class);
    private static final Key<CachedValue<CachedFormData>> CACHED_DATA = Key.create((String)"Cached form reference");

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            FormReferenceProvider.$$$reportNull$$$0(0);
        }
        return target instanceof PsiClass || target instanceof PsiPackage || target instanceof PsiField || target instanceof PsiFile || PropertyReferenceBase.isPropertyPsi((PsiElement)target);
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiPlainTextFile plainTextFile;
        if (element == null) {
            FormReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            FormReferenceProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiPlainTextFile && (plainTextFile = (PsiPlainTextFile)element).getFileType().equals(GuiFormFileType.INSTANCE)) {
            if (FormReferenceProvider.getCachedData((PsiPlainTextFile)plainTextFile).myReferences == null) {
                FormReferenceProvider.$$$reportNull$$$0(3);
            }
            return FormReferenceProvider.getCachedData((PsiPlainTextFile)plainTextFile).myReferences;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            FormReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiFile getFormFile(PsiField field) {
        PsiReference ref = FormReferenceProvider.getFormReference(field);
        if (ref != null) {
            return ref.getElement().getContainingFile();
        }
        return null;
    }

    @Nullable
    public static PsiReference getFormReference(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && containingClass.getQualifiedName() != null) {
            List<PsiFile> forms = FormClassIndex.findFormsBoundToClass(containingClass.getProject(), containingClass);
            for (PsiFile formFile : forms) {
                PsiReference[] refs;
                for (PsiReference ref : refs = formFile.getReferences()) {
                    if (!ref.isReferenceTo((PsiElement)field)) continue;
                    return ref;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getGUIComponentType(PsiPlainTextFile file, String fieldName) {
        Map<String, Pair<PsiType, TextRange>> fieldNameToTypeMap = FormReferenceProvider.getCachedData((PsiPlainTextFile)file).myFieldNameToTypeMap;
        Pair<PsiType, TextRange> typeRangePair = fieldNameToTypeMap.get(fieldName);
        return (PsiType)Pair.getFirst(typeRangePair);
    }

    public static ModCommand setGUIComponentType(PsiPlainTextFile file, String fieldName, String typeText) {
        TextRange range;
        Map<String, Pair<PsiType, TextRange>> fieldNameToTypeMap = FormReferenceProvider.getCachedData((PsiPlainTextFile)file).myFieldNameToTypeMap;
        Pair<PsiType, TextRange> typeRangePair = fieldNameToTypeMap.get(fieldName);
        if (typeRangePair != null && (range = (TextRange)typeRangePair.getSecond()) != null) {
            return ModCommand.psiUpdate((PsiElement)file, f -> f.getViewProvider().getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)typeText));
        }
        return ModCommand.nop();
    }

    private static void processReferences(PsiPlainTextFile file, PsiReferenceProcessor processor) {
        Project project = file.getProject();
        XmlTag rootTag = (XmlTag)ReadAction.compute(() -> {
            XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.xml", (FileType)XmlFileType.INSTANCE, file.getViewProvider().getContents());
            return xmlFile.getRootTag();
        });
        if (rootTag == null || !"http://www.intellij.com/uidesigner/form/".equals(rootTag.getNamespace())) {
            return;
        }
        @NonNls String name = rootTag.getName();
        if (!"form".equals(name)) {
            return;
        }
        PsiReference classReference = null;
        XmlAttribute classToBind = rootTag.getAttribute("bind-to-class", null);
        if (classToBind != null) {
            XmlAttributeValue valueElement = classToBind.getValueElement();
            if (valueElement == null) {
                return;
            }
            String className = valueElement.getValue().replace('$', '.');
            PsiReference[] referencesByString = new JavaClassReferenceProvider().getReferencesByString(className, (PsiElement)file, valueElement.getTextRange().getStartOffset() + 1);
            if (referencesByString.length < 1) {
                return;
            }
            for (PsiReference aReferencesByString : referencesByString) {
                processor.execute(aReferencesByString);
            }
            classReference = referencesByString[referencesByString.length - 1];
        }
        FormReferenceProvider.processReferences(rootTag, classReference, file, processor);
    }

    private static TextRange getValueRange(XmlAttribute classToBind) {
        XmlAttributeValue valueElement = classToBind.getValueElement();
        TextRange textRange = valueElement.getTextRange();
        return new TextRange(textRange.getStartOffset() + 1, textRange.getEndOffset() - 1);
    }

    private static void processReferences(XmlTag tag, PsiReference classReference, PsiPlainTextFile file, PsiReferenceProcessor processor) {
        XmlTag[] subtags;
        String className;
        XmlTag componentTag;
        XmlTag parentTag;
        XmlAttribute clsAttribute = tag.getAttribute("class", null);
        String classNameStr = clsAttribute != null ? clsAttribute.getValue().replace('$', '.') : null;
        XmlAttribute bindingAttribute = tag.getAttribute("binding", null);
        if (bindingAttribute != null && classReference != null) {
            XmlAttribute customCreateAttribute = tag.getAttribute("custom-create", null);
            boolean customCreate = customCreateAttribute != null && Boolean.parseBoolean(customCreateAttribute.getValue());
            TextRange nameRange = clsAttribute != null ? FormReferenceProvider.getValueRange(clsAttribute) : null;
            processor.execute((PsiReference)new FieldFormReference(file, classReference, FormReferenceProvider.getValueRange(bindingAttribute), classNameStr, nameRange, customCreate));
        }
        XmlAttribute titleBundleAttribute = tag.getAttribute("title-resource-bundle", null);
        PsiReference[] titleKeyAttribute = tag.getAttribute("title-key", null);
        if (titleBundleAttribute != null && titleKeyAttribute != null) {
            FormReferenceProvider.processResourceBundleFileReferences(file, processor, titleBundleAttribute);
            processor.execute((PsiReference)new ResourceBundleKeyReference(file, titleBundleAttribute.getValue(), FormReferenceProvider.getValueRange((XmlAttribute)titleKeyAttribute)));
        }
        XmlAttribute bundleAttribute = tag.getAttribute("resource-bundle", null);
        XmlAttribute keyAttribute = tag.getAttribute("key", null);
        if (bundleAttribute != null && keyAttribute != null) {
            FormReferenceProvider.processResourceBundleFileReferences(file, processor, bundleAttribute);
            processor.execute((PsiReference)new ResourceBundleKeyReference(file, bundleAttribute.getValue(), FormReferenceProvider.getValueRange(keyAttribute)));
        }
        FormReferenceProvider.processNestedFormReference(tag, processor, file);
        FormReferenceProvider.processButtonGroupReference(tag, processor, file, classReference);
        if (clsAttribute != null) {
            JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
            PsiReference[] referencesByString = provider.getReferencesByString(classNameStr, (PsiElement)file, clsAttribute.getValueElement().getTextRange().getStartOffset() + 1);
            if (referencesByString.length < 1) {
                return;
            }
            for (PsiReference aReferencesByString : referencesByString) {
                processor.execute(aReferencesByString);
            }
        }
        if ((parentTag = tag.getParentTag()) != null && parentTag.getName().equals("properties") && (componentTag = parentTag.getParentTag()) != null && (className = componentTag.getAttributeValue("class", "http://www.intellij.com/uidesigner/form/")) != null) {
            FormReferenceProvider.processPropertyReference(tag, processor, file, className.replace('$', '.'));
        }
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            FormReferenceProvider.processReferences(subtag, classReference, file, processor);
        }
    }

    private static void processResourceBundleFileReferences(PsiPlainTextFile file, PsiReferenceProcessor processor, XmlAttribute titleBundleAttribute) {
        FormReferenceProvider.processPackageReferences(file, processor, titleBundleAttribute);
        processor.execute((PsiReference)new ResourceBundleFileReference(file, FormReferenceProvider.getValueRange(titleBundleAttribute)));
    }

    private static void processPackageReferences(PsiPlainTextFile file, PsiReferenceProcessor processor, XmlAttribute attribute) {
        TextRange valueRange = FormReferenceProvider.getValueRange(attribute);
        String value = attribute.getValue();
        int pos = -1;
        while ((pos = value.indexOf(47, pos + 1)) >= 0) {
            processor.execute((PsiReference)new FormPackageReference(file, new TextRange(valueRange.getStartOffset(), valueRange.getStartOffset() + pos)));
        }
    }

    private static void processNestedFormReference(XmlTag tag, PsiReferenceProcessor processor, PsiPlainTextFile file) {
        XmlAttribute formFileAttribute = tag.getAttribute("form-file", null);
        if (formFileAttribute != null) {
            FormReferenceProvider.processPackageReferences(file, processor, formFileAttribute);
            processor.execute((PsiReference)new ResourceFileReference(file, FormReferenceProvider.getValueRange(formFileAttribute)));
        }
    }

    private static void processButtonGroupReference(XmlTag tag, PsiReferenceProcessor processor, PsiPlainTextFile file, PsiReference classReference) {
        XmlAttribute boundAttribute = tag.getAttribute("bound", null);
        XmlAttribute nameAttribute = tag.getAttribute("name", null);
        if (boundAttribute != null && Boolean.parseBoolean(boundAttribute.getValue()) && nameAttribute != null) {
            processor.execute((PsiReference)new FieldFormReference(file, classReference, FormReferenceProvider.getValueRange(nameAttribute), null, null, false));
        }
    }

    private static void processPropertyReference(XmlTag tag, PsiReferenceProcessor processor, PsiPlainTextFile file, String className) {
        PsiReference reference;
        XmlAttribute valueAttribute = tag.getAttribute("value", null);
        if (valueAttribute != null && (reference = (PsiReference)ReadAction.compute(() -> {
            PsiClassType propClassType;
            PsiClass propClass;
            PsiType returnType;
            PsiMethod getter;
            GlobalSearchScope scope;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)file.getProject());
            PsiClass psiClass = psiFacade.findClass(className, scope = file.getResolveScope());
            if (psiClass != null && (getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)tag.getName(), (boolean)false, (boolean)true)) != null && (returnType = getter.getReturnType()) instanceof PsiClassType && (propClass = (propClassType = (PsiClassType)returnType).resolve()) != null) {
                if (propClass.isEnum()) {
                    return new FormEnumConstantReference(file, FormReferenceProvider.getValueRange(valueAttribute), propClassType);
                }
                PsiClass iconClass = psiFacade.findClass("javax.swing.Icon", scope);
                if (iconClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)propClass, (PsiClass)iconClass, (boolean)true)) {
                    return new ResourceFileReference(file, FormReferenceProvider.getValueRange(valueAttribute));
                }
            }
            return null;
        })) != null) {
            if (reference instanceof ResourceFileReference) {
                FormReferenceProvider.processPackageReferences(file, processor, valueAttribute);
            }
            processor.execute(reference);
        }
    }

    @Nullable
    public static String getBundleName(PropertiesFile propertiesFile) {
        PsiDirectory directory = propertiesFile.getParent();
        if (directory == null) {
            return null;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String packageName = aPackage == null ? "" : aPackage.getQualifiedName();
        Object bundleName = propertiesFile.getResourceBundle().getBaseName();
        if (!packageName.isEmpty()) {
            bundleName = packageName + "." + (String)bundleName;
        }
        bundleName = ((String)bundleName).replace('.', '/');
        return bundleName;
    }

    private static CachedFormData getCachedData(final PsiPlainTextFile element) {
        CachedValue data = (CachedValue)element.getUserData(CACHED_DATA);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<CachedFormData>(){
                final Map<String, Pair<PsiType, TextRange>> map = new HashMap<String, Pair<PsiType, TextRange>>();

                public CachedValueProvider.Result<CachedFormData> compute() {
                    PsiReferenceProcessor.CollectElements processor = new PsiReferenceProcessor.CollectElements(){

                        public boolean execute(PsiReference ref) {
                            FieldFormReference fieldRef;
                            String componentClassName;
                            if (ref instanceof FieldFormReference && (componentClassName = (fieldRef = (FieldFormReference)ref).getComponentClassName()) != null) {
                                PsiClassType type = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createTypeByFQClassName(componentClassName, element.getResolveScope());
                                map.put(fieldRef.getRangeText(), (Pair<PsiType, TextRange>)new Pair((Object)type, (Object)fieldRef.getComponentClassNameTextRange()));
                            }
                            return super.execute(ref);
                        }
                    };
                    FormReferenceProvider.processReferences(element, (PsiReferenceProcessor)processor);
                    PsiReference[] refs = processor.toArray(PsiReference.EMPTY_ARRAY);
                    return new CachedValueProvider.Result((Object)new CachedFormData(refs, this.map), new Object[]{element});
                }
            }, false);
            element.putUserData(CACHED_DATA, (Object)data);
        }
        return (CachedFormData)data.getValue();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        return "FormReferenceProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/FormReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/FormReferenceProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class CachedFormData {
        PsiReference[] myReferences;
        Map<String, Pair<PsiType, TextRange>> myFieldNameToTypeMap;

        CachedFormData(PsiReference[] refs, Map<String, Pair<PsiType, TextRange>> map) {
            this.myReferences = refs;
            this.myFieldNameToTypeMap = map;
        }
    }
}

