/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.make.BindingsCache;
import com.intellij.uiDesigner.make.FormElementNavigatable;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.java.CopyResourcesUtil;

public final class Form2SourceCompiler
implements SourceInstrumentingCompiler {
    private static VirtualFile findSourceFile(CompileContext context, VirtualFile formFile, String className) {
        Module module2 = context.getModuleByFile(formFile);
        if (module2 == null) {
            return null;
        }
        PsiClass aClass = FormEditingUtil.findClassToBind(module2, className);
        if (aClass == null) {
            return null;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    @NotNull
    public String getDescription() {
        String string = UIDesignerBundle.message("component.gui.designer.form.to.source.compiler", new Object[0]);
        if (string == null) {
            Form2SourceCompiler.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    FileProcessingCompiler.ProcessingItem @NotNull [] getProcessingItems(@NotNull CompileContext context) {
        if (context == null) {
            Form2SourceCompiler.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        if (GuiDesignerConfiguration.getInstance((Project)project).INSTRUMENT_CLASSES) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                Form2SourceCompiler.$$$reportNull$$$0(2);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ArrayList items = new ArrayList();
        DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            CompileScope scope = context.getCompileScope();
            CompileScope projectScope = context.getProjectCompileScope();
            VirtualFile[] formFiles = projectScope.getFiles((FileType)GuiFormFileType.INSTANCE, true);
            CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
            try (BindingsCache bindingsCache = new BindingsCache(project);){
                HashMap<String, VirtualFile> class2form = new HashMap<String, VirtualFile>();
                for (VirtualFile formFile : formFiles) {
                    String classToBind;
                    if (compilerManager.isExcludedFromCompilation(formFile)) continue;
                    try {
                        classToBind = bindingsCache.getBoundClassName(formFile);
                    }
                    catch (AlienFormFileException e) {
                        continue;
                    }
                    catch (Exception e) {
                        Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.cannot.process.form.file", e)), formFile);
                        continue;
                    }
                    if (classToBind == null) continue;
                    VirtualFile sourceFile = Form2SourceCompiler.findSourceFile(context, formFile, classToBind);
                    if (sourceFile == null) {
                        if (!scope.belongs(formFile.getUrl())) continue;
                        Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.class.to.bind.does.not.exist", classToBind)), formFile);
                        continue;
                    }
                    boolean inScope = scope.belongs(sourceFile.getUrl()) || scope.belongs(formFile.getUrl());
                    VirtualFile alreadyProcessedForm = (VirtualFile)class2form.get(classToBind);
                    if (alreadyProcessedForm != null) {
                        if (!inScope) continue;
                        Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.duplicate.bind", classToBind, alreadyProcessedForm.getPresentableUrl())), formFile);
                        continue;
                    }
                    class2form.put(classToBind, formFile);
                    if (!inScope) continue;
                    items.add(new MyInstrumentationItem(sourceFile, formFile));
                }
            }
        });
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        if (processingItemArray == null) {
            Form2SourceCompiler.$$$reportNull$$$0(3);
        }
        return processingItemArray;
    }

    public FileProcessingCompiler.ProcessingItem[] process(@NotNull CompileContext context, // Could not load outer class - annotation placement on inner may be incorrect
    FileProcessingCompiler.ProcessingItem @NotNull [] items) {
        if (context == null) {
            Form2SourceCompiler.$$$reportNull$$$0(4);
        }
        if (items == null) {
            Form2SourceCompiler.$$$reportNull$$$0(5);
        }
        ArrayList compiledItems = new ArrayList();
        context.getProgressIndicator().setText(UIDesignerBundle.message("progress.compiling.ui.forms", new Object[0]));
        int formsProcessed = 0;
        Project project = context.getProject();
        FormSourceCodeGenerator generator = new FormSourceCodeGenerator(project);
        HashSet processedModules = new HashSet();
        ArrayList filesToRefresh = new ArrayList();
        for (FileProcessingCompiler.ProcessingItem item1 : items) {
            context.getProgressIndicator().setFraction((double)(++formsProcessed) / (double)items.length);
            MyInstrumentationItem item = (MyInstrumentationItem)item1;
            VirtualFile formFile = item.getFormFile();
            if (GuiDesignerConfiguration.getInstance((Project)project).COPY_FORMS_RUNTIME_TO_OUTPUT) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)formFile, (Project)project);
                    if (module2 != null && !processedModules.contains(module2)) {
                        processedModules.add(module2);
                        String moduleOutputPath = CompilerPaths.getModuleOutputPath((Module)module2, (boolean)false);
                        try {
                            String testsOutputPath;
                            if (moduleOutputPath != null) {
                                filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)moduleOutputPath, (boolean)false));
                            }
                            if ((testsOutputPath = CompilerPaths.getModuleOutputPath((Module)module2, (boolean)true)) != null && !testsOutputPath.equals(moduleOutputPath)) {
                                filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)testsOutputPath, (boolean)false));
                            }
                        }
                        catch (IOException e) {
                            Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.cannot.copy.gui.designer.form.runtime", module2.getName(), e.toString())), null);
                        }
                    }
                });
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    generator.generate(formFile);
                    ArrayList<FormErrorInfo> errors = generator.getErrors();
                    if (errors.isEmpty()) {
                        compiledItems.add(item);
                    } else {
                        for (FormErrorInfo e : errors) {
                            Form2SourceCompiler.addError(context, e, formFile);
                        }
                    }
                }), "", null);
                FileDocumentManager.getInstance().saveAllDocuments();
            }, ModalityState.nonModal());
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return compiledItems.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
    }

    private static void addError(CompileContext context, FormErrorInfo e, VirtualFile formFile) {
        @NlsSafe String message = e.getErrorMessage();
        if (formFile != null) {
            FormElementNavigatable navigatable = new FormElementNavigatable(context.getProject(), formFile, e.getComponentId());
            context.addMessage(CompilerMessageCategory.ERROR, formFile.getPresentableUrl() + ": " + message, formFile.getUrl(), -1, -1, (Navigatable)navigatable);
        } else {
            context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
        }
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return TimestampValidityState.load((DataInput)in);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/make/Form2SourceCompiler";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/make/Form2SourceCompiler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingItems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProcessingItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyInstrumentationItem
    implements FileProcessingCompiler.ProcessingItem {
        @NotNull
        private final VirtualFile mySourceFile;
        private final VirtualFile myFormFile;
        private final TimestampValidityState myState;

        MyInstrumentationItem(@NotNull VirtualFile sourceFile, VirtualFile formFile) {
            if (sourceFile == null) {
                MyInstrumentationItem.$$$reportNull$$$0(0);
            }
            this.mySourceFile = sourceFile;
            this.myFormFile = formFile;
            this.myState = new TimestampValidityState(formFile.getTimeStamp());
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.mySourceFile;
            if (virtualFile == null) {
                MyInstrumentationItem.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public VirtualFile getFormFile() {
            return this.myFormFile;
        }

        public ValidityState getValidityState() {
            return this.myState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/make/Form2SourceCompiler$MyInstrumentationItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/make/Form2SourceCompiler$MyInstrumentationItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

