/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.ClassUtil;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PsiNestedFormLoader
implements NestedFormLoader {
    protected Module myModule;
    private final Map<String, LwRootContainer> myFormCache = new HashMap<String, LwRootContainer>();

    public PsiNestedFormLoader(Module module2) {
        this.myModule = module2;
    }

    public LwRootContainer loadForm(String formFileName) throws Exception {
        if (this.myFormCache.containsKey(formFileName)) {
            return this.myFormCache.get(formFileName);
        }
        VirtualFile formFile = ResourceFileUtil.findResourceFileInDependents((Module)this.myModule, (String)formFileName);
        if (formFile == null) {
            throw new Exception("Could not find nested form file " + formFileName);
        }
        LwRootContainer container = Utils.getRootContainer((InputStream)formFile.getInputStream(), (PropertiesProvider)new PsiPropertiesProvider(this.myModule));
        this.myFormCache.put(formFileName, container);
        return container;
    }

    public String getClassToBindName(LwRootContainer container) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findClass(container.getClassToBind(), this.myModule.getModuleWithDependenciesScope());
        if (psiClass != null) {
            return ClassUtil.getJVMClassName((PsiClass)psiClass);
        }
        return container.getClassToBind();
    }
}

