/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogOutputParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenOutputParserProvider;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;

@ApiStatus.Experimental
public class MavenBuildEventProcessor
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    @NotNull
    private final BuildProgressListener myBuildProgressListener;
    @NotNull
    private final BuildOutputInstantReaderImpl myInstantReader;
    @NotNull
    private final MavenLogOutputParser myParser;
    private boolean closed;
    private final BuildDescriptor myDescriptor;
    @NotNull
    private final Function<MavenParsingContext, StartBuildEvent> myStartBuildEventSupplier;

    public MavenBuildEventProcessor(@NotNull MavenRunConfiguration runConfiguration, @NotNull BuildProgressListener buildProgressListener, @NotNull BuildDescriptor descriptor2, @NotNull ExternalSystemTaskId taskId, @NotNull Function<String, String> targetFileMapper, @Nullable Function<MavenParsingContext, StartBuildEvent> startBuildEventSupplier) {
        if (runConfiguration == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(0);
        }
        if (buildProgressListener == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(2);
        }
        if (taskId == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(3);
        }
        if (targetFileMapper == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(4);
        }
        this.closed = false;
        this.myBuildProgressListener = buildProgressListener;
        this.myDescriptor = descriptor2;
        this.myStartBuildEventSupplier = startBuildEventSupplier != null ? startBuildEventSupplier : ctx -> new StartBuildEventImpl(this.myDescriptor, "");
        this.myParser = MavenOutputParserProvider.createMavenOutputParser(runConfiguration, taskId, targetFileMapper);
        this.myInstantReader = new BuildOutputInstantReaderImpl((Object)taskId, (Object)taskId, this.myBuildProgressListener, Collections.singletonList(this.myParser));
    }

    public synchronized void finish() {
        this.myParser.finish(e -> this.myBuildProgressListener.onEvent(this.myDescriptor.getId(), e));
        this.myInstantReader.close();
        this.closed = true;
    }

    public void start() {
        StartBuildEvent startEvent = this.myStartBuildEventSupplier.apply(this.getParsingContext());
        this.myBuildProgressListener.onEvent(this.myDescriptor.getId(), (BuildEvent)startEvent);
    }

    public synchronized void onTextAvailable(String text2, boolean stdError) {
        if (!this.closed) {
            this.myInstantReader.append((CharSequence)text2);
        }
    }

    public MavenParsingContext getParsingContext() {
        return this.myParser.getParsingContext();
    }

    public void coloredTextAvailable(@NotNull String text2, @NotNull Key outputType) {
        if (text2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(6);
        }
        this.onTextAvailable(text2, ProcessOutputType.isStderr((Key)outputType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgressListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileMapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/buildtool/MavenBuildEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

