/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\b\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenDuplicateDependenciesInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "addProblem", "", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "dependencies", "", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "checkDependencies", "projectModel", "checkFileElement", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "checkManagedDependencies", "collect", "duplicates", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/idea/maven/dom/DependencyConflictId;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependencies;", "createLinkText", "", "model", "dependencyToString", "d", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getDuplicateDependenciesMap", "getGroupDisplayName", "getShortName", "scope", "intellij.maven"})
public final class MavenDuplicateDependenciesInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicateDependenciesInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        DomElement domElement = domFileElement.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domElement;
        this.checkManagedDependencies(projectModel, holder);
        this.checkDependencies(projectModel, holder);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenDuplicateDependenciesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    private final void checkDependencies(MavenDomProjectModel projectModel, DomElementAnnotationHolder holder) {
        MultiMap<DependencyConflictId, MavenDomDependency> allDuplicates = this.getDuplicateDependenciesMap(projectModel);
        for (MavenDomDependency dependency : projectModel.getDependencies().getDependencies()) {
            Collection dependencies;
            DependencyConflictId id = DependencyConflictId.create(dependency);
            if (id == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)allDuplicates.get((Object)id), (String)"get(...)");
            if (dependencies.size() <= 1) continue;
            List duplicateDependencies = new ArrayList();
            for (MavenDomDependency d : dependencies) {
                if (d == dependency) continue;
                DomElement dependencyParent = dependency.getParent();
                if (d.getParent() == dependencyParent) {
                    List<MavenDomDependency> siblingDependencies;
                    Intrinsics.checkNotNull((Object)d);
                    String string = this.dependencyToString(d);
                    Intrinsics.checkNotNull((Object)dependency);
                    MavenLog.LOG.debug("Duplicate dependencies in the same file: " + string + ", " + this.dependencyToString(dependency));
                    Intrinsics.checkNotNull((Object)dependencyParent, (String)"null cannot be cast to non-null type org.jetbrains.idea.maven.dom.model.MavenDomDependencies");
                    Intrinsics.checkNotNullExpressionValue(((MavenDomDependencies)dependencyParent).getDependencies(), (String)"getDependencies(...)");
                    MavenLog.LOG.debug("Sibling dependencies: " + siblingDependencies.size());
                    if (!siblingDependencies.contains(d)) continue;
                    duplicateDependencies.add(d);
                    continue;
                }
                Intrinsics.checkNotNull((Object)d);
                String string = this.scope(d);
                Intrinsics.checkNotNull((Object)dependency);
                if (!Intrinsics.areEqual((Object)string, (Object)this.scope(dependency)) || !Intrinsics.areEqual((Object)d.getVersion().getStringValue(), (Object)dependency.getVersion().getStringValue())) continue;
                MavenLog.LOG.debug("Duplicate dependencies in different files: " + this.dependencyToString(d) + ", " + this.dependencyToString(dependency));
                duplicateDependencies.add(d);
            }
            if (duplicateDependencies.size() <= 0) continue;
            Intrinsics.checkNotNull((Object)dependency);
            this.addProblem(dependency, duplicateDependencies, holder);
        }
    }

    private final String dependencyToString(MavenDomDependency d) {
        return d.getGroupId().getStringValue() + ":" + d.getArtifactId().getStringValue() + ":" + d.getVersion().getStringValue();
    }

    private final String scope(MavenDomDependency dependency) {
        String res = dependency.getScope().getRawText();
        CharSequence charSequence = res;
        if (charSequence == null || charSequence.length() == 0) {
            return "compile";
        }
        return res;
    }

    private final void addProblem(MavenDomDependency dependency, Collection<? extends MavenDomDependency> dependencies, DomElementAnnotationHolder holder) {
        Set processed = new HashSet();
        List links = new ArrayList();
        for (MavenDomDependency mavenDomDependency : dependencies) {
            MavenDomProjectModel model;
            if (Intrinsics.areEqual((Object)dependency, (Object)mavenDomDependency) || (model = (MavenDomProjectModel)mavenDomDependency.getParentOfType(MavenDomProjectModel.class, false)) == null || processed.contains(model)) continue;
            links.add(this.createLinkText(model, mavenDomDependency));
            processed.add(model);
        }
        CollectionsKt.sort((List)links);
        Object[] objectArray = new Object[]{NlsMessages.formatAndList((Collection)links)};
        holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenDomBundle.message("MavenDuplicateDependenciesInspection.has.duplicates", objectArray));
    }

    private final String createLinkText(MavenDomProjectModel model, MavenDomDependency dependency) {
        VirtualFile file;
        String string = MavenDomUtil.getProjectName(model);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectName(...)");
        String projectName = string;
        XmlTag tag = dependency.getXmlTag();
        XmlTag xmlTag = tag;
        VirtualFile virtualFile = xmlTag != null && (xmlTag = xmlTag.getContainingFile()) != null ? xmlTag.getVirtualFile() : (file = null);
        if (file == null) {
            return projectName;
        }
        return "<a href ='#navigation/" + file.getPath() + ":" + tag.getTextRange().getStartOffset() + "'>" + projectName + "</a>";
    }

    private final MultiMap<DependencyConflictId, MavenDomDependency> getDuplicateDependenciesMap(MavenDomProjectModel projectModel) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap allDependencies = multiMap;
        Processor collectProcessor = arg_0 -> MavenDuplicateDependenciesInspection.getDuplicateDependenciesMap$lambda$0(this, allDependencies, arg_0);
        MavenDomProjectProcessorUtils.processChildrenRecursively(projectModel, (Processor<? super MavenDomProjectModel>)collectProcessor, true);
        MavenDomProjectProcessorUtils.processParentProjects(projectModel, (Processor<? super MavenDomProjectModel>)collectProcessor);
        return allDependencies;
    }

    private final void collect(MultiMap<DependencyConflictId, MavenDomDependency> duplicates, MavenDomDependencies dependencies) {
        for (MavenDomDependency dependency : dependencies.getDependencies()) {
            DependencyConflictId mavenId2 = DependencyConflictId.create(dependency);
            if (mavenId2 == null) continue;
            duplicates.putValue((Object)mavenId2, (Object)dependency);
        }
    }

    private final void checkManagedDependencies(MavenDomProjectModel projectModel, DomElementAnnotationHolder holder) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap duplicates = multiMap;
        MavenDomDependencies mavenDomDependencies = projectModel.getDependencyManagement().getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
        this.collect((MultiMap<DependencyConflictId, MavenDomDependency>)duplicates, mavenDomDependencies);
        for (Map.Entry entry : duplicates.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            Collection set2 = (Collection)entry.getValue();
            if (set2.size() <= 1) continue;
            for (MavenDomDependency dependency : set2) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenProjectBundle.message("inspection.message.duplicated.dependency", new Object[0]));
            }
        }
    }

    private static final boolean getDuplicateDependenciesMap$lambda$0(MavenDuplicateDependenciesInspection this$0, MultiMap $allDependencies, MavenDomProjectModel model) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$allDependencies, (String)"$allDependencies");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MavenDomDependencies mavenDomDependencies = model.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
        this$0.collect((MultiMap<DependencyConflictId, MavenDomDependency>)$allDependencies, mavenDomDependencies);
        return false;
    }
}

