/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenModulePathMapper {
    public static void resolveModulePaths(Collection<MavenProject> projects2, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        for (MavenProject each : projects2) {
            Module module2 = mavenProjectToModule.get(each);
            String path2 = MavenModulePathMapper.getPath(mavenProjectToModuleName.get(each), each, dedicatedModuleDir, module2);
            mavenProjectToModulePath.put(each, path2);
        }
    }

    @NotNull
    @NonNls
    private static String getPath(@NotNull String moduleName, @NotNull MavenProject each, @Nullable String dedicatedModuleDir, @Nullable Module module2) {
        if (moduleName == null) {
            MavenModulePathMapper.$$$reportNull$$$0(0);
        }
        if (each == null) {
            MavenModulePathMapper.$$$reportNull$$$0(1);
        }
        return module2 != null ? module2.getModuleFilePath() : MavenModulePathMapper.generateModulePath(each, moduleName, dedicatedModuleDir);
    }

    @NotNull
    private static String generateModulePath(MavenProject project2, String moduleName, String dedicatedModuleDir) {
        String dir2 = StringUtil.isEmptyOrSpaces((String)dedicatedModuleDir) ? project2.getDirectory() : dedicatedModuleDir;
        String fileName = moduleName + ".iml";
        String string = new File(dir2, fileName).getPath();
        if (string == null) {
            MavenModulePathMapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModulePathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModulePathMapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

