/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenAfterImportConfigurator;
import org.jetbrains.idea.maven.importing.MavenProjectShadingData;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfiguratorKt;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.commons.ClassRemapper;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenShadeFacetRemapPostTaskConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenAfterImportConfigurator;", "()V", "afterImport", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenAfterImportConfigurator$Context;", "remapUberJar", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "shadingData", "Lorg/jetbrains/idea/maven/importing/MavenProjectShadingData;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenShadePluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadeFacetRemapPostTaskConfigurator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,305:1\n215#2,2:306\n1549#3:308\n1620#3,3:309\n1360#3:312\n1446#3,5:313\n1549#3:318\n1620#3,3:319\n766#3:322\n857#3,2:323\n1855#3:325\n1856#3:328\n1313#4,2:326\n*S KotlinDebug\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadeFacetRemapPostTaskConfigurator\n*L\n236#1:306,2\n245#1:308\n245#1:309,3\n258#1:312\n258#1:313,5\n258#1:318\n258#1:319,3\n258#1:322\n258#1:323,2\n275#1:325\n275#1:328\n277#1:326,2\n*E\n"})
public final class MavenShadeFacetRemapPostTaskConfigurator
implements MavenAfterImportConfigurator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void afterImport(@NotNull MavenAfterImportConfigurator.Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Registry.is((String)"maven.shade.plugin.remap.uber.jar")) {
            return;
        }
        Map shadedMavenProjects = (Map)context2.getUserData(MavenShadePluginConfiguratorKt.access$getSHADED_MAVEN_PROJECTS$p());
        Map map = shadedMavenProjects;
        if (map == null || map.isEmpty()) {
            return;
        }
        Map $this$forEach$iv = shadedMavenProjects;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl = false;
            MavenProject mavenProject2 = (MavenProject)entry2.getKey();
            MavenProjectShadingData shadingData = (MavenProjectShadingData)entry2.getValue();
            try {
                this.remapUberJar(mavenProject2, shadingData);
            }
            catch (Exception e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        Iterable $this$map$iv = shadedMavenProjects.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            MavenProject e = (MavenProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path.of(it.getBuildDirectory(), new String[0]));
        }
        List filesToRefresh = (List)destination$iv$iv;
        LocalFileSystem.getInstance().refreshNioFiles((Iterable)filesToRefresh, true, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void remapUberJar(MavenProject mavenProject2, MavenProjectShadingData shadingData) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable list$iv$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        String uberJarPath = shadingData.getUberJarPath();
        File uberJarFile = new File(uberJarPath);
        if (uberJarFile.exists()) {
            return;
        }
        uberJarFile.getParentFile().mkdirs();
        List mavenProjects2 = CollectionsKt.plus(shadingData.getDependentMavenProjects(), (Object)mavenProject2);
        Iterable $this$flatMap$iv = mavenProjects2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MavenProject)element$iv$iv;
            boolean bl = false;
            List<MavenArtifact> list = ((MavenProject)it).getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (MavenArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!new File((String)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dependencyJarPaths = (List)destination$iv$iv;
        Map<String, String> relocationMap = shadingData.getRelocationMap();
        Remapper remapper2 = new Remapper(relocationMap){
            final /* synthetic */ Map<String, String> $relocationMap;
            {
                this.$relocationMap = $relocationMap;
            }

            @NotNull
            public String map(@NotNull String typeName) {
                Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                for (Map.Entry<String, String> entry : this.$relocationMap.entrySet()) {
                    String oldPackage = entry.getKey();
                    String newPackage = entry.getValue();
                    if (!StringsKt.startsWith$default((String)typeName, (String)oldPackage, (boolean)false, (int)2, null)) continue;
                    return StringsKt.replaceFirst$default((String)typeName, (String)oldPackage, (String)newPackage, (boolean)false, (int)4, null);
                }
                return typeName;
            }
        };
        Set addedEntries = new LinkedHashSet();
        Closeable closeable = new JarOutputStream(new FileOutputStream(uberJarPath));
        Throwable throwable = null;
        try {
            JarOutputStream jarOut = (JarOutputStream)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = dependencyJarPaths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String dependencyJarPath = (String)element$iv;
                boolean bl2 = false;
                Closeable closeable2 = new JarFile(new File(dependencyJarPath));
                Throwable throwable2 = null;
                try {
                    void $this$forEach$iv2;
                    JarFile jarFile = (JarFile)closeable2;
                    boolean bl3 = false;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                    Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        JarEntry entry = (JarEntry)element$iv2;
                        boolean bl4 = false;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        String entryName = entry.getName();
                        Intrinsics.checkNotNull((Object)entryName);
                        if (!addedEntries.add(entryName)) continue;
                        if (StringsKt.endsWith$default((String)entryName, (String)".class", (boolean)false, (int)2, null)) {
                            ClassReader classReader = new ClassReader(inputStream);
                            ClassWriter classWriter = new ClassWriter(classReader, 0);
                            ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)classWriter, remapper2);
                            classReader.accept((ClassVisitor)classRemapper, 0);
                            JarEntry newEntry = new JarEntry(entryName);
                            jarOut.putNextEntry(newEntry);
                            jarOut.write(classWriter.toByteArray());
                            jarOut.closeEntry();
                        } else {
                            jarOut.putNextEntry(entry);
                            Intrinsics.checkNotNull((Object)inputStream);
                            ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)jarOut, (int)0, (int)2, null);
                            jarOut.closeEntry();
                        }
                        inputStream.close();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

