/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.execution.ExecutionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.jetbrains.performancePlugin.commands.PerformanceCommand;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenRunAnythingProvider;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.performancePlugin.dto.MavenGoalConfigurationDto;
import org.jetbrains.idea.maven.performancePlugin.utils.MavenCommandsExecutionListener;
import org.jetbrains.idea.maven.performancePlugin.utils.MavenConfigurationUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "executeGoalAsRunAnything", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/maven/performancePlugin/dto/MavenGoalConfigurationDto;", "executeGoalsFromLifecycle", "getName", "Companion", "intellij.maven"})
public final class ExecuteMavenGoalCommand
extends PerformanceCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "executeMavenGoals";
    @NotNull
    public static final String PREFIX = "%executeMavenGoals";

    public ExecuteMavenGoalCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    private final void executeGoalAsRunAnything(Project project2, MavenGoalConfigurationDto settings) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project2).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext context2 = dataContext;
        new MavenRunAnythingProvider().execute(context2, "mvn " + CollectionsKt.joinToString$default((Iterable)settings.getGoals(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
    }

    private final void executeGoalsFromLifecycle(Project project2, MavenGoalConfigurationDto settings) {
        MavenRunnerParameters params = MavenConfigurationUtils.INSTANCE.createRunnerParams(project2, settings);
        MavenRunConfigurationType.runConfiguration(project2, params, null);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        AsyncPromise promise2 = new AsyncPromise();
        MavenGoalConfigurationDto settings = (MavenGoalConfigurationDto)this.deserializeOptionsFromJson(this.extractCommandArgument(PREFIX), MavenGoalConfigurationDto.class);
        project3.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new MavenCommandsExecutionListener((AsyncPromise<Object>)promise2));
        ApplicationManager.getApplication().invokeLater(() -> ExecuteMavenGoalCommand._execute$lambda$0(settings, this, project3, promise2));
        return (Promise)promise2;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    private static final void _execute$lambda$0(MavenGoalConfigurationDto $settings, ExecuteMavenGoalCommand this$0, Project $project, AsyncPromise $promise) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        try {
            if ($settings.getRunAnything()) {
                Intrinsics.checkNotNull((Object)$settings);
                this$0.executeGoalAsRunAnything($project, $settings);
            } else {
                Intrinsics.checkNotNull((Object)$settings);
                this$0.executeGoalsFromLifecycle($project, $settings);
            }
        }
        catch (Throwable t) {
            $promise.setError(t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand$Companion;", "", "()V", "NAME", "", "PREFIX", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

