/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.AsyncMavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u00020\u0002H%J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0002H\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ \u0010\u001a\u001a\u00020\u001b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0005J\u001c\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\u000fJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0\tJ\u0010\u0010-\u001a\u00020\u001b2\b\u0010)\u001a\u0004\u0018\u00010*J\u001e\u0010.\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;", "Lorg/jetbrains/idea/maven/server/MavenRemoteObjectWrapper;", "Lorg/jetbrains/idea/maven/server/MavenServerIndexer;", "()V", "indexCount", "", "getIndexCount", "()I", "addArtifacts", "", "Lorg/jetbrains/idea/maven/server/AddArtifactResponse;", "mavenIndexId", "Lorg/jetbrains/idea/maven/model/MavenIndexId;", "artifactFiles", "", "Ljava/io/File;", "createBlocking", "createMavenIndices", "Lorg/jetbrains/idea/maven/indices/MavenIndices;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateIndices", "getOrCreateWrappeeBlocking", "indexExists", "", "dir", "processArtifacts", "", "processor", "Lorg/jetbrains/idea/maven/server/MavenIndicesProcessor;", "progress", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "releaseIndex", "search", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactInfo;", "pattern", "", "maxResult", "startIndexing", "Lorg/jetbrains/idea/maven/server/MavenIndexUpdateState;", "info", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "indexDir", "status", "stopIndexing", "updateIndex", "indicator", "multithreaded", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenIndexerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndexerWrapper.kt\norg/jetbrains/idea/maven/server/MavenIndexerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1549#2:171\n1620#2,3:172\n*S KotlinDebug\n*F\n+ 1 MavenIndexerWrapper.kt\norg/jetbrains/idea/maven/server/MavenIndexerWrapper\n*L\n152#1:171\n152#1:172,3\n*E\n"})
public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="create", imports={}))
    @NotNull
    protected abstract MavenServerIndexer createBlocking() throws RemoteException;

    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="create", imports={}))
    @NotNull
    protected synchronized MavenServerIndexer getOrCreateWrappeeBlocking() throws RemoteException {
        if (this.getMyWrappee() == null) {
            this.setMyWrappee(this.createBlocking());
        }
        Object t = this.getMyWrappee();
        Intrinsics.checkNotNull(t);
        return (MavenServerIndexer)t;
    }

    @Nullable
    public final MavenIndexUpdateState startIndexing(@Nullable MavenRepositoryInfo info, @Nullable File indexDir) {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return null;
            }
            return ((AsyncMavenServerIndexer)w).startIndexing(info, indexDir, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return null;
        }
    }

    public final void stopIndexing(@Nullable MavenRepositoryInfo info) {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return;
            }
            ((AsyncMavenServerIndexer)w).stopIndexing(info, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    @NotNull
    public final List<MavenIndexUpdateState> status() {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return CollectionsKt.emptyList();
            }
            ArrayList arrayList = ((AsyncMavenServerIndexer)w).status(MavenRemoteObjectWrapper.ourToken);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"status(...)");
            return arrayList;
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return CollectionsKt.emptyList();
        }
    }

    public final void releaseIndex(@NotNull MavenIndexId mavenIndexId) throws MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        MavenLog.LOG.debug("releaseIndex " + mavenIndexId.indexId);
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(mavenIndexId, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public final boolean indexExists(@Nullable File dir2) {
        try {
            return this.getOrCreateWrappeeBlocking().indexExists(dir2, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public final int getIndexCount() {
        return ((Number)this.perform(() -> MavenIndexerWrapper._get_indexCount_$lambda$0(this))).intValue();
    }

    public final void updateIndex(@NotNull MavenIndexId mavenIndexId, @NotNull MavenProgressIndicator indicator, boolean multithreaded) throws MavenProcessCanceledException, MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.performCancelable(indicator, () -> MavenIndexerWrapper.updateIndex$lambda$1(indicator, this, mavenIndexId, multithreaded));
    }

    public final void processArtifacts(@Nullable MavenIndexId mavenIndexId, @NotNull MavenIndicesProcessor processor, @NotNull MavenProgressIndicator progress) throws MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.perform(() -> MavenIndexerWrapper.processArtifacts$lambda$2(progress, this, mavenIndexId, processor));
    }

    @NotNull
    public final List<AddArtifactResponse> addArtifacts(@NotNull MavenIndexId mavenIndexId, @NotNull Collection<? extends File> artifactFiles) {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        Intrinsics.checkNotNullParameter(artifactFiles, (String)"artifactFiles");
        return this.perform(() -> MavenIndexerWrapper.addArtifacts$lambda$4(this, mavenIndexId, artifactFiles));
    }

    @NotNull
    public final Set<MavenArtifactInfo> search(@Nullable MavenIndexId mavenIndexId, @Nullable String pattern, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> MavenIndexerWrapper.search$lambda$5(this, mavenIndexId, pattern, maxResult));
    }

    @ApiStatus.Internal
    @NotNull
    public final MavenIndices getOrCreateIndices(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.createMavenIndices(project2);
    }

    @NotNull
    protected abstract MavenIndices createMavenIndices(@NotNull Project var1);

    private static final int _get_indexCount_$lambda$0(MavenIndexerWrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getOrCreateWrappeeBlocking().getIndexCount(MavenRemoteObjectWrapper.ourToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateIndex$lambda$1(MavenProgressIndicator $indicator, MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, boolean $multithreaded) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mavenIndexId, (String)"$mavenIndexId");
        MavenServerProgressIndicator indicatorWrapper = MavenRemoteObjectWrapper.Companion.wrapAndExport($indicator);
        try {
            this$0.getOrCreateWrappeeBlocking().updateIndex($mavenIndexId, indicatorWrapper, $multithreaded, MavenRemoteObjectWrapper.ourToken);
        }
        finally {
            UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processArtifacts$lambda$2(MavenProgressIndicator $progress, MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, MavenIndicesProcessor $processor) {
        Intrinsics.checkNotNullParameter((Object)$progress, (String)"$progress");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
        try {
            int start = 0;
            List list = null;
            do {
                if ($progress.isCanceled()) {
                    return Unit.INSTANCE;
                }
                MavenLog.LOG.debug("process artifacts: " + start);
                list = this$0.getOrCreateWrappeeBlocking().processArtifacts($mavenIndexId, start, MavenRemoteObjectWrapper.ourToken);
                if (list == null) continue;
                $processor.processArtifacts(list);
                start += ((ArrayList)list).size();
            } while (list != null);
            return Unit.INSTANCE;
        }
        catch (Exception e) {
            return Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List addArtifacts$lambda$4(MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, Collection $artifactFiles) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mavenIndexId, (String)"$mavenIndexId");
        Intrinsics.checkNotNullParameter((Object)$artifactFiles, (String)"$artifactFiles");
        try {
            ArrayList arrayList = this$0.getOrCreateWrappeeBlocking().addArtifacts($mavenIndexId, new ArrayList($artifactFiles), MavenRemoteObjectWrapper.ourToken);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"addArtifacts(...)");
            return arrayList;
        }
        catch (Throwable ignore) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $artifactFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AddArtifactResponse((File)file, null));
            }
            return (List)destination$iv$iv;
        }
    }

    private static final HashSet search$lambda$5(MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, String $pattern, int $maxResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HashSet hashSet = this$0.getOrCreateWrappeeBlocking().search($mavenIndexId, $pattern, $maxResult, MavenRemoteObjectWrapper.ourToken);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"search(...)");
        return hashSet;
    }
}

