/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.concurrency.ThreadContext;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnectorBase;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\tH\u0016J\f\u0010\u0014\u001a\u00060\u0015R\u00020\u0000H\u0014R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl;", "Lorg/jetbrains/idea/maven/server/MavenServerConnectorBase;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "debugPort", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "multimoduleDirectory", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/String;)V", "supportType", "getSupportType", "()Ljava/lang/String;", "cleanUpFutures", "", "isCompatibleWith", "", "distribution", "newStartServerTask", "Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl$StartIndexingServerTask;", "Companion", "StartIndexingServerTask", "intellij.maven"})
public final class MavenIndexingConnectorImpl
extends MavenServerConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public MavenIndexingConnectorImpl(@NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)multimoduleDirectory, (String)"multimoduleDirectory");
        super(null, jdk2, vmOptions, mavenDistribution, multimoduleDirectory, debugPort);
        this.throwExceptionIfProjectDisposed = false;
    }

    @Override
    public boolean isCompatibleWith(@NotNull Sdk jdk2, @NotNull String vmOptions, @NotNull MavenDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected StartIndexingServerTask newStartServerTask() {
        return new StartIndexingServerTask();
    }

    @Override
    protected void cleanUpFutures() {
    }

    @Override
    @NotNull
    public String getSupportType() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support;
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = support = this.mySupport;
        return mavenRemoteProcessSupport == null ? "INDEX-?" : "INDEX-" + mavenRemoteProcessSupport.type();
    }

    static {
        Logger logger = Logger.getInstance(MavenIndexingConnectorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl$StartIndexingServerTask;", "Ljava/lang/Runnable;", "(Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl;)V", "run", "", "intellij.maven"})
    public final class StartIndexingServerTask
    implements Runnable {
        @Override
        public void run() {
            ProgressIndicator indicator = (ProgressIndicator)new EmptyProgressIndicator();
            String dirForLogs = (String)MavenIndexingConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenIndexingConnectorImpl.this.myDebugPort != null) {
                    System.out.println((Object)("Listening for transport dt_socket at address: " + MavenIndexingConnectorImpl.this.myDebugPort));
                }
                MavenRemoteProcessSupportFactory mavenRemoteProcessSupportFactory = MavenRemoteProcessSupportFactory.forIndexer();
                Intrinsics.checkNotNullExpressionValue((Object)mavenRemoteProcessSupportFactory, (String)"forIndexer(...)");
                MavenRemoteProcessSupportFactory factory = mavenRemoteProcessSupportFactory;
                MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = MavenIndexingConnectorImpl.this.mySupport = factory.createIndexerSupport(MavenIndexingConnectorImpl.this.getJdk(), MavenIndexingConnectorImpl.this.getVmOptions(), MavenIndexingConnectorImpl.this.getMavenDistribution(), MavenIndexingConnectorImpl.this.myDebugPort);
                Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport));
                mavenRemoteProcessSupport.onTerminate(arg_0 -> StartIndexingServerTask.run$lambda$0(MavenIndexingConnectorImpl.this, arg_0));
                ThreadContext.escapeCancellation((Job)JobKt.getJob((CoroutineContext)MavenCoroutineScopeProvider.Companion.getCoroutineScope(MavenIndexingConnectorImpl.this.getProject()).getCoroutineContext()), (Function0)((Function0)new Function0<Unit>(MavenIndexingConnectorImpl.this, this, indicator){
                    final /* synthetic */ MavenIndexingConnectorImpl this$0;
                    final /* synthetic */ StartIndexingServerTask this$1;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$indicator = $indicator;
                        super(0);
                    }

                    public final void invoke() {
                        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = this.this$0.mySupport;
                        Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport));
                        MavenServer server = (MavenServer)mavenRemoteProcessSupport.acquire(this.this$1, "", this.$indicator);
                        this.this$0.myServerPromise.setResult((Object)server);
                    }
                }));
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenIndexingConnectorImpl.this);
            }
            catch (Throwable e) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e);
                MavenIndexingConnectorImpl.this.myServerPromise.setError(e);
            }
        }

        private static final void run$lambda$0(MavenIndexingConnectorImpl this$0, ProcessEvent it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            MavenLog.LOG.debug("[connector] terminate " + this$0);
            MavenServerManager.Companion.getInstance().shutdownConnector(this$0, false);
        }
    }
}

