/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenAttachSourcesProvider;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenAttachSourcesProvider;", "Lcom/intellij/codeInsight/AttachSourcesProvider;", "()V", "cleanUpUnresolvedSourceFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "mavenIds", "", "Lorg/jetbrains/idea/maven/model/MavenId;", "findArtifacts", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "mavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "orderEntries", "", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getActions", "Lcom/intellij/codeInsight/AttachSourcesProvider$AttachSourcesAction;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getMavenProjects", "isTargetFile", "", "name", "", "type", "Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;", "intellij.maven"})
public final class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter(orderEntries, (String)"orderEntries");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Collection<MavenProject> projects2 = this.getMavenProjects(psiFile);
        if (projects2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return this.findArtifacts(projects2, orderEntries).isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new AttachSourcesProvider.AttachSourcesAction(psiFile, this, orderEntries){
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ MavenAttachSourcesProvider this$0;
            final /* synthetic */ List<LibraryOrderEntry> $orderEntries;
            {
                this.$psiFile = $psiFile;
                this.this$0 = $receiver;
                this.$orderEntries = $orderEntries;
            }

            @NotNull
            public String getName() {
                String string = MavenProjectBundle.message("maven.action.download.sources", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @NotNull
            public String getBusyText() {
                String string = MavenProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @NotNull
            public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                Intrinsics.checkNotNullParameter(orderEntriesContainingFile, (String)"orderEntriesContainingFile");
                Project project2 = this.$psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Project project3 = project2;
                CoroutineScope cs = MavenCoroutineScopeProvider.Companion.getCoroutineScope(project3);
                ActionCallback resultWrapper = new ActionCallback();
                BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$psiFile, resultWrapper, project3, this.$orderEntries, null){
                    int label;
                    final /* synthetic */ MavenAttachSourcesProvider this$0;
                    final /* synthetic */ PsiFile $psiFile;
                    final /* synthetic */ ActionCallback $resultWrapper;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<LibraryOrderEntry> $orderEntries;
                    {
                        this.this$0 = $receiver;
                        this.$psiFile = $psiFile;
                        this.$resultWrapper = $resultWrapper;
                        this.$project = $project;
                        this.$orderEntries = $orderEntries;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                mavenProjects = MavenAttachSourcesProvider.access$getMavenProjects(this.this$0, this.$psiFile);
                                if (mavenProjects.isEmpty()) {
                                    this.$resultWrapper.setRejected();
                                    return Unit.INSTANCE;
                                }
                                manager = MavenProjectsManager.getInstance(this.$project);
                                artifacts = MavenAttachSourcesProvider.access$findArtifacts(this.this$0, mavenProjects, this.$orderEntries);
                                if (artifacts.isEmpty()) {
                                    this.$resultWrapper.setRejected();
                                    return Unit.INSTANCE;
                                }
                                this.label = 1;
                                v0 = manager.downloadArtifacts(mavenProjects, artifacts, true, false, (Continuation)this);
                                if (v0 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl22
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl22:
                                // 2 sources

                                downloadResult = (MavenArtifactDownloader.DownloadResult)v0;
                                this.label = 2;
                                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(downloadResult, this.this$0, this.$project, this.$resultWrapper, null){
                                    int label;
                                    final /* synthetic */ MavenArtifactDownloader.DownloadResult $downloadResult;
                                    final /* synthetic */ MavenAttachSourcesProvider this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ ActionCallback $resultWrapper;
                                    {
                                        this.$downloadResult = $downloadResult;
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$resultWrapper = $resultWrapper;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                if (!this.$downloadResult.unresolvedSources.isEmpty()) {
                                                    HtmlBuilder builder2 = new HtmlBuilder();
                                                    builder2.append(MavenProjectBundle.message("sources.not.found.for", new Object[0]));
                                                    Iterator<MavenId> iterator = this.$downloadResult.unresolvedSources.iterator();
                                                    int n = 0;
                                                    while (iterator.hasNext()) {
                                                        int count = n++;
                                                        MavenId each = iterator.next();
                                                        if (count > 5) {
                                                            builder2.append((HtmlChunk)HtmlChunk.br()).append(MavenProjectBundle.message("and.more", new Object[0]));
                                                            break;
                                                        }
                                                        builder2.append((HtmlChunk)HtmlChunk.br()).append(each.getDisplayString());
                                                    }
                                                    MavenAttachSourcesProvider.access$cleanUpUnresolvedSourceFiles(this.this$0, this.$project, this.$downloadResult.unresolvedSources);
                                                    Notifications.Bus.notify((Notification)new Notification("Maven", MavenProjectBundle.message("maven.sources.cannot.download", new Object[0]), builder2.wrapWithHtmlBody().toString(), NotificationType.WARNING), (Project)this.$project);
                                                }
                                                if (this.$downloadResult.resolvedSources.isEmpty()) {
                                                    this.$resultWrapper.setRejected();
                                                } else {
                                                    this.$resultWrapper.setDone();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl31
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl31:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return resultWrapper;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpUnresolvedSourceFiles(Project project2, Collection<? extends MavenId> mavenIds) {
        for (MavenId mavenId2 : mavenIds) {
            Path parentFile;
            if (MavenUtil.getRepositoryParentFile(project2, mavenId2) == null) continue;
            try {
                AutoCloseable autoCloseable = Files.list(parentFile);
                Throwable throwable = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    boolean bl = false;
                    paths.filter(arg_0 -> MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles$lambda$2$lambda$0((Function1)new Function1<Path, Boolean>(this){
                        final /* synthetic */ MavenAttachSourcesProvider this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(Path it) {
                            return MavenAttachSourcesProvider.access$isTargetFile(this.this$0, ((Object)it.getFileName()).toString(), MavenExtraArtifactType.SOURCES);
                        }
                    }, arg_0)).forEach(arg_0 -> MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles$lambda$2$lambda$1(cleanUpUnresolvedSourceFiles.1.2.INSTANCE, arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.warn(parentFile + " cannot be listed", (Throwable)e);
            }
        }
    }

    private final boolean isTargetFile(String name, MavenExtraArtifactType type2) {
        return StringsKt.contains$default((CharSequence)name, (CharSequence)("-" + type2.getDefaultClassifier()), (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)name, (CharSequence)("." + type2.getDefaultExtension()), (boolean)false, (int)2, null);
    }

    private final Collection<MavenArtifact> findArtifacts(Collection<? extends MavenProject> mavenProjects2, List<? extends LibraryOrderEntry> orderEntries) {
        Collection artifacts = new HashSet();
        for (MavenProject mavenProject2 : mavenProjects2) {
            for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
                MavenArtifact artifact = MavenRootModelAdapter.findArtifact(mavenProject2, libraryOrderEntry.getLibrary());
                if (artifact == null || Intrinsics.areEqual((Object)"system", (Object)artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    private final Collection<MavenProject> getMavenProjects(PsiFile psiFile) {
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Collection result2 = new ArrayList();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project3).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject2 = MavenProjectsManager.getInstance(project3).findProject(each.getOwnerModule());
            if (mavenProject2 == null) continue;
            result2.add(mavenProject2);
        }
        return result2;
    }

    private static final boolean cleanUpUnresolvedSourceFiles$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanUpUnresolvedSourceFiles$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Collection access$getMavenProjects(MavenAttachSourcesProvider $this, PsiFile psiFile) {
        return $this.getMavenProjects(psiFile);
    }

    public static final /* synthetic */ Collection access$findArtifacts(MavenAttachSourcesProvider $this, Collection mavenProjects2, List orderEntries) {
        return $this.findArtifacts(mavenProjects2, orderEntries);
    }

    public static final /* synthetic */ void access$cleanUpUnresolvedSourceFiles(MavenAttachSourcesProvider $this, Project project2, Collection mavenIds) {
        $this.cleanUpUnresolvedSourceFiles(project2, mavenIds);
    }

    public static final /* synthetic */ boolean access$isTargetFile(MavenAttachSourcesProvider $this, String name, MavenExtraArtifactType type2) {
        return $this.isTargetFile(name, type2);
    }
}

