/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.wizards.AbstractMavenModuleBuilder;
import org.jetbrains.idea.maven.wizards.MavenArchetypesStep;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilder;

@Deprecated
public class MavenModuleWizardStep
extends ModuleWizardStep {
    private static final Icon WIZARD_ICON = null;
    private static final String INHERIT_GROUP_ID_KEY = "MavenModuleWizard.inheritGroupId";
    private static final String INHERIT_VERSION_KEY = "MavenModuleWizard.inheritVersion";
    private static final String ARCHETYPE_ARTIFACT_ID_KEY = "MavenModuleWizard.archetypeArtifactIdKey";
    private static final String ARCHETYPE_GROUP_ID_KEY = "MavenModuleWizard.archetypeGroupIdKey";
    private static final String ARCHETYPE_VERSION_KEY = "MavenModuleWizard.archetypeVersionKey";
    private final Project myProjectOrNull;
    private final AbstractMavenModuleBuilder myBuilder;
    private final WizardContext myContext;
    private MavenProject myAggregator;
    private MavenProject myParent;
    private String myInheritedGroupId;
    private String myInheritedVersion;
    private JPanel myMainPanel;
    private JLabel myAggregatorNameLabel;
    private JButton mySelectAggregator;
    private JLabel myParentNameLabel;
    private JButton mySelectParent;
    private JTextField myGroupIdField;
    private JCheckBox myInheritGroupIdCheckBox;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JCheckBox myInheritVersionCheckBox;
    private JPanel myArchetypesPanel;
    private JPanel myAddToPanel;
    @Nullable
    private final MavenArchetypesStep myArchetypes;

    public MavenModuleWizardStep(AbstractMavenModuleBuilder builder2, WizardContext context2, boolean includeArtifacts) {
        this.$$$setupUI$$$();
        this.myProjectOrNull = context2.getProject();
        this.myBuilder = builder2;
        this.myContext = context2;
        if (includeArtifacts) {
            this.myArchetypes = new MavenArchetypesStep(builder2, (StepAdapter)this);
            this.myArchetypesPanel.add((Component)this.myArchetypes.getMainPanel(), "Center");
        } else {
            this.myArchetypes = null;
        }
        this.initComponents();
        this.loadSettings();
    }

    public MavenModuleWizardStep(MavenModuleBuilder builder2, WizardContext context2, boolean includeArtifacts) {
        this((AbstractMavenModuleBuilder)builder2, context2, includeArtifacts);
    }

    private void initComponents() {
        this.mySelectAggregator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.myAggregator = MavenModuleWizardStep.this.doSelectProject(MavenModuleWizardStep.this.myAggregator);
                MavenModuleWizardStep.this.updateComponents();
            }
        });
        this.mySelectParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.myParent = MavenModuleWizardStep.this.doSelectProject(MavenModuleWizardStep.this.myParent);
                MavenModuleWizardStep.this.updateComponents();
            }
        });
        ActionListener updatingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.updateComponents();
            }
        };
        this.myInheritGroupIdCheckBox.addActionListener(updatingListener);
        this.myInheritVersionCheckBox.addActionListener(updatingListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    private MavenProject doSelectProject(MavenProject current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectMavenProjectDialog d = new SelectMavenProjectDialog(this.myProjectOrNull, current);
        if (!d.showAndGet()) {
            return current;
        }
        return d.getResult();
    }

    public void onStepLeaving() {
        this.saveSettings();
    }

    private void loadSettings() {
        this.myBuilder.setInheritedOptions(MavenModuleWizardStep.getSavedValue(INHERIT_GROUP_ID_KEY, true), MavenModuleWizardStep.getSavedValue(INHERIT_VERSION_KEY, true));
        String archGroupId = MavenModuleWizardStep.getSavedValue(ARCHETYPE_GROUP_ID_KEY, null);
        String archArtifactId = MavenModuleWizardStep.getSavedValue(ARCHETYPE_ARTIFACT_ID_KEY, null);
        String archVersion = MavenModuleWizardStep.getSavedValue(ARCHETYPE_VERSION_KEY, null);
        if (archGroupId == null || archArtifactId == null || archVersion == null) {
            this.myBuilder.setArchetype(null);
        } else {
            this.myBuilder.setArchetype(new MavenArchetype(archGroupId, archArtifactId, archVersion, null, null));
        }
    }

    private void saveSettings() {
        MavenModuleWizardStep.saveValue(INHERIT_GROUP_ID_KEY, this.myInheritGroupIdCheckBox.isSelected());
        MavenModuleWizardStep.saveValue(INHERIT_VERSION_KEY, this.myInheritVersionCheckBox.isSelected());
        if (this.myArchetypes != null) {
            MavenArchetype arch = this.myArchetypes.getSelectedArchetype();
            MavenModuleWizardStep.saveValue(ARCHETYPE_GROUP_ID_KEY, arch == null ? null : arch.groupId);
            MavenModuleWizardStep.saveValue(ARCHETYPE_ARTIFACT_ID_KEY, arch == null ? null : arch.artifactId);
            MavenModuleWizardStep.saveValue(ARCHETYPE_VERSION_KEY, arch == null ? null : arch.version);
        }
    }

    private static boolean getSavedValue(String key, boolean defaultValue) {
        return MavenModuleWizardStep.getSavedValue(key, String.valueOf(defaultValue)).equals(String.valueOf(true));
    }

    private static String getSavedValue(String key, String defaultValue) {
        String value = PropertiesComponent.getInstance().getValue(key);
        return value == null ? defaultValue : value;
    }

    private static void saveValue(String key, boolean value) {
        MavenModuleWizardStep.saveValue(key, String.valueOf(value));
    }

    private static void saveValue(String key, String value) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(key, value);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean validate() throws ConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myGroupIdField.getText())) {
            throw new ConfigurationException(MavenProjectBundle.message("dialog.message.wizard.please.specify.groupid", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myArtifactIdField.getText())) {
            throw new ConfigurationException(MavenProjectBundle.message("dialog.message.wizard.please.specify.artifactid", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myVersionField.getText())) {
            throw new ConfigurationException(MavenProjectBundle.message("dialog.message.wizard.please.specify.version", new Object[0]));
        }
        return true;
    }

    public MavenProject findPotentialParentProject(Project project2) {
        if (!MavenProjectsManager.getInstance(project2).isMavenizedProject()) {
            return null;
        }
        VirtualFile parentPom = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.myContext.getProjectFileDirectory(), "pom.xml"));
        if (parentPom == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(project2).findProject(parentPom);
    }

    private static void setTextIfEmpty(@NotNull JTextField artifactIdField, @Nullable String text2) {
        if (artifactIdField == null) {
            MavenModuleWizardStep.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)artifactIdField.getText())) {
            artifactIdField.setText(StringUtil.notNullize((String)text2));
        }
    }

    public void updateStep() {
        MavenId projectId;
        if (this.myArchetypes != null && this.myArchetypes.isSkipUpdateUI()) {
            return;
        }
        if (this.isMavenizedProject()) {
            MavenProject parent;
            this.myAggregator = parent = this.findPotentialParentProject(this.myProjectOrNull);
            this.myParent = parent;
        }
        if ((projectId = this.myBuilder.getProjectId()) == null) {
            MavenModuleWizardStep.setTextIfEmpty(this.myArtifactIdField, this.myBuilder.getName());
            MavenModuleWizardStep.setTextIfEmpty(this.myGroupIdField, this.myParent == null ? this.myBuilder.getName() : this.myParent.getMavenId().getGroupId());
            MavenModuleWizardStep.setTextIfEmpty(this.myVersionField, this.myParent == null ? "1.0-SNAPSHOT" : this.myParent.getMavenId().getVersion());
        } else {
            MavenModuleWizardStep.setTextIfEmpty(this.myArtifactIdField, projectId.getArtifactId());
            MavenModuleWizardStep.setTextIfEmpty(this.myGroupIdField, projectId.getGroupId());
            MavenModuleWizardStep.setTextIfEmpty(this.myVersionField, projectId.getVersion());
        }
        this.myInheritGroupIdCheckBox.setSelected(this.myBuilder.isInheritGroupId());
        this.myInheritVersionCheckBox.setSelected(this.myBuilder.isInheritVersion());
        if (this.myArchetypes != null) {
            this.myArchetypes.requestUpdate();
        }
        this.updateComponents();
    }

    private boolean isMavenizedProject() {
        return this.myProjectOrNull != null && MavenProjectsManager.getInstance(this.myProjectOrNull).isMavenizedProject();
    }

    private void updateComponents() {
        this.myAddToPanel.setVisible(this.isMavenizedProject());
        this.myAggregatorNameLabel.setText(MavenModuleWizardStep.formatProjectString(this.myAggregator));
        this.myParentNameLabel.setText(MavenModuleWizardStep.formatProjectString(this.myParent));
        if (this.myParent == null) {
            this.myGroupIdField.setEnabled(true);
            this.myVersionField.setEnabled(true);
            this.myInheritGroupIdCheckBox.setEnabled(false);
            this.myInheritVersionCheckBox.setEnabled(false);
        } else {
            this.myGroupIdField.setEnabled(!this.myInheritGroupIdCheckBox.isSelected());
            this.myVersionField.setEnabled(!this.myInheritVersionCheckBox.isSelected());
            if (this.myInheritGroupIdCheckBox.isSelected() || this.myGroupIdField.getText().equals(this.myInheritedGroupId)) {
                this.myGroupIdField.setText(this.myParent.getMavenId().getGroupId());
            }
            if (this.myInheritVersionCheckBox.isSelected() || this.myVersionField.getText().equals(this.myInheritedVersion)) {
                this.myVersionField.setText(this.myParent.getMavenId().getVersion());
            }
            this.myInheritedGroupId = this.myGroupIdField.getText();
            this.myInheritedVersion = this.myVersionField.getText();
            this.myInheritGroupIdCheckBox.setEnabled(true);
            this.myInheritVersionCheckBox.setEnabled(true);
        }
        MavenModuleWizardStep.setTextIfEmpty(this.myGroupIdField, "org.example");
        MavenModuleWizardStep.setTextIfEmpty(this.myArtifactIdField, this.suggestArtifactId());
    }

    @NotNull
    private String suggestArtifactId() {
        if (this.myContext.isCreatingNewProject()) {
            String baseDir2 = this.myContext.getProjectFileDirectory();
            String string = ProjectWizardUtil.findNonExistingFileName((String)baseDir2, (String)"untitled", (String)"");
            if (string == null) {
                MavenModuleWizardStep.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @Nls
    private static String formatProjectString(MavenProject project2) {
        if (project2 == null) {
            return MavenProjectBundle.message("maven.parent.label.none", new Object[0]);
        }
        return project2.getMavenId().getDisplayString();
    }

    public void updateDataModel() {
        this.myContext.setProjectBuilder((ProjectBuilder)this.myBuilder);
        this.myBuilder.setAggregatorProject(this.myAggregator);
        this.myBuilder.setParentProject(this.myParent);
        this.myBuilder.setProjectId(new MavenId(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText()));
        this.myBuilder.setInheritedOptions(this.myInheritGroupIdCheckBox.isSelected(), this.myInheritVersionCheckBox.isSelected());
        if (this.myContext.getProjectName() == null) {
            this.myContext.setProjectName(this.myBuilder.getProjectId().getArtifactId());
        }
        if (this.myArchetypes != null) {
            this.myBuilder.setArchetype(this.myArchetypes.getSelectedArchetype());
        }
    }

    public Icon getIcon() {
        return WIZARD_ICON;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.maven";
    }

    public void disposeUIResources() {
        if (this.myArchetypes != null) {
            Disposer.dispose((Disposable)this.myArchetypes);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JButton jButton2;
        JLabel jLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.groupid"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.artifactid"));
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.version"));
        jPanel3.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupIdField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArtifactIdField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVersionField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myInheritGroupIdCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.inherit"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInheritVersionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.inherit"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myArchetypesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAddToPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.add.to"));
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAggregatorNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.mySelectAggregator = jButton2 = new JButton();
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setText("...");
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/MavenWizardBundle", MavenModuleWizardStep.class).getString("maven.structure.wizard.module.parent"));
        jPanel.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentNameLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.mySelectParent = jButton = new JButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setText("...");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactIdField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/wizards/MavenModuleWizardStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenModuleWizardStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestArtifactId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTextIfEmpty";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

