/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.error.ShouldNotBeNull;

public class InstanceOfAssertFactory<T, ASSERT extends AbstractAssert<?, ?>>
implements AssertFactory<Object, ASSERT> {
    private final Class<T> type;
    private final AssertFactory<T, ASSERT> assertFactory;

    public InstanceOfAssertFactory(Class<T> type2, AssertFactory<T, ASSERT> assertFactory) {
        this.type = Objects.requireNonNull(type2, ShouldNotBeNull.shouldNotBeNull("type")::create);
        this.assertFactory = Objects.requireNonNull(assertFactory, ShouldNotBeNull.shouldNotBeNull("assertFactory")::create);
    }

    Class<T> getType() {
        return this.type;
    }

    @Override
    public ASSERT createAssert(Object value) {
        return (ASSERT)((AbstractAssert)this.assertFactory.createAssert(this.type.cast(value)));
    }

    public String toString() {
        return this.type.getSimpleName() + " InstanceOfAssertFactory";
    }
}

