/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.BaseControllerImpl;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingDialog;
import com.intellij.ide.startup.importSettings.chooser.ui.WizardController;
import com.intellij.ide.startup.importSettings.data.PluginImportProgress;
import com.intellij.ide.startup.importSettings.data.StartupWizardService;
import com.intellij.ide.startup.importSettings.wizard.keymapChooser.KeymapChooserPage;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardPluginsPage;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardProgressPage;
import com.intellij.ide.startup.importSettings.wizard.themeChooser.ThemeChooserPage;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardControllerImpl;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardController;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BaseControllerImpl;", "dialog", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "service", "Lcom/intellij/ide/startup/importSettings/data/StartupWizardService;", "goBackAction", "Lkotlin/Function0;", "", "(Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;Lcom/intellij/ide/startup/importSettings/data/StartupWizardService;Lkotlin/jvm/functions/Function0;)V", "getGoBackAction", "()Lkotlin/jvm/functions/Function0;", "installationLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getService", "()Lcom/intellij/ide/startup/importSettings/data/StartupWizardService;", "cancelPluginInstallation", "goToInstallPluginPage", "ids", "", "", "goToKeymapPage", "isForwardDirection", "", "goToPluginPage", "goToThemePage", "skipPlugins", "intellij.ide.startup.importSettings"})
public final class WizardControllerImpl
extends BaseControllerImpl
implements WizardController {
    @NotNull
    private final StartupWizardService service;
    @Nullable
    private final Function0<Unit> goBackAction;
    @NotNull
    private final SequentialLifetimes installationLifetimes;

    public WizardControllerImpl(final @NotNull OnboardingDialog dialog2, @NotNull StartupWizardService service, @Nullable Function0<Unit> goBackAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        super(dialog2);
        this.service = service;
        this.goBackAction = goBackAction;
        this.installationLifetimes = new SequentialLifetimes(this.getLifetime());
        this.getService().getShouldClose().advise(this.getLifetime(), (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                dialog2.dialogClose();
            }
        });
    }

    @Override
    @NotNull
    public StartupWizardService getService() {
        return this.service;
    }

    @Override
    @Nullable
    public Function0<Unit> getGoBackAction() {
        return this.goBackAction;
    }

    @Override
    public void goToThemePage(boolean isForwardDirection) {
        if (ScreenReader.isActive()) {
            this.goToKeymapPage(true);
            return;
        }
        ThemeChooserPage page = new ThemeChooserPage(this);
        this.getDialog().changePage(page);
        page.onEnter(isForwardDirection);
    }

    @Override
    public void goToKeymapPage(boolean isForwardDirection) {
        KeymapChooserPage page = new KeymapChooserPage(this);
        this.getDialog().changePage(page);
        page.onEnter(isForwardDirection);
    }

    @Override
    public void goToPluginPage() {
        WizardPluginsPage page = new WizardPluginsPage(this);
        this.getDialog().changePage(page);
        page.onEnter();
    }

    @Override
    public void goToInstallPluginPage(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (!((Collection)ids).isEmpty()) {
            LifetimeDefinition lifetime = this.installationLifetimes.next();
            PluginImportProgress importProgress = this.getService().getPluginService().install((Lifetime)lifetime, ids);
            WizardProgressPage page = new WizardProgressPage(importProgress, this);
            this.getDialog().changePage(page);
        } else {
            this.skipPlugins();
        }
    }

    @Override
    public void skipPlugins() {
        this.getService().getPluginService().skipPlugins();
        this.getDialog().dialogClose();
    }

    @Override
    public void cancelPluginInstallation() {
        this.installationLifetimes.terminateCurrent();
    }
}

