/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.data.BaseSetting;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.ExternalProductService;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.Multiple;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferences;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.transfer.ExternalProductInfo;
import com.intellij.ide.startup.importSettings.transfer.IconExKt;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferProductService;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferProductServiceKt;
import com.intellij.ide.startup.importSettings.transfer.ThirdPartyProductInfo;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgress;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsWizardListener;
import com.intellij.ide.startup.importSettings.transfer.TransferableSetting;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0016H\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService;", "Lcom/intellij/ide/startup/importSettings/data/ExternalProductService;", "productId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "ideVersions", "Lkotlinx/coroutines/Deferred;", "", "", "Lcom/intellij/ide/startup/importSettings/transfer/ThirdPartyProductInfo;", "importController", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;", "(Lcom/intellij/ide/startup/importSettings/TransferableIdeId;Lkotlinx/coroutines/Deferred;Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;)V", "getProductId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "productTitle", "getProductTitle", "()Ljava/lang/String;", "applyPreferences", "", "product", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "toApply", "", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "getProductIcon", "Ljavax/swing/Icon;", "itemId", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "getSettings", "Lcom/intellij/ide/startup/importSettings/data/BaseSetting;", "importSettings", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "data", "loadProductInfos", "products", "Lcom/intellij/ide/startup/importSettings/data/Product;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nSettingTransferProductService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n86#2,2:196\n88#2:202\n86#2,2:203\n88#2:206\n86#2,3:207\n13#2:210\n1549#3:198\n1620#3,3:199\n1#4:205\n*S KotlinDebug\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService\n*L\n70#1:196,2\n70#1:202\n77#1:203,2\n77#1:206\n96#1:207,3\n38#1:210\n72#1:198\n72#1:199,3\n*E\n"})
public final class SettingTransferProductService
implements ExternalProductService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransferableIdeId productId;
    @NotNull
    private final Deferred<Map<String, ThirdPartyProductInfo>> ideVersions;
    @NotNull
    private final TransferSettingsController importController;
    @NotNull
    private static final Logger logger;

    public SettingTransferProductService(@NotNull TransferableIdeId productId, @NotNull Deferred<? extends Map<String, ThirdPartyProductInfo>> ideVersions2, @NotNull TransferSettingsController importController) {
        Intrinsics.checkNotNullParameter((Object)((Object)productId), (String)"productId");
        Intrinsics.checkNotNullParameter(ideVersions2, (String)"ideVersions");
        Intrinsics.checkNotNullParameter((Object)importController, (String)"importController");
        this.productId = productId;
        this.ideVersions = ideVersions2;
        this.importController = importController;
    }

    @Override
    @NotNull
    public TransferableIdeId getProductId() {
        return this.productId;
    }

    private final Map<String, ThirdPartyProductInfo> loadProductInfos() {
        Deferred<Map<String, ThirdPartyProductInfo>> it = this.ideVersions;
        boolean bl = false;
        if (it.isCompleted()) {
            return (Map)it.getCompleted();
        }
        return (Map)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ThirdPartyProductInfo>>, Object>(this, null){
            int label;
            final /* synthetic */ SettingTransferProductService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        SettingTransferProductService.access$getLogger$cp().warn("Started waiting for transfer provider initialization.");
                        this.label = 1;
                        v0 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ThirdPartyProductInfo>>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SettingTransferProductService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = SettingTransferProductService.access$getIdeVersions$p(this.this$0).await((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Map<String, ThirdPartyProductInfo>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl13
lbl12:
                        // 1 sources

                        return var4_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            var2_3 = (Map)v0;
                        }
                        catch (Throwable var3_4) {
                            throw var3_4;
                        }
                        finally {
                            SettingTransferProductService.access$getLogger$cp().warn("Finished waiting for transfer provider initialization.");
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Map<String, ThirdPartyProductInfo>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public String getProductTitle() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getProductId().ordinal()]) {
            case 1 -> "";
            case 2 -> "";
            case 3 -> "Visual Studio";
            case 4 -> "Visual Studio for Mac";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Product> products() {
        List list;
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            void $this$mapTo$iv$iv;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Collection<ThirdPartyProductInfo> versions2 = this.loadProductInfos().values();
            Iterable $this$map$iv = versions2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ThirdPartyProductInfo thirdPartyProductInfo = (ThirdPartyProductInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(ExternalProductInfo.Companion.ofIdeVersion(it.getProduct()));
            }
            object = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<BaseSetting> getSettings(@NotNull String itemId) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Object object2;
            Object object3;
            Object p0;
            Object object4;
            List list2;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ThirdPartyProductInfo> versions2 = this.loadProductInfos();
            ThirdPartyProductInfo thirdPartyProductInfo = versions2.get(itemId);
            if (thirdPartyProductInfo == null) {
                return CollectionsKt.emptyList();
            }
            ThirdPartyProductInfo product = thirdPartyProductInfo;
            Settings settings = product.getSettingsQuickly();
            if (settings == null) {
                throw new IllegalStateException(("Cannot load settings for " + itemId + " quickly.").toString());
            }
            Settings settings2 = settings;
            List $this$getSettings_u24lambda_u2410_u24lambda_u249 = list2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            Object object5 = settings2.getLaf();
            if (object5 != null) {
                object4 = object5;
                TransferableSetting.Companion companion = TransferableSetting.Companion;
                ILookAndFeel p02 = object4;
                boolean bl4 = false;
                TransferableSetting transferableSetting = companion.uiTheme(p02);
                object5 = transferableSetting;
                if (transferableSetting != null) {
                    p0 = (BaseSetting)object5;
                    boolean bl5 = false;
                    $this$getSettings_u24lambda_u2410_u24lambda_u249.add(p0);
                }
            }
            if ((object3 = settings2.getKeymap()) != null) {
                object4 = object3;
                p0 = TransferableSetting.Companion;
                Object p03 = object4;
                boolean bl6 = false;
                Multiple multiple = ((TransferableSetting.Companion)p0).keymap((Keymap)p03);
                object3 = multiple;
                if (multiple != null) {
                    p0 = (BaseSetting)object3;
                    boolean bl7 = false;
                    $this$getSettings_u24lambda_u2410_u24lambda_u249.add(p0);
                }
            }
            Collection<FeatureInfo> it = settings2.getPlugins().values();
            boolean bl8 = false;
            if (!it.isEmpty()) {
                $this$getSettings_u24lambda_u2410_u24lambda_u249.add(TransferableSetting.Companion.plugins(it));
            }
            if ((object2 = UtilKt.nullize(settings2.getRecentProjects())) != null) {
                List list3 = object2;
                p0 = TransferableSetting.Companion;
                List p04 = list3;
                boolean bl9 = false;
                Multiple multiple = ((TransferableSetting.Companion)p0).recentProjects(p04);
                object2 = multiple;
                if (multiple != null) {
                    p0 = (BaseSetting)object2;
                    boolean bl10 = false;
                    $this$getSettings_u24lambda_u2410_u24lambda_u249.add(p0);
                }
            }
            object = Result.constructor-impl((Object)CollectionsKt.build((List)list2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String itemId, @NotNull IconProductSize size) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            ThirdPartyProductInfo thirdPartyProductInfo = this.loadProductInfos().get(itemId);
            if (thirdPartyProductInfo == null) {
                return null;
            }
            ThirdPartyProductInfo info = thirdPartyProductInfo;
            return IconExKt.icon(info.getProduct().getTransferableId(), size);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return (Icon)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
    }

    @Override
    @NotNull
    public DialogImportData importSettings(@NotNull String productId, @NotNull List<DataForSave> data) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            ThirdPartyProductInfo thirdPartyProductInfo = this.loadProductInfos().get(productId);
            if (thirdPartyProductInfo == null) {
                Object object = new Object[]{productId};
                object = ImportSettingsBundle.INSTANCE.message("transfer.error.product-not-found", (Object[])object);
                throw new IllegalStateException(object.toString());
            }
            ThirdPartyProductInfo info = thirdPartyProductInfo;
            IdeVersion product = info.getProduct();
            this.applyPreferences(product, data);
            TransferSettingsProgress importData = new TransferSettingsProgress(product);
            ProgressIndicator progressIndicator = importData.createProgressIndicatorAdapter();
            LifetimeDefinition importLifetime = new LifetimeDefinition();
            SettingsService.Companion.getInstance().getImportCancelled().advise(importLifetime.getLifetime(), (Function1)new Function1<Unit, Unit>(progressIndicator){
                final /* synthetic */ ProgressIndicator $progressIndicator;
                {
                    this.$progressIndicator = $progressIndicator;
                    super(1);
                }

                public final void invoke(@NotNull Unit it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$progressIndicator.cancel();
                }
            });
            this.importController.addListener(new TransferSettingsWizardListener(importLifetime));
            this.importController.performImport(null, product, progressIndicator);
            return importData;
        }
        catch (Throwable t) {
            if (t instanceof CancellationException || t instanceof ProcessCanceledException) {
                throw t;
            }
            logger.error(t);
            SettingTransferProductServiceKt.access$showImportErrorNotification(t);
            return SettingTransferProductServiceKt.access$dummyImportData();
        }
    }

    private final void applyPreferences(IdeVersion product, List<DataForSave> toApply) {
        Set selectedIds2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)toApply), (Function1)applyPreferences.selectedIds.1.INSTANCE));
        Settings settings = product.getSettingsCache();
        SettingsPreferences preferences = settings.getPreferences();
        preferences.set(SettingsPreferencesKind.Laf, selectedIds2.contains("ui"));
        preferences.set(SettingsPreferencesKind.SyntaxScheme, selectedIds2.contains("ui"));
        preferences.set(SettingsPreferencesKind.Keymap, selectedIds2.contains("keymap"));
        preferences.set(SettingsPreferencesKind.Plugins, selectedIds2.contains("plugins"));
        preferences.set(SettingsPreferencesKind.RecentProjects, selectedIds2.contains("recentProjects"));
        Sequence featuresToRemove2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(settings.getPlugins()), (Function1)applyPreferences.featuresToRemove.1.INSTANCE), (Function1)applyPreferences.featuresToRemove.2.INSTANCE);
        settings.getPlugins().keySet().removeAll(SequencesKt.toSet((Sequence)featuresToRemove2));
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Deferred access$getIdeVersions$p(SettingTransferProductService $this) {
        return $this.ideVersions;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingTransferProductService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SettingTransferProductService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransferableIdeId.values().length];
            try {
                nArray[TransferableIdeId.DummyIde.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VSCode.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VisualStudio.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VisualStudioForMac.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

