/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeProcessor;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/history/core/ChangeProcessorBase;", "Lcom/intellij/history/core/ChangeProcessor;", "projectId", "", "patternString", "consumer", "Lkotlin/Function1;", "Lcom/intellij/history/core/changes/ChangeSet;", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "pattern", "Ljava/util/regex/Pattern;", "processedChangesSets", "", "", "process", "changeSet", "change", "Lcom/intellij/history/core/changes/Change;", "changePath", "intellij.platform.lvcs.impl"})
@ApiStatus.Experimental
public class ChangeProcessorBase
implements ChangeProcessor {
    @Nullable
    private final String projectId;
    @NotNull
    private final Function1<ChangeSet, Unit> consumer;
    @Nullable
    private final Pattern pattern;
    @NotNull
    private final Set<Long> processedChangesSets;

    public ChangeProcessorBase(@Nullable String projectId, @Nullable String patternString, @NotNull Function1<? super ChangeSet, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.projectId = projectId;
        this.consumer = consumer;
        this.pattern = LocalHistoryFacadeKt.toPattern(patternString);
        this.processedChangesSets = new LinkedHashSet();
    }

    @Override
    public void process(@NotNull ChangeSet changeSet, @NotNull Change change, @NotNull String changePath) {
        Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)changePath, (String)"changePath");
        if (!this.processedChangesSets.contains(changeSet.getId()) && LocalHistoryFacadeKt.matches(change, this.projectId, changePath, this.pattern)) {
            this.processedChangesSets.add(changeSet.getId());
            this.consumer.invoke((Object)changeSet);
        }
    }
}

