/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.revisions.Revision;
import com.intellij.util.text.DateFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/history/integration/ui/models/RecentChange;", "", "revisionBefore", "Lcom/intellij/history/core/revisions/Revision;", "revisionAfter", "(Lcom/intellij/history/core/revisions/Revision;Lcom/intellij/history/core/revisions/Revision;)V", "changeName", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getChangeName", "()Ljava/lang/String;", "getRevisionAfter", "()Lcom/intellij/history/core/revisions/Revision;", "getRevisionBefore", "timestamp", "", "getTimestamp", "()J", "toString", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public final class RecentChange {
    @NotNull
    private final Revision revisionBefore;
    @NotNull
    private final Revision revisionAfter;

    public RecentChange(@NotNull Revision revisionBefore, @NotNull Revision revisionAfter) {
        Intrinsics.checkNotNullParameter((Object)revisionBefore, (String)"revisionBefore");
        Intrinsics.checkNotNullParameter((Object)revisionAfter, (String)"revisionAfter");
        this.revisionBefore = revisionBefore;
        this.revisionAfter = revisionAfter;
    }

    @NotNull
    public final Revision getRevisionBefore() {
        return this.revisionBefore;
    }

    @NotNull
    public final Revision getRevisionAfter() {
        return this.revisionAfter;
    }

    @Nullable
    public final String getChangeName() {
        return this.revisionAfter.getChangeSetName();
    }

    public final long getTimestamp() {
        return this.revisionAfter.getTimestamp();
    }

    @NotNull
    public String toString() {
        return this.getChangeName() + "[" + DateFormatUtil.formatDateTime((long)this.getTimestamp()) + "]";
    }
}

