/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParser;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.MathParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.intellij.plugins.markdown.lang.parser.FrontMatterGeneratingProvider;
import org.intellij.plugins.markdown.lang.parser.MarkdownDefaultMarkerProcessor;
import org.intellij.plugins.markdown.lang.parser.blocks.DefinitionListMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterHeaderMarkerProvider;
import org.intellij.plugins.markdown.ui.preview.html.HeaderGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u001c\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "()V", "delegate", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "addCustomHeaderProviders", "", "providers", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "addCustomProviders", "createHtmlGeneratingProviders", "", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "DefaultSequentialParserManager", "ExcludedElementProvider", "intellij.markdown"})
public class MarkdownDefaultFlavour
implements MarkdownFlavourDescriptor {
    @NotNull
    private final GFMFlavourDescriptor delegate = new GFMFlavourDescriptor(false, false, false, 7, null);
    @NotNull
    private final SequentialParserManager sequentialParserManager = new DefaultSequentialParserManager();

    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return MarkdownDefaultMarkerProcessor.Factory.INSTANCE;
    }

    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return this.delegate.createInlinesLexer();
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Map base = this.delegate.createHtmlGeneratingProviders(linkMap, baseURI);
        HashMap result2 = new HashMap(base);
        this.addCustomProviders(result2);
        return result2;
    }

    private final void addCustomProviders(Map<IElementType, GeneratingProvider> providers2) {
        this.addCustomHeaderProviders(providers2);
        providers2.put(DefinitionListMarkerProvider.DEFINITION_LIST, (GeneratingProvider)new SimpleInlineTagProvider("dl", 0, 0, 6, null));
        providers2.put(DefinitionListMarkerProvider.DEFINITION, (GeneratingProvider)new SimpleInlineTagProvider("dd", 0, 0, 6, null));
        providers2.put(DefinitionListMarkerProvider.TERM, (GeneratingProvider)new SimpleInlineTagProvider("dt", 0, 0, 6, null));
        providers2.put(DefinitionListMarkerProvider.DEFINITION_MARKER, (GeneratingProvider)new TransparentInlineHolderProvider(0, 0, 3, null));
        providers2.put((IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER, new FrontMatterGeneratingProvider());
    }

    private final void addCustomHeaderProviders(Map<IElementType, GeneratingProvider> providers2) {
        providers2.put(MarkdownElementTypes.ATX_1, (GeneratingProvider)new HeaderGeneratingProvider("h1"));
        providers2.put(MarkdownElementTypes.ATX_2, (GeneratingProvider)new HeaderGeneratingProvider("h2"));
        providers2.put(MarkdownElementTypes.ATX_3, (GeneratingProvider)new HeaderGeneratingProvider("h3"));
        providers2.put(MarkdownElementTypes.ATX_4, (GeneratingProvider)new HeaderGeneratingProvider("h4"));
        providers2.put(MarkdownElementTypes.ATX_5, (GeneratingProvider)new HeaderGeneratingProvider("h5"));
        providers2.put(MarkdownElementTypes.ATX_6, (GeneratingProvider)new HeaderGeneratingProvider("h6"));
        providers2.put(MarkdownElementTypes.SETEXT_1, (GeneratingProvider)new HeaderGeneratingProvider("h1"));
        providers2.put(MarkdownElementTypes.SETEXT_2, (GeneratingProvider)new HeaderGeneratingProvider("h2"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour$DefaultSequentialParserManager;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "()V", "getParserSequence", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "intellij.markdown"})
    protected static final class DefaultSequentialParserManager
    extends SequentialParserManager {
        @NotNull
        public List<SequentialParser> getParserSequence() {
            Object[] objectArray = new SequentialParser[7];
            Object[] objectArray2 = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
            objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object[])objectArray2));
            objectArray[1] = new BacktickParser();
            objectArray[2] = new MathParser();
            objectArray[3] = new ImageParser();
            objectArray[4] = new InlineLinkParser();
            objectArray[5] = new ReferenceLinkParser();
            objectArray2 = new DelimiterParser[]{new EmphStrongDelimiterParser(), new StrikeThroughDelimiterParser()};
            objectArray[6] = new EmphasisLikeParser((DelimiterParser[])objectArray2);
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour$ExcludedElementProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.markdown"})
    private static final class ExcludedElementProvider
    implements GeneratingProvider {
        public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        }
    }
}

