/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\r\u001a\u00020\u0001\u00a8\u0006\u000e"}, d2={"findProtectedRemoteBranch", "", "repository", "Lgit4idea/repo/GitRepository;", "branches", "", "findProtectedRemoteBranchContainingCommit", "hash", "Lcom/intellij/vcs/log/Hash;", "isCommitPublished", "", "isRemoteBranchProtected", "repositories", "branchName", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitProtectedBranches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitProtectedBranches.kt\ngit4idea/GitProtectedBranchesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n766#2:43\n857#2,2:44\n1549#2:46\n1620#2,3:47\n288#2,2:50\n1747#2,3:52\n*S KotlinDebug\n*F\n+ 1 GitProtectedBranches.kt\ngit4idea/GitProtectedBranchesKt\n*L\n19#1:43\n19#1:44,2\n20#1:46\n20#1:47,3\n21#1:50,2\n30#1:52,3\n*E\n"})
public final class GitProtectedBranchesKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String findProtectedRemoteBranch(@NotNull GitRepository repository, @NotNull Collection<String> branches) {
        Object v1;
        block3: {
            void $this$mapTo$iv$iv;
            GitRemoteBranch it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            GitSharedSettings settings = GitSharedSettings.getInstance(repository.getProject());
            Collection<GitRemoteBranch> collection = repository.getBranches().getRemoteBranches();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemoteBranches(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GitRemoteBranch)element$iv$iv;
                boolean bl = false;
                if (!settings.isBranchProtected(it.getNameForRemoteOperations())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GitRemoteBranch)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getNameForLocalOperations());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                if (!branches.contains(it2)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    public static final boolean isRemoteBranchProtected(@NotNull Collection<? extends GitRepository> repositories2, @NotNull String branchName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Iterable $this$any$iv = repositories2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!(GitProtectedBranchesKt.findProtectedRemoteBranch(it, CollectionsKt.listOf((Object)branchName)) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final String findProtectedRemoteBranchContainingCommit(@NotNull GitRepository repository, @NotNull Hash hash) {
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(project).getDataManager();
        Object branchesGetter = vcsLogData != null ? vcsLogData.getContainingBranchesGetter() : null;
        Object object = branchesGetter;
        if (object != null && (object = object.getContainingBranchesSynchronously(root, hash)) != null) {
            collection = (Collection<String>)object;
        } else {
            Collection<String> collection2 = GitBranchUtil.getBranches(repository.getProject(), root, false, true, hash.asString());
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getBranches(...)");
        }
        Collection<String> branches = collection;
        return GitProtectedBranchesKt.findProtectedRemoteBranch(repository, branches);
    }

    public static final boolean isCommitPublished(@NotNull GitRepository repository, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return GitProtectedBranchesKt.findProtectedRemoteBranchContainingCommit(repository, hash) != null;
    }
}

