/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitTag;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitRebaseSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.rebase.GitRebaseDialog;
import git4idea.rebase.GitRebaseDialogKt;
import git4idea.rebase.GitRebaseHelpPopupPanel;
import git4idea.rebase.GitRebaseOption;
import git4idea.rebase.GitRebaseOptionKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComboBoxUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\"\b\u0000\u0018\u0000 v2\u00020\u0001:\u0002vwB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0017H\u0002J\u0010\u0010<\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0017H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010>\u001a\u00020$H\u0014J\b\u0010?\u001a\u00020\u001aH\u0002J\b\u0010@\u001a\u00020:H\u0014J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020\u001aH\u0002J\u0018\u0010E\u001a\u0012\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\bG0FH\u0002J\b\u0010H\u001a\u00020$H\u0002J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002J\u0016\u0010J\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010,0,0/H\u0002J\b\u0010K\u001a\u00020LH\u0014J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010N\u001a\u00020:H\u0014J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u0005H\u0014J\b\u0010Q\u001a\u00020\u000eH\u0014J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001f0 2\u0006\u0010S\u001a\u00020\u001fH\u0002J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0006\u0010U\u001a\u00020VJ\u0010\u0010W\u001a\n -*\u0004\u0018\u00010,0,H\u0002J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u0002030\u0005H\u0002J\u0006\u0010Y\u001a\u00020\u0006J\u0010\u0010Z\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001fH\u0002J\u0010\u0010[\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001fH\u0002J\u0010\u0010\\\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001fH\u0002J\u0010\u0010]\u001a\u00020\u00172\u0006\u0010^\u001a\u00020\u000eH\u0002J\b\u0010_\u001a\u00020:H\u0002J\b\u0010`\u001a\u00020:H\u0002J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u0002030\u00052\u0006\u0010b\u001a\u00020\u0006H\u0003J\b\u0010c\u001a\u00020:H\u0002J\b\u0010d\u001a\u00020:H\u0002J\u0010\u0010e\u001a\u00020:2\u0006\u0010S\u001a\u00020\u001fH\u0002J\b\u0010f\u001a\u00020:H\u0002J\b\u0010g\u001a\u00020:H\u0002J\b\u0010h\u001a\u00020\u0017H\u0002J\b\u0010i\u001a\u00020:H\u0002J\b\u0010j\u001a\u00020:H\u0002J\b\u0010k\u001a\u00020:H\u0002J\b\u0010l\u001a\u00020:H\u0002J\b\u0010m\u001a\u00020:H\u0002J\b\u0010n\u001a\u00020:H\u0002J\b\u0010o\u001a\u00020:H\u0002J\b\u0010p\u001a\u00020:H\u0002J\b\u0010q\u001a\u00020:H\u0002J\n\u0010r\u001a\u0004\u0018\u00010PH\u0002J\n\u0010s\u001a\u0004\u0018\u00010PH\u0002J\n\u0010t\u001a\u0004\u0018\u00010PH\u0002J\n\u0010u\u001a\u0004\u0018\u00010PH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010+\u001a&\u0012\f\u0012\n -*\u0004\u0018\u00010,0, -*\u0012\u0012\f\u0012\n -*\u0004\u0018\u00010,0,\u0018\u00010\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010,0,0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f01X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u00102\u001aZ\u0012\f\u0012\n -*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u000203 -*\n\u0012\u0004\u0012\u000203\u0018\u00010\u00050\u0005 -*,\u0012\f\u0012\n -*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u000203 -*\n\u0012\u0004\u0012\u000203\u0018\u00010\u00050\u0005\u0018\u0001040\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u00060\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lgit4idea/rebase/GitRebaseDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "defaultRoot", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "bottomBranchFieldPlaceholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "bottomUpstreamFieldPlaceholder", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "", "currentBranch", "Lgit4idea/GitBranch;", "gitVersion", "Lgit4idea/config/GitVersion;", "Lorg/jetbrains/annotations/NotNull;", "localBranches", "", "okActionTriggered", "", "ontoField", "ontoLabel", "Lgit4idea/merge/dialog/CmdLabel;", "ontoValidator", "Lgit4idea/rebase/GitRebaseDialog$RevValidator;", "optionInfos", "", "Lgit4idea/rebase/GitRebaseOption;", "Lgit4idea/merge/dialog/OptionInfo;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "rebaseMergesAvailable", "rebaseSettings", "Lgit4idea/config/GitRebaseSettings;", "remoteBranches", "repositories", "Lgit4idea/repo/GitRepository;", "kotlin.jvm.PlatformType", "rootField", "Lcom/intellij/openapi/ui/ComboBox;", "selectedOptions", "", "tags", "Lgit4idea/GitTag;", "", "topBranchFieldPlaceholder", "topUpstreamFieldPlaceholder", "upstreamField", "upstreamValidator", "addBranchField", "", "top", "addUpstreamField", "createBranchField", "createCenterPanel", "createCmdLabel", "createDefaultActions", "createOntoField", "createOntoHelpButton", "Lcom/intellij/ui/InplaceButton;", "createOntoLabel", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/Nls;", "createPanel", "createPopupBuilder", "createRepoField", "createSouthPanel", "Ljavax/swing/JComponent;", "createUpstreamField", "doOKAction", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getHelpId", "getOptionInfo", "option", "getPreferredFocusedComponent", "getSelectedParams", "Lgit4idea/branch/GitRebaseParams;", "getSelectedRepo", "getTags", "gitRoot", "hasSeparatorAbove", "isOptionEnabled", "isOptionSelected", "isValidRevision", "revision", "loadRefs", "loadSettings", "loadTags", "root", "loadTagsInBackground", "moveNewBaseValue", "optionChosen", "saveSettings", "showRebaseHelpPopup", "showRootField", "updateBaseFields", "updateBottomPanel", "updateBranches", "updateOkActionEnabled", "updatePlaceholders", "updateTopPanel", "updateUi", "updateUpstreamField", "updateUpstreamFieldConstraints", "validateBranch", "validateOnto", "validateRebaseInProgress", "validateUpstream", "Companion", "RevValidator", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseDialog.kt\ngit4idea/rebase/GitRebaseDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,668:1\n31#2,2:669\n1603#3,9:671\n1855#3:680\n1856#3:682\n1612#3:683\n1855#3,2:684\n1603#3,9:686\n1855#3:695\n1856#3:697\n1612#3:698\n1549#3:699\n1620#3,3:700\n1549#3:703\n1620#3,3:704\n1549#3:707\n1620#3,3:708\n1#4:681\n1#4:696\n13#5:711\n*S KotlinDebug\n*F\n+ 1 GitRebaseDialog.kt\ngit4idea/rebase/GitRebaseDialog\n*L\n62#1:669,2\n123#1:671,9\n123#1:680\n123#1:682\n123#1:683\n178#1:684,2\n186#1:686,9\n186#1:695\n186#1:697\n186#1:698\n243#1:699\n243#1:700,3\n303#1:703\n303#1:704,3\n312#1:707\n312#1:708,3\n123#1:681\n186#1:696\n655#1:711\n*E\n"})
public final class GitRebaseDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final List<VirtualFile> roots;
    @Nullable
    private final VirtualFile defaultRoot;
    @NotNull
    private final GitRebaseSettings rebaseSettings;
    private final List<GitRepository> repositories;
    @NotNull
    private final Set<GitRebaseOption> selectedOptions;
    @NotNull
    private final GitOptionsPopupBuilder<GitRebaseOption> popupBuilder;
    @NotNull
    private final Map<GitRebaseOption, OptionInfo<GitRebaseOption>> optionInfos;
    @NotNull
    private final List<GitBranch> localBranches;
    @NotNull
    private final List<GitBranch> remoteBranches;
    private final Map<VirtualFile, List<GitTag>> tags;
    @Nullable
    private GitBranch currentBranch;
    @NotNull
    private final ComboBox<GitRepository> rootField;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> branchField;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> upstreamField;
    @NotNull
    private final CmdLabel ontoLabel;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> ontoField;
    private Placeholder topUpstreamFieldPlaceholder;
    private Placeholder topBranchFieldPlaceholder;
    private Placeholder bottomUpstreamFieldPlaceholder;
    private Placeholder bottomBranchFieldPlaceholder;
    @NotNull
    private final GitOptionsPanel<GitRebaseOption> optionsPanel;
    @NotNull
    private final DialogPanel panel;
    private boolean okActionTriggered;
    @NotNull
    private RevValidator upstreamValidator;
    @NotNull
    private RevValidator ontoValidator;
    @NotNull
    private final GitVersion gitVersion;
    private final boolean rebaseMergesAvailable;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Icon HELP_BUTTON_ICON_FOCUSED;
    private static final int SHORT_FIELD_LENGTH = 220;
    private static final int LONG_FIELD_LENGTH = 310;

    public GitRebaseDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @Nullable VirtualFile defaultRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        super(project);
        this.project = project;
        this.roots = roots;
        this.defaultRoot = defaultRoot;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitRebaseSettings> serviceClass$iv = GitRebaseSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.rebaseSettings = (GitRebaseSettings)object;
        this.repositories = DvcsUtil.sortRepositories((Collection)GitRepositoryManager.getInstance(this.project).getRepositories());
        this.selectedOptions = new LinkedHashSet();
        this.popupBuilder = this.createPopupBuilder();
        this.optionInfos = new LinkedHashMap();
        this.localBranches = new ArrayList();
        this.remoteBranches = new ArrayList();
        this.tags = Collections.synchronizedMap(new HashMap());
        this.rootField = this.createRepoField();
        this.branchField = this.createBranchField();
        this.upstreamField = this.createUpstreamField();
        this.ontoLabel = this.createOntoLabel();
        this.ontoField = this.createOntoField();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitRebaseOption, Unit>((Object)this){

            public final void invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitRebaseDialog.access$optionChosen((GitRebaseDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitRebaseOption, OptionInfo<GitRebaseOption>>((Object)this){

            @NotNull
            public final OptionInfo<GitRebaseOption> invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitRebaseDialog.access$getOptionInfo((GitRebaseDialog)((Object)this.receiver), p0);
            }
        });
        this.panel = this.createPanel();
        this.upstreamValidator = new RevValidator(this.upstreamField);
        this.ontoValidator = new RevValidator(this.ontoField);
        GitVersion gitVersion = GitVcs.getInstance(this.project).getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"getVersion(...)");
        this.gitVersion = gitVersion;
        this.rebaseMergesAvailable = GitVersionSpecialty.REBASE_MERGES_REPLACES_PRESERVE_MERGES.existsIn(this.gitVersion);
        this.setTitle(GitBundle.message("rebase.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("rebase.dialog.start.rebase", new Object[0]));
        this.loadRefs();
        this.updateBranches();
        this.loadSettings();
        this.init();
        this.updateUi();
        this.updateOkActionEnabled();
        ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)this.getRootPane()), (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.loadTagsInBackground();
            }
        }));
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return this.panel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new KFunction[]{new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateUpstream((GitRebaseDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateOnto((GitRebaseDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateRebaseInProgress((GitRebaseDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateBranch((GitRebaseDialog)((Object)this.receiver));
            }
        }};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        this.okActionTriggered = false;
        return result2;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createSouthPanel(...)");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.Rebase";
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.upstreamField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = (Action)new DialogWrapper.OkAction(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver);
            }

            protected void doAction(@Nullable ActionEvent e) {
                GitRebaseDialog.access$setOkActionTriggered$p(this.this$0, true);
                super.doAction(e);
            }
        };
    }

    @NotNull
    public final VirtualFile gitRoot() {
        VirtualFile virtualFile = ((GitRepository)this.rootField.getItem()).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return virtualFile;
    }

    @NotNull
    public final GitRebaseParams getSelectedParams() {
        String string;
        String newBase;
        String branch = (String)this.branchField.getItem();
        String string2 = newBase = this.selectedOptions.contains((Object)GitRebaseOption.ONTO) ? this.ontoField.getText() : null;
        if (!this.selectedOptions.contains((Object)GitRebaseOption.ROOT)) {
            string = this.upstreamField.getText();
            if (string == null) {
                string = "";
            }
        } else {
            string = null;
        }
        String upstream = string;
        return new GitRebaseParams(this.gitVersion, branch, newBase, upstream, CollectionsKt.intersect((Iterable)this.selectedOptions, (Iterable)GitRebaseOptionKt.getREBASE_FLAGS()), null, null, 96, null);
    }

    private final GitRepository getSelectedRepo() {
        return (GitRepository)this.rootField.getItem();
    }

    private final void saveSettings() {
        this.rebaseSettings.setOptions(CollectionsKt.intersect((Iterable)this.selectedOptions, (Iterable)GitRebaseOptionKt.getREBASE_FLAGS()));
        this.rebaseSettings.setNewBase(this.selectedOptions.contains((Object)GitRebaseOption.ONTO) ? this.ontoField.getText() : this.upstreamField.getText());
    }

    private final void loadSettings() {
        Set<GitRebaseOption> set = this.rebaseSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOptions(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRebaseOption option = (GitRebaseOption)((Object)element$iv);
            boolean bl = false;
            ((Collection)this.selectedOptions).add(option);
        }
        String newBase = this.rebaseSettings.getNewBase();
        CharSequence charSequence = newBase;
        if (!(charSequence == null || charSequence.length() == 0) && this.isValidRevision(newBase)) {
            this.upstreamField.setItem(newBase);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOkActionEnabled() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object = new KFunction[]{new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateUpstream((GitRebaseDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitRebaseDialog.access$validateOnto((GitRebaseDialog)((Object)this.receiver));
            }
        }};
        object = CollectionsKt.listOf((Object[])object);
        GitRebaseDialog gitRebaseDialog = this;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        gitRebaseDialog.setOKActionEnabled(((List)destination$iv$iv).isEmpty());
    }

    private final List<GitTag> getTags() {
        List list2 = this.tags.get(this.getSelectedRepo().getRoot());
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final ValidationInfo validateUpstream() {
        if (this.selectedOptions.contains((Object)GitRebaseOption.ROOT)) {
            return null;
        }
        String upstream = this.upstreamField.getText();
        CharSequence charSequence = upstream;
        if (charSequence == null || charSequence.length() == 0) {
            return this.selectedOptions.contains((Object)GitRebaseOption.ONTO) ? new ValidationInfo(GitBundle.message("rebase.dialog.error.upstream.not.selected", new Object[0]), (JComponent)((Object)this.upstreamField)) : new ValidationInfo(GitBundle.message("rebase.dialog.error.base.not.selected", new Object[0]), (JComponent)((Object)this.upstreamField));
        }
        return this.upstreamValidator.validate();
    }

    private final ValidationInfo validateOnto() {
        if (this.selectedOptions.contains((Object)GitRebaseOption.ONTO)) {
            String newBase = this.ontoField.getText();
            CharSequence charSequence = newBase;
            if ((charSequence == null || charSequence.length() == 0) && !this.selectedOptions.contains((Object)GitRebaseOption.ROOT)) {
                return new ValidationInfo(GitBundle.message("rebase.dialog.error.base.not.selected", new Object[0]), (JComponent)((Object)this.ontoField));
            }
            return this.ontoValidator.validate();
        }
        return null;
    }

    private final boolean isValidRevision(String revision) {
        if (((CharSequence)revision).length() == 0) {
            return true;
        }
        boolean result2 = false;
        try {
            ThrowableComputable task = () -> GitRebaseDialog.isValidRevision$lambda$3(this, revision);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(task, GitBundle.message("reference.validating.progress.indicator.title", new Object[0]), true, this.project);
            result2 = true;
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationInfo validateBranch() {
        void $this$mapTo$iv$iv;
        if (!this.selectedOptions.contains((Object)GitRebaseOption.SWITCH_BRANCH)) {
            return null;
        }
        String selectedBranch = this.branchField.getText();
        Object[] objectArray = (Object[])selectedBranch;
        if (objectArray == null || objectArray.length() == 0) {
            return new ValidationInfo(GitBundle.message("rebase.dialog.error.branch.not.selected", new Object[0]), (JComponent)((Object)this.branchField));
        }
        Iterable $this$map$iv = this.localBranches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitBranch gitBranch = (GitBranch)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (!((List)destination$iv$iv).contains(selectedBranch)) {
            objectArray = new Object[]{selectedBranch};
            return new ValidationInfo(GitBundle.message("rebase.dialog.error.branch.invalid", objectArray), (JComponent)((Object)this.branchField));
        }
        return null;
    }

    private final ValidationInfo validateRebaseInProgress() {
        if (this.getSelectedRepo().isRebaseInProgress()) {
            return new ValidationInfo(GitBundle.message("rebase.dialog.error.rebase.in.progress", new Object[0]));
        }
        return null;
    }

    private final void loadRefs() {
        this.localBranches.clear();
        this.remoteBranches.clear();
        GitRepository repository = this.getSelectedRepo();
        this.currentBranch = repository.getCurrentBranch();
        Collection collection = this.localBranches;
        List<GitLocalBranch> list2 = GitBranchUtil.sortBranchesByName(repository.getBranches().getLocalBranches());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"sortBranchesByName(...)");
        CollectionsKt.addAll((Collection)collection, (Iterable)list2);
        collection = this.remoteBranches;
        List<GitRemoteBranch> list3 = GitBranchUtil.sortBranchesByName(repository.getBranches().getRemoteBranches());
        Intrinsics.checkNotNullExpressionValue(list3, (String)"sortBranchesByName(...)");
        CollectionsKt.addAll((Collection)collection, (Iterable)list3);
    }

    private final void loadTagsInBackground() {
        VirtualFile virtualFile = this.getSelectedRepo().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile selectedRoot = virtualFile;
        Project project = this.project;
        String string = GitBundle.message("rebase.dialog.progress.loading.tags", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, selectedRoot, project, string){
            final /* synthetic */ GitRebaseDialog this$0;
            final /* synthetic */ VirtualFile $selectedRoot;
            {
                this.this$0 = $receiver;
                this.$selectedRoot = $selectedRoot;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable<Object> iterable = new LinkedHashSet<VirtualFile>(GitRebaseDialog.access$getRoots$p(this.this$0).size());
                Object object = this.$selectedRoot;
                GitRebaseDialog gitRebaseDialog = this.this$0;
                LinkedHashSet<VirtualFile> $this$run_u24lambda_u240 = iterable;
                boolean bl = false;
                $this$run_u24lambda_u240.add((VirtualFile)object);
                if (GitRebaseDialog.access$getDefaultRoot$p(gitRebaseDialog) != null) {
                    $this$run_u24lambda_u240.add(GitRebaseDialog.access$getDefaultRoot$p(gitRebaseDialog));
                }
                $this$run_u24lambda_u240.addAll(GitRebaseDialog.access$getRoots$p(gitRebaseDialog));
                LinkedHashSet<VirtualFile> sortedRoots = iterable;
                iterable = sortedRoots;
                object = this.this$0;
                gitRebaseDialog = this.$selectedRoot;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    List tagsInRepo = GitRebaseDialog.access$loadTags((GitRebaseDialog)((Object)object), root);
                    Map map2 = GitRebaseDialog.access$getTags$p((GitRebaseDialog)((Object)object));
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"access$getTags$p(...)");
                    map2.put(root, tagsInRepo);
                    if (!Intrinsics.areEqual((Object)((Object)gitRebaseDialog), (Object)root)) continue;
                    UIUtil.invokeLaterIfNeeded(() -> loadTagsInBackground.1.run$lambda$2$lambda$1((GitRebaseDialog)((Object)object)));
                }
            }

            public void onSuccess() {
                GitRebaseDialog.access$updateBaseFields(this.this$0);
            }

            private static final void run$lambda$2$lambda$1(GitRebaseDialog this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                GitRebaseDialog.access$updateBaseFields(this$0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private final List<GitTag> loadTags(VirtualFile root) {
        try {
            void $this$mapTo$iv$iv;
            List<String> list2 = GitBranchUtil.getAllTags(this.project, root);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllTags(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GitTag((String)it));
            }
            return (List)destination$iv$iv;
        }
        catch (VcsException e) {
            LOG.warn("Failed to load tags for root: " + root.getPresentableUrl(), (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateBranches() {
        MutableCollectionComboBoxModel mutableCollectionComboBoxModel = GitRebaseDialogKt.access$getMutableModel((JComboBox)((Object)this.branchField));
        if (mutableCollectionComboBoxModel != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.localBranches;
            MutableCollectionComboBoxModel mutableCollectionComboBoxModel2 = mutableCollectionComboBoxModel;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GitBranch gitBranch = (GitBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            mutableCollectionComboBoxModel2.update((List)destination$iv$iv);
        }
        this.updateBaseFields();
    }

    private final void updateBaseFields() {
        Object[] objectArray = new List[]{this.localBranches, this.remoteBranches, this.getTags()};
        List newRefs2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)updateBaseFields.newRefs.1.INSTANCE));
        this.upstreamField.updatePreserving((Function0<Unit>)((Function0)new Function0<Unit>(this, (List<String>)newRefs2){
            final /* synthetic */ GitRebaseDialog this$0;
            final /* synthetic */ List<String> $newRefs;
            {
                this.this$0 = $receiver;
                this.$newRefs = $newRefs;
                super(0);
            }

            public final void invoke() {
                block0: {
                    MutableCollectionComboBoxModel mutableCollectionComboBoxModel = GitRebaseDialogKt.access$getMutableModel((JComboBox)((Object)GitRebaseDialog.access$getUpstreamField$p(this.this$0)));
                    if (mutableCollectionComboBoxModel == null) break block0;
                    mutableCollectionComboBoxModel.update(this.$newRefs);
                }
            }
        }));
        this.ontoField.updatePreserving((Function0<Unit>)((Function0)new Function0<Unit>(this, (List<String>)newRefs2){
            final /* synthetic */ GitRebaseDialog this$0;
            final /* synthetic */ List<String> $newRefs;
            {
                this.this$0 = $receiver;
                this.$newRefs = $newRefs;
                super(0);
            }

            public final void invoke() {
                block0: {
                    MutableCollectionComboBoxModel mutableCollectionComboBoxModel = GitRebaseDialogKt.access$getMutableModel((JComboBox)((Object)GitRebaseDialog.access$getOntoField$p(this.this$0)));
                    if (mutableCollectionComboBoxModel == null) break block0;
                    mutableCollectionComboBoxModel.update(this.$newRefs);
                }
            }
        }));
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ GitRebaseDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$customizeSpacingConfiguration) {
                        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GitRebaseDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                if (GitRebaseDialog.access$showRootField(this.this$0)) {
                                    ComboBoxKt.columns((Cell)$this$row.cell((JComponent)GitRebaseDialog.access$getRootField$p(this.this$0)), (int)18).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
                                }
                                $this$row.cell((JComponent)GitRebaseDialog.access$createCmdLabel(this.this$0));
                                $this$row.cell((JComponent)GitRebaseDialog.access$getOntoLabel$p(this.this$0));
                                $this$row.cell((JComponent)((Object)GitRebaseDialog.access$getOntoField$p(this.this$0))).align((Align)AlignX.FILL.INSTANCE).resizableColumn().applyToComponent((Function1)new Function1<ComboBoxWithAutoCompletion<String>, Unit>(this.this$0){
                                    final /* synthetic */ GitRebaseDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ComboBoxWithAutoCompletion<String> $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$this$applyToComponent");
                                        $this$applyToComponent.setMinimumAndPreferredWidth(JBUI.scale((int)(GitRebaseDialog.access$showRootField(this.this$0) ? 220 : 310)));
                                    }
                                });
                                GitRebaseDialog.access$setTopUpstreamFieldPlaceholder$p(this.this$0, $this$row.placeholder().align((Align)AlignX.FILL.INSTANCE).resizableColumn());
                                GitRebaseDialog.access$setTopBranchFieldPlaceholder$p(this.this$0, $this$row.placeholder());
                            }
                        }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY((int)0, (int)6));
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GitRebaseDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                GitRebaseDialog.access$setBottomUpstreamFieldPlaceholder$p(this.this$0, $this$row.placeholder().align((Align)AlignX.FILL.INSTANCE).resizableColumn());
                                GitRebaseDialog.access$setBottomBranchFieldPlaceholder$p(this.this$0, $this$row.placeholder().align((Align)AlignX.FILL.INSTANCE).resizableColumn());
                            }
                        }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY((int)0, (int)6));
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GitRebaseDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)GitRebaseDialog.access$getOptionsPanel$p(this.this$0));
                            }
                        }), (int)1, null);
                    }
                });
                Unit unit = Unit.INSTANCE;
                GitRebaseDialog gitRebaseDialog = this.this$0;
                Unit $this$invoke_u24lambda_u240 = unit;
                boolean bl = false;
                GitRebaseDialog.access$addUpstreamField(gitRebaseDialog, true);
                GitRebaseDialog.access$updateUpstreamFieldConstraints(gitRebaseDialog);
            }
        }));
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git rebase", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)85), this.branchField.getPreferredSize().height, true));
    }

    private final CmdLabel createOntoLabel() {
        CmdLabel cmdLabel;
        CmdLabel $this$createOntoLabel_u24lambda_u247 = cmdLabel = new CmdLabel("--onto", new Insets(1, 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)80), this.branchField.getPreferredSize().height, true));
        boolean bl = false;
        $this$createOntoLabel_u24lambda_u247.setVisible(false);
        $this$createOntoLabel_u24lambda_u247.addComponent((JComponent)this.createOntoHelpButton());
        return cmdLabel;
    }

    private final InplaceButton createOntoHelpButton() {
        InplaceButton inplaceButton;
        InplaceButton $this$createOntoHelpButton_u24lambda_u249 = inplaceButton = new InplaceButton(new IconButton(GitBundle.message("rebase.dialog.help", new Object[0]), AllIcons.General.ContextHelp, HELP_BUTTON_ICON_FOCUSED), arg_0 -> GitRebaseDialog.createOntoHelpButton$lambda$8(this, arg_0));
        boolean bl = false;
        $this$createOntoHelpButton_u24lambda_u249.setBorder(JBUI.Borders.empty((int)1));
        $this$createOntoHelpButton_u24lambda_u249.setFocusable(true);
        $this$createOntoHelpButton_u24lambda_u249.addFocusListener((FocusListener)new FocusAdapter($this$createOntoHelpButton_u24lambda_u249){
            final /* synthetic */ InplaceButton $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void focusGained(@Nullable FocusEvent e) {
                this.$this_apply.repaint();
            }

            public void focusLost(@Nullable FocusEvent e) {
                this.$this_apply.repaint();
            }
        });
        $this$createOntoHelpButton_u24lambda_u249.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@Nullable KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 32 : false;
                if (bl) {
                    e.consume();
                    GitRebaseDialog.access$showRebaseHelpPopup(this.this$0);
                }
            }
        });
        return inplaceButton;
    }

    private final void showRebaseHelpPopup() {
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new GitRebaseHelpPopupPanel(), null).setAdText(GitBundle.message("rebase.help.popup.ad.text", new Object[0])).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).createPopup().showUnderneathOf((Component)this.getRootPane());
    }

    private final ComboBoxWithAutoCompletion<String> createOntoField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createOntoField_u24lambda_u2410 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel(), this.project);
        boolean bl = false;
        $this$createOntoField_u24lambda_u2410.setPrototypeDisplayValue("origin/long-enough-branch-name");
        $this$createOntoField_u24lambda_u2410.setVisible(false);
        $this$createOntoField_u24lambda_u2410.setMinimumAndPreferredWidth(JBUI.scale((int)(this.showRootField() ? 220 : 310)));
        String string = GitBundle.message("rebase.dialog.new.base", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createOntoField_u24lambda_u2410.setPlaceholder(string);
        $this$createOntoField_u24lambda_u2410.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0), null, null, 13, null)));
        $this$createOntoField_u24lambda_u2410.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GitRebaseDialog.access$updateOkActionEnabled(this.this$0);
            }
        });
        return comboBoxWithAutoCompletion;
    }

    private final ComboBoxWithAutoCompletion<String> createUpstreamField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createUpstreamField_u24lambda_u2411 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel(), this.project);
        boolean bl = false;
        $this$createUpstreamField_u24lambda_u2411.setPrototypeDisplayValue("origin/long-enough-branch-name");
        $this$createUpstreamField_u24lambda_u2411.setMinimumAndPreferredWidth(JBUI.scale((int)220));
        String string = GitBundle.message("rebase.dialog.target", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createUpstreamField_u24lambda_u2411.setPlaceholder(string);
        $this$createUpstreamField_u24lambda_u2411.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0), null, null, 13, null)));
        $this$createUpstreamField_u24lambda_u2411.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GitRebaseDialog.access$updateOkActionEnabled(this.this$0);
            }
        });
        return comboBoxWithAutoCompletion;
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        ComboBox<GitRepository> $this$createRepoField_u24lambda_u2413 = comboBox = GitMergeDialogKt.createRepositoryField(list2, this.defaultRoot);
        boolean bl = false;
        ActionListener listener2 = arg_0 -> GitRebaseDialog.createRepoField$lambda$13$lambda$12(this, arg_0);
        $this$createRepoField_u24lambda_u2413.addActionListener(listener2);
        return comboBox;
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createBranchField_u24lambda_u2414 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel(), this.project);
        boolean bl = false;
        $this$createBranchField_u24lambda_u2414.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message("rebase.dialog.branch.field", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBranchField_u24lambda_u2414.setPlaceholder(string);
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0);
        String string2 = GitBundle.message("merge.branch.popup.empty.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBranchField_u24lambda_u2414.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string2, null, 9, null)));
        return comboBoxWithAutoCompletion;
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$createOptionsDropDown_u24lambda_u2415 = dropDownLink = new DropDownLink((Object)GitBundle.message("merge.options.modify", new Object[0]), (Function1)new Function1<DropDownLink<String>, JBPopup>(this){
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JBPopup invoke(@NotNull DropDownLink<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (JBPopup)GitRebaseDialog.access$getPopupBuilder$p(this.this$0).createPopup();
            }
        });
        boolean bl = false;
        $this$createOptionsDropDown_u24lambda_u2415.setMnemonic(77);
        return dropDownLink;
    }

    private final GitOptionsPopupBuilder<GitRebaseOption> createPopupBuilder() {
        String string = GitBundle.message("rebase.options.modify.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GitOptionsPopupBuilder<GitRebaseOption>(this.project, string, createPopupBuilder.1.INSTANCE, (Function1)new Function1<GitRebaseOption, OptionInfo<GitRebaseOption>>((Object)this){

            @NotNull
            public final OptionInfo<GitRebaseOption> invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitRebaseDialog.access$getOptionInfo((GitRebaseDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitRebaseOption, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitRebaseDialog.access$isOptionSelected((GitRebaseDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitRebaseOption, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitRebaseDialog.access$isOptionEnabled((GitRebaseDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitRebaseOption, Unit>((Object)this){

            public final void invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitRebaseDialog.access$optionChosen((GitRebaseDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitRebaseOption, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GitRebaseOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitRebaseDialog.access$hasSeparatorAbove((GitRebaseDialog)((Object)this.receiver), p0);
            }
        });
    }

    private final boolean isOptionSelected(GitRebaseOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final boolean isOptionEnabled(GitRebaseOption option) {
        if (this.rebaseMergesAvailable) {
            return true;
        }
        return !(option == GitRebaseOption.REBASE_MERGES && this.selectedOptions.contains((Object)GitRebaseOption.INTERACTIVE) || option == GitRebaseOption.INTERACTIVE && this.selectedOptions.contains((Object)GitRebaseOption.REBASE_MERGES));
    }

    private final boolean hasSeparatorAbove(GitRebaseOption option) {
        return option == GitRebaseOption.INTERACTIVE;
    }

    private final OptionInfo<GitRebaseOption> getOptionInfo(GitRebaseOption option) {
        OptionInfo optionInfo = this.optionInfos.computeIfAbsent(option, arg_0 -> GitRebaseDialog.getOptionInfo$lambda$16((Function1)new Function1<GitRebaseOption, OptionInfo<GitRebaseOption>>(option, this){
            final /* synthetic */ GitRebaseOption $option;
            final /* synthetic */ GitRebaseDialog this$0;
            {
                this.$option = $option;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final OptionInfo<GitRebaseOption> invoke(@NotNull GitRebaseOption it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return new OptionInfo<GitRebaseOption>(this.$option, this.$option.getOption(GitRebaseDialog.access$getGitVersion$p(this.this$0)), this.$option.getDescription());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionInfo, (String)"computeIfAbsent(...)");
        return optionInfo;
    }

    private final void optionChosen(GitRebaseOption option) {
        if (!this.selectedOptions.contains((Object)option)) {
            ((Collection)this.selectedOptions).add(option);
        } else {
            ((Collection)this.selectedOptions).remove((Object)option);
        }
        if (option == GitRebaseOption.ONTO) {
            this.moveNewBaseValue();
        }
        this.updateUi();
        this.updateOkActionEnabled();
    }

    private final void moveNewBaseValue() {
        if (this.selectedOptions.contains((Object)GitRebaseOption.ONTO)) {
            this.ontoField.setItem(this.upstreamField.getText());
            this.upstreamField.setItem(null);
        } else {
            this.upstreamField.setItem(this.ontoField.getText());
            this.ontoField.setItem(null);
        }
    }

    private final void updateUpstreamField() {
        boolean enabled = !this.selectedOptions.contains((Object)GitRebaseOption.ROOT);
        this.upstreamField.setEnabled(enabled);
        this.upstreamField.setEditable(enabled);
    }

    private final void updateUi() {
        this.updatePlaceholders();
        this.updateUpstreamField();
        this.updateTopPanel();
        this.updateBottomPanel();
        this.optionsPanel.rerender(CollectionsKt.intersect((Iterable)this.selectedOptions, (Iterable)GitRebaseOptionKt.getREBASE_FLAGS()));
        this.panel.invalidate();
        SwingUtilities.invokeLater(() -> GitRebaseDialog.updateUi$lambda$17(this));
    }

    private final void updatePlaceholders() {
        String string = this.selectedOptions.contains((Object)GitRebaseOption.ONTO) ? GitBundle.message("rebase.dialog.old.base", new Object[0]) : GitBundle.message("rebase.dialog.target", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String placeHolder = string;
        this.upstreamField.setPlaceholder(placeHolder);
    }

    private final void updateTopPanel() {
        boolean showOntoField = this.selectedOptions.contains((Object)GitRebaseOption.ONTO);
        this.ontoLabel.setVisible(showOntoField);
        this.ontoField.setVisible(showOntoField);
        if (!showOntoField) {
            Placeholder placeholder = this.topUpstreamFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topUpstreamFieldPlaceholder");
                placeholder = null;
            }
            if (!Intrinsics.areEqual((Object)placeholder.getComponent(), this.upstreamField)) {
                this.addUpstreamField(true);
                this.updateUpstreamFieldConstraints();
            }
        }
        boolean showBranchField = !this.showRootField() && !showOntoField && this.selectedOptions.contains((Object)GitRebaseOption.SWITCH_BRANCH);
        boolean isDirty = false;
        if (showBranchField) {
            Placeholder placeholder = this.topBranchFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topBranchFieldPlaceholder");
                placeholder = null;
            }
            if (!Intrinsics.areEqual((Object)placeholder.getComponent(), this.branchField)) {
                this.addBranchField(true);
                int minWidth = JBUI.scale((int)220);
                this.upstreamField.setMinimumAndPreferredWidth(minWidth);
                this.branchField.setMinimumAndPreferredWidth(minWidth);
                isDirty = true;
            }
        } else {
            Placeholder placeholder = this.topBranchFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topBranchFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
            isDirty = true;
        }
        if (isDirty) {
            Placeholder placeholder = this.topUpstreamFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topUpstreamFieldPlaceholder");
                placeholder = null;
            }
            if (Intrinsics.areEqual((Object)placeholder.getComponent(), this.upstreamField)) {
                FlatComboBoxUI flatComboBoxUI;
                ComboBoxUI comboBoxUI = this.upstreamField.getUI();
                Intrinsics.checkNotNull((Object)comboBoxUI, (String)"null cannot be cast to non-null type git4idea.merge.dialog.FlatComboBoxUI");
                FlatComboBoxUI $this$updateTopPanel_u24lambda_u2418 = flatComboBoxUI = (FlatComboBoxUI)((Object)comboBoxUI);
                boolean bl = false;
                $this$updateTopPanel_u24lambda_u2418.setBorder(new Insets(1, 1, 1, !showBranchField ? 1 : 0));
                if (!showBranchField) {
                    this.updateUpstreamFieldConstraints();
                }
            }
        }
    }

    private final void updateBottomPanel() {
        boolean showBranch;
        boolean showRoot = this.showRootField();
        boolean showOnto = this.selectedOptions.contains((Object)GitRebaseOption.ONTO);
        boolean bl = showBranch = (showRoot || showOnto) && this.selectedOptions.contains((Object)GitRebaseOption.SWITCH_BRANCH);
        if (showOnto) {
            FlatComboBoxUI flatComboBoxUI;
            this.addUpstreamField(false);
            ComboBoxUI comboBoxUI = this.upstreamField.getUI();
            Intrinsics.checkNotNull((Object)comboBoxUI, (String)"null cannot be cast to non-null type git4idea.merge.dialog.FlatComboBoxUI");
            FlatComboBoxUI $this$updateBottomPanel_u24lambda_u2419 = flatComboBoxUI = (FlatComboBoxUI)((Object)comboBoxUI);
            boolean bl2 = false;
            $this$updateBottomPanel_u24lambda_u2419.setBorder(new Insets(1, 1, 1, !showBranch ? 1 : 0));
        }
        if (showBranch) {
            this.addBranchField(false);
        } else {
            Placeholder placeholder = this.bottomBranchFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bottomBranchFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
        }
    }

    private final void addBranchField(boolean top) {
        if (top) {
            Placeholder placeholder = this.bottomBranchFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bottomBranchFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
            Placeholder placeholder2 = this.topBranchFieldPlaceholder;
            if (placeholder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topBranchFieldPlaceholder");
                placeholder2 = null;
            }
            placeholder2.setComponent((JComponent)((Object)this.branchField));
        } else {
            Placeholder placeholder = this.topBranchFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topBranchFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
            Placeholder placeholder3 = this.bottomBranchFieldPlaceholder;
            if (placeholder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bottomBranchFieldPlaceholder");
                placeholder3 = null;
            }
            placeholder3.setComponent((JComponent)((Object)this.branchField));
        }
    }

    private final void addUpstreamField(boolean top) {
        if (top) {
            Placeholder placeholder = this.bottomUpstreamFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bottomUpstreamFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
            Placeholder placeholder2 = this.topUpstreamFieldPlaceholder;
            if (placeholder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topUpstreamFieldPlaceholder");
                placeholder2 = null;
            }
            placeholder2.setComponent((JComponent)((Object)this.upstreamField));
        } else {
            Placeholder placeholder = this.topUpstreamFieldPlaceholder;
            if (placeholder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topUpstreamFieldPlaceholder");
                placeholder = null;
            }
            placeholder.setComponent(null);
            Placeholder placeholder3 = this.bottomUpstreamFieldPlaceholder;
            if (placeholder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bottomUpstreamFieldPlaceholder");
                placeholder3 = null;
            }
            placeholder3.setComponent((JComponent)((Object)this.upstreamField));
        }
    }

    private final void updateUpstreamFieldConstraints() {
        this.upstreamField.setMinimumAndPreferredWidth(JBUI.scale((int)(!this.showRootField() ? 370 : 280)));
    }

    private static final GitRevisionNumber isValidRevision$lambda$3(GitRebaseDialog this$0, String $revision) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$revision, (String)"$revision");
        return GitRevisionNumber.resolve(this$0.project, this$0.gitRoot(), $revision);
    }

    private static final void createOntoHelpButton$lambda$8(GitRebaseDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.showRebaseHelpPopup();
    }

    private static final void createRepoField$lambda$13$lambda$12(GitRebaseDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadRefs();
        this$0.updateBranches();
    }

    private static final OptionInfo getOptionInfo$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OptionInfo)$tmp0.invoke(p0);
    }

    private static final void updateUi$lambda$17(GitRebaseDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.validate();
        this$0.pack();
    }

    public static final /* synthetic */ ValidationInfo access$validateUpstream(GitRebaseDialog $this) {
        return $this.validateUpstream();
    }

    public static final /* synthetic */ ValidationInfo access$validateOnto(GitRebaseDialog $this) {
        return $this.validateOnto();
    }

    public static final /* synthetic */ ValidationInfo access$validateRebaseInProgress(GitRebaseDialog $this) {
        return $this.validateRebaseInProgress();
    }

    public static final /* synthetic */ ValidationInfo access$validateBranch(GitRebaseDialog $this) {
        return $this.validateBranch();
    }

    public static final /* synthetic */ void access$setOkActionTriggered$p(GitRebaseDialog $this, boolean bl) {
        $this.okActionTriggered = bl;
    }

    public static final /* synthetic */ List access$getRoots$p(GitRebaseDialog $this) {
        return $this.roots;
    }

    public static final /* synthetic */ void access$updateBaseFields(GitRebaseDialog $this) {
        $this.updateBaseFields();
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRoot$p(GitRebaseDialog $this) {
        return $this.defaultRoot;
    }

    public static final /* synthetic */ List access$loadTags(GitRebaseDialog $this, VirtualFile root) {
        return $this.loadTags(root);
    }

    public static final /* synthetic */ Map access$getTags$p(GitRebaseDialog $this) {
        return $this.tags;
    }

    public static final /* synthetic */ ComboBoxWithAutoCompletion access$getUpstreamField$p(GitRebaseDialog $this) {
        return $this.upstreamField;
    }

    public static final /* synthetic */ ComboBoxWithAutoCompletion access$getOntoField$p(GitRebaseDialog $this) {
        return $this.ontoField;
    }

    public static final /* synthetic */ boolean access$showRootField(GitRebaseDialog $this) {
        return $this.showRootField();
    }

    public static final /* synthetic */ ComboBox access$getRootField$p(GitRebaseDialog $this) {
        return $this.rootField;
    }

    public static final /* synthetic */ CmdLabel access$createCmdLabel(GitRebaseDialog $this) {
        return $this.createCmdLabel();
    }

    public static final /* synthetic */ CmdLabel access$getOntoLabel$p(GitRebaseDialog $this) {
        return $this.ontoLabel;
    }

    public static final /* synthetic */ void access$setTopUpstreamFieldPlaceholder$p(GitRebaseDialog $this, Placeholder placeholder) {
        $this.topUpstreamFieldPlaceholder = placeholder;
    }

    public static final /* synthetic */ void access$setTopBranchFieldPlaceholder$p(GitRebaseDialog $this, Placeholder placeholder) {
        $this.topBranchFieldPlaceholder = placeholder;
    }

    public static final /* synthetic */ void access$setBottomUpstreamFieldPlaceholder$p(GitRebaseDialog $this, Placeholder placeholder) {
        $this.bottomUpstreamFieldPlaceholder = placeholder;
    }

    public static final /* synthetic */ void access$setBottomBranchFieldPlaceholder$p(GitRebaseDialog $this, Placeholder placeholder) {
        $this.bottomBranchFieldPlaceholder = placeholder;
    }

    public static final /* synthetic */ GitOptionsPanel access$getOptionsPanel$p(GitRebaseDialog $this) {
        return $this.optionsPanel;
    }

    public static final /* synthetic */ void access$addUpstreamField(GitRebaseDialog $this, boolean top) {
        $this.addUpstreamField(top);
    }

    public static final /* synthetic */ void access$updateUpstreamFieldConstraints(GitRebaseDialog $this) {
        $this.updateUpstreamFieldConstraints();
    }

    public static final /* synthetic */ GitOptionsPopupBuilder access$getPopupBuilder$p(GitRebaseDialog $this) {
        return $this.popupBuilder;
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitRebaseDialog $this, GitRebaseOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitRebaseDialog $this, GitRebaseOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitRebaseDialog $this, GitRebaseOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitRebaseDialog $this, GitRebaseOption option) {
        $this.optionChosen(option);
    }

    public static final /* synthetic */ boolean access$hasSeparatorAbove(GitRebaseDialog $this, GitRebaseOption option) {
        return $this.hasSeparatorAbove(option);
    }

    public static final /* synthetic */ GitVersion access$getGitVersion$p(GitRebaseDialog $this) {
        return $this.gitVersion;
    }

    public static final /* synthetic */ void access$showRebaseHelpPopup(GitRebaseDialog $this) {
        $this.showRebaseHelpPopup();
    }

    public static final /* synthetic */ void access$updateOkActionEnabled(GitRebaseDialog $this) {
        $this.updateOkActionEnabled();
    }

    static {
        Icon icon;
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        if (StartupUiUtil.isUnderDarcula()) {
            Icon icon2 = AllIcons.General.ContextHelp;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ContextHelp");
            icon = IconUtil.brighter((Icon)icon2, (int)3);
        } else {
            Icon icon3 = AllIcons.General.ContextHelp;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ContextHelp");
            icon = IconUtil.darker((Icon)icon3, (int)3);
        }
        HELP_BUTTON_ICON_FOCUSED = icon;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitRebaseDialog$Companion;", "", "()V", "HELP_BUTTON_ICON_FOCUSED", "Ljavax/swing/Icon;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LONG_FIELD_LENGTH", "", "SHORT_FIELD_LENGTH", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/rebase/GitRebaseDialog$RevValidator;", "", "field", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "", "(Lgit4idea/rebase/GitRebaseDialog;Lgit4idea/ui/ComboBoxWithAutoCompletion;)V", "lastValid", "", "lastValidatedRevision", "getValidationResult", "Lcom/intellij/openapi/ui/ValidationInfo;", "validate", "intellij.vcs.git"})
    public final class RevValidator {
        @NotNull
        private final ComboBoxWithAutoCompletion<String> field;
        @NotNull
        private String lastValidatedRevision;
        private boolean lastValid;

        public RevValidator(ComboBoxWithAutoCompletion<String> field) {
            Intrinsics.checkNotNullParameter(field, (String)"field");
            this.field = field;
            this.lastValidatedRevision = "";
            this.lastValid = true;
        }

        @Nullable
        public final ValidationInfo validate() {
            String revision;
            String string = this.field.getText();
            if (string == null) {
                string = revision = "";
            }
            if (!GitRebaseDialog.this.okActionTriggered) {
                return Intrinsics.areEqual((Object)revision, (Object)this.lastValidatedRevision) ? this.getValidationResult() : null;
            }
            this.lastValidatedRevision = revision;
            this.lastValid = GitRebaseDialog.this.isValidRevision(this.lastValidatedRevision);
            return this.getValidationResult();
        }

        private final ValidationInfo getValidationResult() {
            return this.lastValid ? null : new ValidationInfo(GitBundle.message("rebase.dialog.error.branch.or.tag.not.exist", new Object[0]), (JComponent)((Object)this.field));
        }
    }
}

