/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog.view;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntryWithDetails;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditorKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000b\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J4\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0005\u001a\u00020\"2\b\u0010\u0014\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0016J\u0012\u0010(\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;Lcom/intellij/openapi/Disposable;)V", "closeEditorAction", "git4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1", "Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1;", "commitMessageForEntry", "", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "hint", "Ljavax/swing/JLabel;", "lastUsedCommitMessageField", "value", "", "savedHeight", "getSavedHeight", "()I", "setSavedHeight", "(I)V", "createCommitMessage", "createHint", "getCellEditorValue", "", "Lorg/jetbrains/annotations/NotNull;", "getTableCellEditorComponent", "Ljava/awt/Component;", "Ljavax/swing/JTable;", "", "isSelected", "", "row", "column", "isCellEditable", "e", "Ljava/util/EventObject;", "registerCloseEditorShortcut", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "shortcut", "Ljavax/swing/KeyStroke;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCommitMessageCellEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitMessageCellEditor.kt\ngit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,182:1\n372#2,7:183\n*S KotlinDebug\n*F\n+ 1 CommitMessageCellEditor.kt\ngit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor\n*L\n97#1:183,7\n*E\n"})
public final class CommitMessageCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRebaseCommitsTableView table;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final closeEditorAction.1 closeEditorAction;
    @NotNull
    private final Map<GitRebaseEntryWithDetails, CommitMessage> commitMessageForEntry;
    @Nullable
    private CommitMessage lastUsedCommitMessageField;
    @NotNull
    private final JLabel hint;
    @NonNls
    @NotNull
    private static final String COMMIT_MESSAGE_HEIGHT_KEY = "Git.Interactive.Rebase.Dialog.Commit.Message.Height";
    private static final int HINT_HEIGHT = JBUIScale.scale((int)17);
    private static final int DEFAULT_COMMIT_MESSAGE_HEIGHT = GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT() * 5;

    public CommitMessageCellEditor(@NotNull Project project, @NotNull GitRebaseCommitsTableView table, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.table = table;
        this.disposable = disposable;
        this.closeEditorAction = new AbstractAction(this){
            final /* synthetic */ CommitMessageCellEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(@Nullable ActionEvent e) {
                this.this$0.stopCellEditing();
            }
        };
        this.commitMessageForEntry = new LinkedHashMap();
        this.hint = this.createHint();
    }

    private final int getSavedHeight() {
        return PropertiesComponent.getInstance((Project)this.project).getInt(COMMIT_MESSAGE_HEIGHT_KEY, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final void setSavedHeight(int value) {
        PropertiesComponent.getInstance((Project)this.project).setValue(COMMIT_MESSAGE_HEIGHT_KEY, value, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final CommitMessage createCommitMessage() {
        CommitMessage commitMessage;
        CommitMessage $this$createCommitMessage_u24lambda_u241 = commitMessage = new CommitMessage(this.project, false, false, true);
        boolean bl = false;
        $this$createCommitMessage_u24lambda_u241.getEditorField().addSettingsProvider(arg_0 -> CommitMessageCellEditor.createCommitMessage$lambda$1$lambda$0(this, arg_0));
        $this$createCommitMessage_u24lambda_u241.getEditorField().setCaretPosition(0);
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)$this$createCommitMessage_u24lambda_u241));
        return commitMessage;
    }

    private final void registerCloseEditorShortcut(EditorEx editor2, KeyStroke shortcut) {
        String key = "applyEdit" + shortcut;
        editor2.getContentComponent().getInputMap().put(shortcut, key);
        editor2.getContentComponent().getActionMap().put(key, this.closeEditorAction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        BorderLayoutPanel borderLayoutPanel;
        CommitMessage commitMessageField;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        GitRebaseCommitsTableModel<?> model = this.table.getModel();
        Object rebaseEntry = model.getEntry(row);
        if (!(rebaseEntry instanceof GitRebaseEntryWithDetails)) {
            return null;
        }
        Map<GitRebaseEntryWithDetails, CommitMessage> map2 = this.commitMessageForEntry;
        Object key$iv = rebaseEntry;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CommitMessage answer$iv = this.createCommitMessage();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        this.lastUsedCommitMessageField = commitMessageField = (CommitMessage)object;
        commitMessageField.setText(model.getCommitMessage(row));
        table.setRowHeight(row, this.getSavedHeight());
        BorderLayoutPanel componentPanel2 = new BorderLayoutPanel(commitMessageField){
            final /* synthetic */ CommitMessage $commitMessageField;
            {
                this.$commitMessageField = $commitMessageField;
            }

            public void requestFocus() {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> getTableCellEditorComponent.componentPanel.1.requestFocus$lambda$0(this.$commitMessageField));
            }

            private static final void requestFocus$lambda$0(CommitMessage $commitMessageField) {
                Intrinsics.checkNotNullParameter((Object)$commitMessageField, (String)"$commitMessageField");
                IdeFocusManager.getGlobalInstance().requestFocus((Component)$commitMessageField.getEditorField(), true);
            }
        };
        BorderLayoutPanel $this$getTableCellEditorComponent_u24lambda_u243 = borderLayoutPanel = componentPanel2.addToCenter((Component)commitMessageField).addToBottom((Component)this.hint);
        boolean bl = false;
        $this$getTableCellEditorComponent_u24lambda_u243.setBackground(table.getBackground());
        $this$getTableCellEditorComponent_u24lambda_u243.setBorder(JBUI.Borders.merge((Border)IdeBorderFactory.createBorder(), (Border)((Border)JBUI.Borders.empty((int)6, (int)0, (int)0, (int)6)), (boolean)true));
        Intrinsics.checkNotNull((Object)$this$getTableCellEditorComponent_u24lambda_u243);
        CommitMessageCellEditorKt.access$makeResizable((JPanel)$this$getTableCellEditorComponent_u24lambda_u243, (Function1)new Function1<Integer, Unit>(table, row, this){
            final /* synthetic */ JTable $table;
            final /* synthetic */ int $row;
            final /* synthetic */ CommitMessageCellEditor this$0;
            {
                this.$table = $table;
                this.$row = $row;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int newHeight) {
                int height = Math.max(CommitMessageCellEditor.access$getDEFAULT_COMMIT_MESSAGE_HEIGHT$cp(), newHeight);
                this.$table.setRowHeight(this.$row, height);
                CommitMessageCellEditor.access$setSavedHeight(this.this$0, height);
            }
        });
        return (Component)borderLayoutPanel;
    }

    private final JLabel createHint() {
        JLabel jLabel;
        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getCtrlEnter())};
        String string = GitBundle.message("rebase.interactive.dialog.reword.hint.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String hint = string;
        JLabel $this$createHint_u24lambda_u244 = jLabel = HintUtil.createAdComponent((String)hint, (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        boolean bl = false;
        $this$createHint_u24lambda_u244.setForeground(JBUI.CurrentTheme.BigPopup.advertiserForeground());
        $this$createHint_u24lambda_u244.setBackground(JBUI.CurrentTheme.BigPopup.advertiserBackground());
        $this$createHint_u24lambda_u244.setOpaque(true);
        JLabel jLabel2 = jLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"apply(...)");
        JLabel hintLabel = jLabel2;
        Dimension size = hintLabel.getPreferredSize();
        size.height = HINT_HEIGHT;
        hintLabel.setPreferredSize(size);
        return hintLabel;
    }

    @Override
    @NotNull
    public String getCellEditorValue() {
        Object object = this.lastUsedCommitMessageField;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    public boolean isCellEditable(@Nullable EventObject e) {
        return this.table.getSelectedRowCount() > 1 ? false : (e instanceof MouseEvent ? ((MouseEvent)e).getClickCount() >= 2 : true);
    }

    private static final void createCommitMessage$lambda$1$lambda$0(CommitMessageCellEditor this$0, EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        Intrinsics.checkNotNull((Object)editor2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 128);
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
        this$0.registerCloseEditorShortcut(editor2, keyStroke);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 256);
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"getKeyStroke(...)");
        this$0.registerCloseEditorShortcut(editor2, keyStroke2);
    }

    public static final /* synthetic */ int access$getDEFAULT_COMMIT_MESSAGE_HEIGHT$cp() {
        return DEFAULT_COMMIT_MESSAGE_HEIGHT;
    }

    public static final /* synthetic */ void access$setSavedHeight(CommitMessageCellEditor $this, int value) {
        $this.setSavedHeight(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$Companion;", "", "()V", "COMMIT_MESSAGE_HEIGHT_KEY", "", "DEFAULT_COMMIT_MESSAGE_HEIGHT", "", "HINT_HEIGHT", "canResize", "", "height", "point", "Ljava/awt/Point;", "canResize$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canResize$intellij_vcs_git(int height, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            int n = height - HINT_HEIGHT;
            int n2 = point.y;
            return n <= n2 ? n2 <= height : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

