/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.ui.StashInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 &2\u00020\u0001:\u0003&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\r\u0010$\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b%J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u001cH\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lgit4idea/stash/GitStashCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "Lgit4idea/stash/GitStashCache$StashId;", "kotlin.jvm.PlatformType", "Lgit4idea/stash/GitStashCache$StashData;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "stashTracker", "Lgit4idea/stash/GitStashTracker;", "getStashTracker", "()Lgit4idea/stash/GitStashTracker;", "clear", "", "clear$intellij_vcs_git", "dispose", "doLoadStashData", "stashId", "getCachedData", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "stashInfo", "Lgit4idea/ui/StashInfo;", "getFutureStashData", "Ljava/util/concurrent/CompletableFuture;", "cached", "", "loadFutureStashData", "id", "loadStashData", "preloadStashes", "preloadStashes$intellij_vcs_git", "Companion", "StashData", "StashId", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashCache.kt\ngit4idea/stash/GitStashCache\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n31#2,2:120\n1549#3:122\n1620#3,3:123\n1855#3,2:126\n*S KotlinDebug\n*F\n+ 1 GitStashCache.kt\ngit4idea/stash/GitStashCache\n*L\n37#1:120,2\n77#1:122\n77#1:123,3\n81#1:126,2\n*E\n"})
public final class GitStashCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private final ExecutorService executor;
    private final AsyncLoadingCache<StashId, StashData> cache;
    @NotNull
    private static final Logger LOG;

    public GitStashCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git Stash Loader", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.cache = Caffeine.newBuilder().executor((Executor)this.executor).buildAsync((arg_0, arg_1) -> GitStashCache.cache$lambda$1(this, arg_0, arg_1));
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    private final GitStashTracker getStashTracker() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GitStashTracker)object;
    }

    private final StashData doLoadStashData(StashId stashId) {
        try {
            LOG.debug("Loading stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'");
            Pair<Collection<Change>, List<GitCommit>> pair = GitStashOperations.INSTANCE.loadStashChanges(this.project, stashId.getRoot(), stashId.getHash(), stashId.getParentHashes());
            Collection changes = (Collection)pair.component1();
            List indexChanges = (List)pair.component2();
            return new StashData.Changes(changes, indexChanges);
        }
        catch (VcsException e) {
            LOG.warn("Could not load stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'", (Throwable)e);
            return new StashData.Error(e);
        }
        catch (Exception e) {
            if (!(e instanceof ProcessCanceledException)) {
                LOG.error("Could not load stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'", (Throwable)e);
            }
            throw new CompletionException(e);
        }
    }

    @Nullable
    public final CompletableFuture<StashData> loadStashData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        return this.getFutureStashData(stashInfo, false);
    }

    @Nullable
    public final StashData.Changes getCachedData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        CompletableFuture<StashData> completableFuture = this.getFutureStashData(stashInfo, true);
        StashData stashData = completableFuture != null ? (StashData)GitStashCache.Companion.getNowSafely(completableFuture) : null;
        return stashData instanceof StashData.Changes ? (StashData.Changes)stashData : null;
    }

    private final CompletableFuture<StashData> getFutureStashData(StashInfo stashInfo, boolean cached) {
        StashId id = this.stashId(stashInfo);
        return cached ? this.cache.getIfPresent((Object)id) : this.loadFutureStashData(id);
    }

    private final CompletableFuture<StashData> loadFutureStashData(StashId id) {
        if (this.disposableFlag.isDisposed()) {
            return null;
        }
        CompletableFuture future2 = this.cache.get((Object)id);
        return future2.isCancelled() ? this.cache.synchronous().refresh((Object)id) : future2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void preloadStashes$intellij_vcs_git() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = GitStashTrackerKt.allStashes(this.getStashTracker());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StashInfo stashInfo = (StashInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.stashId((StashInfo)it));
        }
        Set currentStashes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set previousStashes = this.cache.synchronous().asMap().keySet();
        this.cache.synchronous().invalidateAll((Iterable)SetsKt.minus(previousStashes, (Iterable)currentStashes));
        Iterable $this$forEach$iv = currentStashes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StashId it = (StashId)element$iv;
            boolean bl = false;
            this.loadFutureStashData(it);
        }
    }

    private final StashId stashId(StashInfo $this$stashId) {
        return new StashId($this$stashId.getHash(), $this$stashId.getParentHashes(), $this$stashId.getRoot());
    }

    public final void clear$intellij_vcs_git() {
        this.cache.synchronous().invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.MILLISECONDS);
        this.clear$intellij_vcs_git();
    }

    private static final StashData cache$lambda$1$lambda$0(GitStashCache this$0, StashId $stashId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)$stashId);
        return this$0.doLoadStashData($stashId);
    }

    private static final CompletableFuture cache$lambda$1(GitStashCache this$0, StashId stashId, Executor executor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return BackgroundTaskUtil.submitTask((Executor)executor, (Disposable)this$0, () -> GitStashCache.cache$lambda$1$lambda$0(this$0, stashId)).getFuture();
    }

    static {
        Logger logger = Logger.getInstance(GitStashCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\bH\u0002\u00a2\u0006\u0002\u0010\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/stash/GitStashCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getNowSafely", "T", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T getNowSafely(CompletableFuture<T> $this$getNowSafely) {
            T t;
            try {
                t = $this$getNowSafely.getNow(null);
            }
            catch (Throwable e) {
                t = null;
            }
            return t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData;", "", "()V", "Changes", "Error", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "Lgit4idea/stash/GitStashCache$StashData$Error;", "intellij.vcs.git"})
    public static abstract class StashData {
        private StashData() {
        }

        public /* synthetic */ StashData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lgit4idea/stash/GitStashCache$StashData$Changes;", "Lgit4idea/stash/GitStashCache$StashData;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "parentCommits", "Lgit4idea/GitCommit;", "(Ljava/util/Collection;Ljava/util/Collection;)V", "getChanges", "()Ljava/util/Collection;", "getParentCommits", "intellij.vcs.git"})
        public static final class Changes
        extends StashData {
            @NotNull
            private final Collection<Change> changes;
            @NotNull
            private final Collection<GitCommit> parentCommits;

            public Changes(@NotNull Collection<? extends Change> changes, @NotNull Collection<GitCommit> parentCommits) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Intrinsics.checkNotNullParameter(parentCommits, (String)"parentCommits");
                super(null);
                this.changes = changes;
                this.parentCommits = parentCommits;
            }

            @NotNull
            public final Collection<Change> getChanges() {
                return this.changes;
            }

            @NotNull
            public final Collection<GitCommit> getParentCommits() {
                return this.parentCommits;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData$Error;", "Lgit4idea/stash/GitStashCache$StashData;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends StashData {
            @NotNull
            private final VcsException error;

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final VcsException getError() {
                return this.error;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgit4idea/stash/GitStashCache$StashId;", "", "hash", "Lcom/intellij/vcs/log/Hash;", "parentHashes", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/vcs/log/Hash;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getParentHashes", "()Ljava/util/List;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class StashId {
        @NotNull
        private final Hash hash;
        @NotNull
        private final List<Hash> parentHashes;
        @NotNull
        private final VirtualFile root;

        public StashId(@NotNull Hash hash, @NotNull List<? extends Hash> parentHashes, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.hash = hash;
            this.parentHashes = parentHashes;
            this.root = root;
        }

        @NotNull
        public final Hash getHash() {
            return this.hash;
        }

        @NotNull
        public final List<Hash> getParentHashes() {
            return this.parentHashes;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final Hash component1() {
            return this.hash;
        }

        @NotNull
        public final List<Hash> component2() {
            return this.parentHashes;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.root;
        }

        @NotNull
        public final StashId copy(@NotNull Hash hash, @NotNull List<? extends Hash> parentHashes, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new StashId(hash, parentHashes, root);
        }

        public static /* synthetic */ StashId copy$default(StashId stashId, Hash hash, List list2, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                hash = stashId.hash;
            }
            if ((n & 2) != 0) {
                list2 = stashId.parentHashes;
            }
            if ((n & 4) != 0) {
                virtualFile = stashId.root;
            }
            return stashId.copy(hash, list2, virtualFile);
        }

        @NotNull
        public String toString() {
            return "StashId(hash=" + this.hash + ", parentHashes=" + this.parentHashes + ", root=" + this.root + ")";
        }

        public int hashCode() {
            int result2 = this.hash.hashCode();
            result2 = result2 * 31 + ((Object)this.parentHashes).hashCode();
            result2 = result2 * 31 + this.root.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StashId)) {
                return false;
            }
            StashId stashId = (StashId)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)stashId.hash)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parentHashes, stashId.parentHashes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.root, (Object)stashId.root);
        }
    }
}

