/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.Maven40ServerEmbedderImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter2.ElementFilter;
import org.jdom.filter2.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.security.ChecksumUtil;

public final class Maven40EffectivePomDumper {
    private static final String POM_XSD_URL = "https://maven.apache.org/maven-v4_0_0.xsd";
    private static final String SETTINGS_XSD_URL = "http://maven.apache.org/xsd/settings-1.0.0.xsd";

    @Nullable
    public static String dependencyHash(@Nullable MavenProject project) {
        if (null == project) {
            return null;
        }
        Model model = project.getModel();
        if (null == model) {
            return null;
        }
        List dependencies = model.getDependencies();
        if (null == dependencies) {
            return null;
        }
        if (dependencies.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Dependency dependency : dependencies) {
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getGroupId());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getArtifactId());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getVersion());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getType());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getClassifier());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getScope());
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getSystemPath());
            List exclusions = dependency.getExclusions();
            if (null != exclusions) {
                for (Exclusion exclusion : exclusions) {
                    Maven40EffectivePomDumper.append(stringBuffer, exclusion.getArtifactId());
                    Maven40EffectivePomDumper.append(stringBuffer, exclusion.getGroupId());
                }
            }
            Maven40EffectivePomDumper.append(stringBuffer, dependency.getOptional());
        }
        return ChecksumUtil.checksum((String)stringBuffer.toString());
    }

    private static void append(StringBuffer buffer, String s) {
        if (null != s) {
            buffer.append(s);
        }
    }

    @Nullable
    public static String checksum(@Nullable MavenProject project) {
        if (null == project) {
            return null;
        }
        Model pom = project.getModel();
        Maven40EffectivePomDumper.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
        }
        catch (IOException e) {
            return null;
        }
        return ChecksumUtil.checksum((String)sWriter.toString());
    }

    @Nullable
    public static String evaluateEffectivePom(Maven40ServerEmbedderImpl embedder, @NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        if (file == null) {
            Maven40EffectivePomDumper.$$$reportNull$$$0(0);
        }
        if (activeProfiles == null) {
            Maven40EffectivePomDumper.$$$reportNull$$$0(1);
        }
        if (inactiveProfiles == null) {
            Maven40EffectivePomDumper.$$$reportNull$$$0(2);
        }
        StringWriter w = new StringWriter();
        try {
            MavenExecutionRequest request = embedder.createRequest(file, activeProfiles, inactiveProfiles);
            embedder.executeWithMavenSession(request, () -> {
                try {
                    ProjectBuilder builder = embedder.getComponent(ProjectBuilder.class);
                    ProjectBuildingResult buildingResult = builder.build(new File(file.getPath()), request.getProjectBuildingRequest());
                    MavenProject project = buildingResult.getProject();
                    PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(new PrintWriter(w), StringUtils.repeat((String)" ", (int)2), "\n", null, null);
                    Maven40EffectivePomDumper.writeHeader((XMLWriter)writer);
                    Maven40EffectivePomDumper.writeEffectivePom(project, (XMLWriter)writer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return w.toString();
    }

    private static void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        Maven40EffectivePomDumper.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = Maven40EffectivePomDumper.addMavenNamespace(sWriter.toString(), true);
        Maven40EffectivePomDumper.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        SortedProperties properties = new SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }

    private static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private static boolean hasLineBreak(Element e) {
        return !e.getChildren().isEmpty() || e.getText().contains("\n");
    }

    private static boolean isOneEOFText(String text) {
        int eof = text.indexOf(10);
        return eof != -1 && eof == text.lastIndexOf(10) && text.trim().isEmpty();
    }

    private static void addLineBreaks(Element element) {
        List children = element.getContent();
        for (int i = 0; i < children.size() - 2; ++i) {
            Content c1 = (Content)children.get(i);
            Content c2 = (Content)children.get(i + 1);
            Content c3 = (Content)children.get(i + 2);
            if (!(c1 instanceof Element) || !(c2 instanceof Text) || !(c3 instanceof Element) || !Maven40EffectivePomDumper.hasLineBreak((Element)c1) && !Maven40EffectivePomDumper.hasLineBreak((Element)c3) || !Maven40EffectivePomDumper.isOneEOFText(((Text)c2).getText())) continue;
            element.setContent(i + 1, (Content)new Text(((Text)c2).getText().replace("\n", "\n\n")));
        }
    }

    private static void addLineBreaks(Document pomXml, Namespace pomNamespace) {
        Element rootElement = pomXml.getRootElement();
        Maven40EffectivePomDumper.addLineBreaks(rootElement);
        Element buildElement = rootElement.getChild("build", pomNamespace);
        if (buildElement != null) {
            Maven40EffectivePomDumper.addLineBreaks(buildElement);
        }
    }

    private static String addMavenNamespace(String effectiveXml, boolean isPom) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build((Reader)new StringReader(effectiveXml));
            Element rootElement = document.getRootElement();
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0");
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/4.0.0 " + (isPom ? POM_XSD_URL : SETTINGS_XSD_URL), xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
            Maven40EffectivePomDumper.addLineBreaks(document, pomNamespace);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            return w.toString();
        }
        catch (IOException | JDOMException e) {
            return effectiveXml;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "activeProfiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inactiveProfiles";
                break;
            }
        }
        objectArray[1] = "com/intellij/maven/server/m40/utils/Maven40EffectivePomDumper";
        objectArray[2] = "evaluateEffectivePom";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class SortedProperties
    extends Properties {
        static final long serialVersionUID = -8985316072702233744L;

        protected SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            Set<Object> keys = super.keySet();
            ArrayList<Object> list = new ArrayList<Object>(keys);
            Collections.sort(list, null);
            return new LinkedHashSet<Object>(list);
        }
    }
}

