/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TrackCoverageAction
extends ToggleModelAction {
    private final TestConsoleProperties myProperties;
    private TestFrameworkRunningModel myModel;
    private TreeSelectionListener myTreeSelectionListener;
    private Alarm myUpdateCoverageAlarm;
    private boolean myIsActive;

    TrackCoverageAction(TestConsoleProperties properties) {
        super(CoverageBundle.message("show.coverage.per.test.action.text", new Object[0]), CoverageBundle.message("show.coverage.per.test.action.description", new Object[0]), AllIcons.RunConfigurations.TrackCoverage, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.TRACK_CODE_COVERAGE);
        this.myProperties = properties;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            TrackCoverageAction.$$$reportNull$$$0(0);
        }
        this.myIsActive = state;
        if (state) {
            this.selectSubCoverageAsync();
        } else {
            this.restoreMergedCoverage();
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            TrackCoverageAction.$$$reportNull$$$0(1);
        }
        return this.myIsActive;
    }

    private void restoreMergedCoverage() {
        CoverageSuitesBundle currentSuite;
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(this.myProperties.getProject());
        if (coverageDataManager.isSubCoverageActive() && (currentSuite = this.getCurrentCoverageSuite()) != null) {
            coverageDataManager.restoreMergedCoverage(currentSuite);
        }
    }

    public void setModel(TestFrameworkRunningModel model) {
        if (this.myModel != null) {
            this.myModel.getTreeView().removeTreeSelectionListener(this.myTreeSelectionListener);
        }
        this.myModel = model;
        if (model != null) {
            this.myTreeSelectionListener = new MyTreeSelectionListener();
            this.myUpdateCoverageAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myModel);
            model.getTreeView().addTreeSelectionListener(this.myTreeSelectionListener);
            Disposer.register((Disposable)model, (Disposable)new Disposable(){

                public void dispose() {
                    TrackCoverageAction.this.restoreMergedCoverage();
                }
            });
        }
    }

    protected boolean isEnabled() {
        CoverageSuitesBundle suite2 = this.getCurrentCoverageSuite();
        return suite2 != null && suite2.isCoverageByTestApplicable() && suite2.isCoverageByTestEnabled();
    }

    protected boolean isVisible() {
        CoverageSuitesBundle suite2 = this.getCurrentCoverageSuite();
        return suite2 != null && suite2.isCoverageByTestApplicable();
    }

    @Nullable
    private CoverageSuitesBundle getCurrentCoverageSuite() {
        Executor executor;
        RunConfigurationBase base;
        if (this.myModel == null) {
            return null;
        }
        RunProfile runConf = this.myModel.getProperties().getConfiguration();
        if (runConf instanceof RunConfigurationBase && CoverageEnabledConfiguration.isApplicableTo(base = (RunConfigurationBase)runConf) && (executor = this.myProperties.getExecutor()) != null && executor.getId().equals("Coverage")) {
            CoverageSuite suite2 = CoverageEnabledConfiguration.getOrCreate(base).getCurrentCoverageSuite();
            return (CoverageSuitesBundle)ContainerUtil.find(CoverageDataManager.getInstance(this.myProperties.getProject()).activeSuites(), b -> b.contains(suite2));
        }
        return null;
    }

    private void selectSubCoverageAsync() {
        if (this.myUpdateCoverageAlarm == null || this.myUpdateCoverageAlarm.isDisposed()) {
            return;
        }
        this.myUpdateCoverageAlarm.cancelAllRequests();
        this.myUpdateCoverageAlarm.addRequest(() -> this.selectSubCoverage(), 300);
    }

    private void selectSubCoverage() {
        CoverageSuitesBundle currentSuite = this.getCurrentCoverageSuite();
        if (currentSuite != null) {
            AbstractTestProxy test = this.myModel.getTreeView().getSelectedTest();
            ArrayList<String> testMethods = new ArrayList<String>();
            if (test != null && !test.isInProgress()) {
                List list = test.getAllTests();
                for (AbstractTestProxy proxy : list) {
                    PsiElement element;
                    String name;
                    Location location = (Location)ReadAction.compute(() -> proxy.getLocation(this.myProperties.getProject(), this.myProperties.getScope()));
                    if (location == null || (name = (String)ReadAction.compute(() -> TrackCoverageAction.lambda$selectSubCoverage$3(currentSuite, element = location.getPsiElement(), proxy))) == null) continue;
                    testMethods.add(name);
                }
            }
            CoverageDataManager.getInstance(this.myProperties.getProject()).selectSubCoverage(currentSuite, testMethods);
        }
    }

    private static /* synthetic */ String lambda$selectSubCoverage$3(CoverageSuitesBundle currentSuite, PsiElement element, AbstractTestProxy proxy) throws RuntimeException {
        return currentSuite.getCoverageEngine().getTestMethodName(element, proxy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/coverage/actions/TrackCoverageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!TrackCoverageAction.this.myIsActive || !TrackCoverageAction.this.isEnabled()) {
                return;
            }
            TrackCoverageAction.this.selectSubCoverageAsync();
        }
    }
}

