/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

abstract class AbstractPathFencedLookup
extends AbstractStringLookup {
    protected final List<Path> fences;

    AbstractPathFencedLookup(Path ... fences) {
        this.fences = fences != null ? Arrays.asList(fences).stream().map(Path::toAbsolutePath).collect(Collectors.toList()) : Collections.emptyList();
    }

    protected Path getPath(String fileName2) {
        Path path = Paths.get(fileName2, new String[0]);
        if (this.fences.isEmpty()) {
            return path;
        }
        Path pathAbs = path.normalize().toAbsolutePath();
        Optional<Path> first = this.fences.stream().filter(pathAbs::startsWith).findFirst();
        if (first.isPresent()) {
            return path;
        }
        throw IllegalArgumentExceptions.format("[%s] -> [%s] not in %s", fileName2, pathAbs, this.fences);
    }
}

