/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.language.English;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class EnglishRedundancyRule
extends AbstractSimpleReplaceRule2 {
    public static final String EN_REDUNDANCY_REPLACE = "EN_REDUNDANCY_REPLACE";
    private static final String FILE_NAME = "/en/redundancies.txt";
    private static final Locale EN_LOCALE = new Locale("en");

    @Override
    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public EnglishRedundancyRule(ResourceBundle messages) throws IOException {
        super(messages, new English());
        this.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
        this.addExamplePair(Example.wrong("<marker>tuna fish</marker>"), Example.fixed("<marker>tuna</marker>"));
    }

    @Override
    public final String getId() {
        return EN_REDUNDANCY_REPLACE;
    }

    @Override
    public String getDescription() {
        return "1. Redundancy (General)";
    }

    @Override
    public String getShort() {
        return "Redundancy";
    }

    @Override
    public String getMessage() {
        return "'$match' is a redundancy. In some cases, it might be preferable to use $suggestions";
    }

    @Override
    public String getSuggestionsSeparator() {
        return " or ";
    }

    @Override
    public URL getUrl() {
        return Tools.getUrl("https://en.wikipedia.org/wiki/Redundancy_(linguistics)");
    }

    @Override
    public Locale getLocale() {
        return EN_LOCALE;
    }
}

