/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.annotator.YAMLInvalidBlockChildrenErrorAnnotator;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J+\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\b2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0017\u0010\u0015\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0017\u001a\f0\u000f\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0019\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u001a\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J%\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J \u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/yaml/annotator/YAMLInvalidBlockChildrenErrorAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "anotherErrorWillBeReported", "", "checkIndent", "elements", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "endOfLine", "", "subElement", "whole", "findNeededParent", "Lorg/jetbrains/annotations/Nullable;", "getMessageForParent", "Lorg/jetbrains/annotations/NotNull;", "isValidBlockMapChild", "isValidBlockSequenceChild", "reportAboutSameLine", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "reportSameLineWarning", "reportSubElementProblem", "reportWholeElementProblem", "reportElement", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nYAMLInvalidBlockChildrenErrorAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLInvalidBlockChildrenErrorAnnotator.kt\norg/jetbrains/yaml/annotator/YAMLInvalidBlockChildrenErrorAnnotator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,148:1\n1282#2,2:149\n1282#2,2:151\n1#3:153\n67#4:154\n*S KotlinDebug\n*F\n+ 1 YAMLInvalidBlockChildrenErrorAnnotator.kt\norg/jetbrains/yaml/annotator/YAMLInvalidBlockChildrenErrorAnnotator\n*L\n40#1:149,2\n52#1:151,2\n104#1:154\n*E\n"})
final class YAMLInvalidBlockChildrenErrorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement it;
        Object[] $this$firstOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)element, OuterLanguageElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findChildrenOfType(...)");
        if (!collection2.isEmpty()) {
            return;
        }
        if (this.anotherErrorWillBeReported(element)) {
            return;
        }
        if (this.reportSameLineWarning(element, holder)) {
            return;
        }
        if (element instanceof YAMLBlockMappingImpl) {
            Object object;
            block12: {
                if (!this.isValidBlockMapChild(((YAMLBlockMappingImpl)element).getFirstChild())) {
                    PsiElement psiElement = ((YAMLBlockMappingImpl)element).getFirstKeyValue().getKey();
                    if (psiElement == null) {
                        psiElement = (PsiElement)((YAMLBlockMappingImpl)element).getFirstKeyValue();
                    }
                    PsiElement psiElement2 = psiElement;
                    Intrinsics.checkNotNull((Object)psiElement2);
                    this.reportWholeElementProblem(holder, element, psiElement2);
                    return;
                }
                PsiElement[] psiElementArray = ((YAMLBlockMappingImpl)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                $this$firstOrNull$iv = psiElementArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(!this.isValidBlockMapChild(it))) continue;
                    object = element$iv;
                    break block12;
                }
                object = null;
            }
            PsiElement psiElement = (PsiElement)object;
            if (psiElement != null) {
                PsiElement it2 = psiElement;
                int n = 0;
                String string = YAMLBundle.message((String)"inspections.invalid.child.in.block.mapping", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportSubElementProblem(holder, string, it2);
            }
            Collection collection3 = ((YAMLBlockMappingImpl)element).getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getKeyValues(...)");
            List list = CollectionsKt.toList((Iterable)collection3);
            String string = YAMLBundle.message((String)"inspections.invalid.key.indent", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.checkIndent(list, holder, string);
        }
        if (element instanceof YAMLBlockSequenceImpl) {
            Object object;
            block13: {
                if (!this.isValidBlockSequenceChild(((YAMLBlockSequenceImpl)element).getFirstChild())) {
                    List list = ((YAMLBlockSequenceImpl)element).getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                    YAMLSequenceItem yAMLSequenceItem = (YAMLSequenceItem)CollectionsKt.firstOrNull((List)list);
                    this.reportWholeElementProblem(holder, element, (PsiElement)(yAMLSequenceItem != null ? (YAMLPsiElement)yAMLSequenceItem : (YAMLPsiElement)element));
                    return;
                }
                PsiElement[] psiElementArray = ((YAMLBlockSequenceImpl)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                $this$firstOrNull$iv = psiElementArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(!this.isValidBlockSequenceChild(it))) continue;
                    object = element$iv;
                    break block13;
                }
                object = null;
            }
            PsiElement psiElement = (PsiElement)object;
            if (psiElement != null) {
                PsiElement it3 = psiElement;
                boolean bl = false;
                String string = YAMLBundle.message((String)"inspections.invalid.child.in.block.sequence", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportSubElementProblem(holder, string, it3);
            }
            List list = ((YAMLBlockSequenceImpl)element).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            String string = YAMLBundle.message((String)"inspections.invalid.list.item.indent", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.checkIndent(list, holder, string);
        }
    }

    private final void reportWholeElementProblem(AnnotationHolder holder, PsiElement element, PsiElement reportElement) {
        holder.newAnnotation(HighlightSeverity.ERROR, this.getMessageForParent(element)).range(TextRange.create((int)PsiTreeUtilKt.getStartOffset((PsiElement)element), (int)this.endOfLine(reportElement, element))).create();
    }

    private final int endOfLine(PsiElement subElement, PsiElement whole) {
        PsiElement next;
        PsiElement current = subElement;
        while (PsiTreeUtil.nextLeaf((PsiElement)current) != null && PsiUtilCore.getElementType((PsiElement)next) != YAMLTokenTypes.EOL && PsiTreeUtilKt.getEndOffset((PsiElement)(current = next)) < PsiTreeUtilKt.getEndOffset((PsiElement)whole)) {
        }
        return Math.min(PsiTreeUtilKt.getEndOffset((PsiElement)current), PsiTreeUtilKt.getEndOffset((PsiElement)whole));
    }

    private final void checkIndent(List<? extends PsiElement> elements, AnnotationHolder holder, String message) {
        if (elements.size() > 1) {
            int firstIndent = YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)CollectionsKt.first(elements)));
            for (PsiElement psiElement : elements.subList(1, elements.size())) {
                if (YAMLUtil.getIndentToThisElement((PsiElement)psiElement) == firstIndent) continue;
                this.reportSubElementProblem(holder, message, psiElement);
            }
        }
    }

    private final String getMessageForParent(PsiElement element) {
        String string = this.findNeededParent(element) instanceof YAMLKeyValueImpl ? YAMLBundle.message((String)"inspections.invalid.child.in.block.mapping", (Object[])new Object[0]) : YAMLBundle.message((String)"inspections.invalid.child.in.block.sequence", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final boolean isValidBlockMapChild(PsiElement element) {
        PsiElement it = element;
        boolean bl = false;
        return it instanceof YAMLKeyValue || it instanceof YAMLAnchor || it instanceof LeafPsiElement;
    }

    private final boolean isValidBlockSequenceChild(PsiElement element) {
        PsiElement it = element;
        boolean bl = false;
        return it instanceof YAMLSequenceItem || it instanceof YAMLAnchor || it instanceof LeafPsiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean anotherErrorWillBeReported(PsiElement element) {
        void $this$parentOfType$iv;
        PsiElement kvParent;
        PsiElement psiElement = this.findNeededParent(element);
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = kvParent = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLKeyValueImpl yAMLKeyValueImpl = (YAMLKeyValueImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLKeyValueImpl.class, (boolean)true);
        if (yAMLKeyValueImpl == null) {
            return false;
        }
        YAMLKeyValueImpl kvGrandParent = yAMLKeyValueImpl;
        return YAMLUtil.psiAreAtTheSameLine((PsiElement)((PsiElement)kvGrandParent), (PsiElement)element);
    }

    private final PsiElement findNeededParent(PsiElement element) {
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, arg_0 -> YAMLInvalidBlockChildrenErrorAnnotator.findNeededParent$lambda$6(findNeededParent.1.INSTANCE, arg_0));
    }

    private final boolean reportSameLineWarning(PsiElement value, AnnotationHolder holder) {
        PsiElement keyValue = value.getParent();
        if (!(keyValue instanceof YAMLKeyValue)) {
            return false;
        }
        PsiElement psiElement = ((YAMLKeyValue)keyValue).getKey();
        if (psiElement == null) {
            return false;
        }
        PsiElement key = psiElement;
        if (value instanceof YAMLBlockMappingImpl) {
            YAMLKeyValue yAMLKeyValue = ((YAMLBlockMappingImpl)value).getFirstKeyValue();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"getFirstKeyValue(...)");
            YAMLKeyValue firstSubValue = yAMLKeyValue;
            if (YAMLUtil.psiAreAtTheSameLine((PsiElement)key, (PsiElement)((PsiElement)firstSubValue))) {
                this.reportAboutSameLine(holder, (YAMLValue)value);
                return true;
            }
        }
        if (value instanceof YAMLBlockSequenceImpl) {
            List list = ((YAMLBlockSequenceImpl)value).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            List items = list;
            if (items.isEmpty()) {
                return true;
            }
            YAMLSequenceItem firstItem = (YAMLSequenceItem)items.get(0);
            if (YAMLUtil.psiAreAtTheSameLine((PsiElement)key, (PsiElement)((PsiElement)firstItem))) {
                this.reportAboutSameLine(holder, (YAMLValue)value);
                return true;
            }
        }
        return false;
    }

    private final void reportAboutSameLine(AnnotationHolder holder, YAMLValue value) {
        String string = YAMLBundle.message((String)"annotator.same.line.composed.value.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.reportSubElementProblem(holder, string, (PsiElement)value);
    }

    private final void reportSubElementProblem(AnnotationHolder holder, String message, PsiElement subElement) {
        LeafElement leafElement = TreeUtil.findFirstLeaf((ASTNode)subElement.getNode());
        Object object = leafElement != null ? leafElement.getPsi() : null;
        if (object == null) {
            return;
        }
        PsiElement firstLeaf = object;
        holder.newAnnotation(HighlightSeverity.ERROR, message).range(TextRange.create((int)PsiTreeUtilKt.getStartOffset((PsiElement)subElement), (int)this.endOfLine(firstLeaf, subElement))).create();
    }

    private static final boolean findNeededParent$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

