/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline.shortcut;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.ml.inline.completion.impl.inline.shortcut.InlineCompletionShortcutChangeListener;
import com.intellij.ml.inline.completion.impl.inline.shortcut.InlineShortcutHint;
import com.intellij.ml.inline.completion.impl.inline.shortcut.InlineShortcutRendererBase;
import com.intellij.ml.inline.completion.impl.inline.shortcut.ShowInlineShortcutState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "lineNumber", "", "isMultiline", "", "(IZ)V", "hint", "Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHint;", "text", "", "getText", "()Ljava/lang/String;", "toPresentable", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "Presentable", "intellij.ml.inline.completion"})
public final class InlineShortcutHintElement
implements InlineCompletionElement {
    private final int lineNumber;
    @NotNull
    private final String text;
    @NotNull
    private final InlineShortcutHint hint;

    public InlineShortcutHintElement(int lineNumber2, boolean isMultiline) {
        this.lineNumber = lineNumber2;
        this.text = "";
        this.hint = InlineShortcutHint.Companion.random(isMultiline);
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public InlineCompletionElement.Presentable toPresentable() {
        return new Presentable(this, this.hint);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u0013H\u0002J\u000f\u0010#\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0015J\f\u0010$\u001a\u00020\b*\u00020%H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement$Presentable;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "element", "Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement;", "hint", "Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHint;", "(Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement;Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHint;)V", "currentShortcut", "", "getElement", "()Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement;", "offset", "", "Ljava/lang/Integer;", "shortcutInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutRendererBase;", "suffixInlay", "dispose", "", "endOffset", "()Ljava/lang/Integer;", "getBounds", "Ljava/awt/Rectangle;", "getShortcutRenderer", "getShortcutRepresentation", "getSuffixRenderer", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "hintShouldRender", "", "isVisible", "render", "Lcom/intellij/openapi/editor/Editor;", "rerender", "startOffset", "asString", "Lcom/intellij/openapi/actionSystem/Shortcut;", "Companion", "intellij.ml.inline.completion"})
    @SourceDebugExtension(value={"SMAP\nInlineShortcutHintElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineShortcutHintElement.kt\ncom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement$Presentable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,181:1\n1#2:182\n23#3:183\n*S KotlinDebug\n*F\n+ 1 InlineShortcutHintElement.kt\ncom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement$Presentable\n*L\n133#1:183\n*E\n"})
    public static final class Presentable
    implements InlineCompletionElement.Presentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final InlineShortcutHintElement element;
        @NotNull
        private final InlineShortcutHint hint;
        @Nullable
        private Inlay<InlineShortcutRendererBase> shortcutInlay;
        @Nullable
        private Inlay<InlineShortcutRendererBase> suffixInlay;
        @Nullable
        private Integer offset;
        @Nullable
        private String currentShortcut;
        @NotNull
        private static final Logger LOG;

        public Presentable(@NotNull InlineShortcutHintElement element, @NotNull InlineShortcutHint hint) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)hint), (String)"hint");
            this.element = element;
            this.hint = hint;
            this.currentShortcut = this.getShortcutRepresentation();
            InlineCompletionShortcutChangeListener.Companion.whenInsertShortcutChanged((Disposable)this, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.rerender();
                }
            }));
        }

        @NotNull
        public InlineShortcutHintElement getElement() {
            return this.element;
        }

        public boolean isVisible() {
            return this.getBounds() != null;
        }

        @Nullable
        public Rectangle getBounds() {
            if (!this.hintShouldRender()) {
                return null;
            }
            Object object = this.shortcutInlay;
            if (object == null || (object = object.getBounds()) == null) {
                return null;
            }
            Object shortcutBounds = object;
            Object object2 = this.suffixInlay;
            if (object2 == null || (object2 = object2.getBounds()) == null) {
                return null;
            }
            Object suffixBounds = object2;
            return ((Rectangle)shortcutBounds).union((Rectangle)suffixBounds);
        }

        @Nullable
        public Integer startOffset() {
            return this.offset;
        }

        @Nullable
        public Integer endOffset() {
            return this.offset;
        }

        public void dispose() {
            Disposable p0;
            Inlay<InlineShortcutRendererBase> inlay = this.shortcutInlay;
            if (inlay != null) {
                p0 = (Disposable)inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            Inlay<InlineShortcutRendererBase> inlay2 = this.suffixInlay;
            if (inlay2 != null) {
                p0 = (Disposable)inlay2;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            this.shortcutInlay = null;
            this.suffixInlay = null;
            this.offset = null;
        }

        public void render(@NotNull Editor editor2, int offset2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!(editor2 instanceof EditorImpl) || this.currentShortcut == null || !InlineShortcutRendererBase.Companion.isAvailableForLine(editor2, this.getElement().lineNumber)) {
                return;
            }
            try {
                int caretOffset = ((EditorImpl)editor2).getCaretModel().getOffset();
                this.shortcutInlay = ((EditorImpl)editor2).getInlayModel().addAfterLineEndElement(caretOffset, true, (EditorCustomElementRenderer)this.getShortcutRenderer());
                this.suffixInlay = ((EditorImpl)editor2).getInlayModel().addAfterLineEndElement(caretOffset, true, (EditorCustomElementRenderer)this.getSuffixRenderer((EditorImpl)editor2));
                this.offset = offset2;
            }
            catch (Exception e) {
                LOG.error("Could not render Full Line in-editor hint.", (Throwable)e);
            }
        }

        private final InlineShortcutRendererBase getSuffixRenderer(EditorImpl editor2) {
            String string = this.hint.getSuffixText();
            return new InlineShortcutRendererBase(this, editor2, string){
                final /* synthetic */ Presentable this$0;
                final /* synthetic */ EditorImpl $editor;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    super($super_call_param$1);
                }

                public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    if (!Presentable.access$hintShouldRender(this.this$0)) {
                        return;
                    }
                    InlineShortcutRendererBase.paintLabel$default(this, g, this.$editor, r, this.getText(), textAttributes, null, 32, null);
                }
            };
        }

        private final InlineShortcutRendererBase getShortcutRenderer() {
            String string = this.currentShortcut;
            return new InlineShortcutRendererBase(this, string){
                final /* synthetic */ Presentable this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    if (!Presentable.access$hintShouldRender(this.this$0)) {
                        return;
                    }
                    super.paint(inlay, g, r, textAttributes);
                }
            };
        }

        private final void rerender() {
            block2: {
                this.currentShortcut = this.getShortcutRepresentation();
                Inlay<InlineShortcutRendererBase> inlay = this.shortcutInlay;
                InlineShortcutRendererBase inlineShortcutRendererBase = inlay != null ? (InlineShortcutRendererBase)inlay.getRenderer() : null;
                if (inlineShortcutRendererBase != null) {
                    inlineShortcutRendererBase.setText(this.currentShortcut);
                }
                Inlay<InlineShortcutRendererBase> inlay2 = this.shortcutInlay;
                if (inlay2 != null) {
                    inlay2.update();
                }
                Inlay<InlineShortcutRendererBase> inlay3 = this.suffixInlay;
                if (inlay3 == null) break block2;
                inlay3.update();
            }
        }

        private final String getShortcutRepresentation() {
            Shortcut shortcut;
            Shortcut shortcut2 = shortcut = KeymapUtil.getPrimaryShortcut((String)this.hint.getActionId());
            return shortcut2 != null ? this.asString(shortcut2) : null;
        }

        private final String asString(Shortcut $this$asString) {
            String string;
            switch ($this$asString.toString()) {
                case "[pressed TAB]": {
                    string = "Tab";
                    break;
                }
                case "[pressed ENTER]": {
                    string = "Enter";
                    break;
                }
                case "[shift pressed RIGHT]": {
                    string = "Shift \u2192";
                    break;
                }
                default: {
                    String string2 = KeymapUtil.getShortcutText((Shortcut)$this$asString);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutText(...)");
                }
            }
            return string;
        }

        private final boolean hintShouldRender() {
            return this.currentShortcut != null && ShowInlineShortcutState.Companion.getState() == ShowInlineShortcutState.SHOW_HINT;
        }

        public static final /* synthetic */ boolean access$hintShouldRender(Presentable $this) {
            return $this.hintShouldRender();
        }

        static {
            Companion $this$thisLogger$iv = Companion = new Companion(null);
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            LOG = logger2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/shortcut/InlineShortcutHintElement$Presentable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.inline.completion"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

