/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.filter;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.FiltersKt;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import com.intellij.util.text.NameUtilCore;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\u0006*\u00020\u0003H\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\u0003H\u0002J\u0012\u0010\n\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b*\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u000b*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProfanityFilter;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter$Adapter;", "lastLine", "", "(Ljava/lang/String;)V", "checkRaw", "", "proposal", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "containsProfanePhrase", "containsProfaneWord", "", "getNGrams", "n", "", "splitCamelSnakeCaseNamesIntoWords", "Companion", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nfilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 filters.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/filter/ProfanityFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,273:1\n1549#2:274\n1620#2,2:275\n1622#2:281\n1747#2,3:282\n1360#2:285\n1446#2,5:286\n1360#2:291\n1446#2,5:292\n1747#2,3:297\n1549#2:300\n1620#2,3:301\n11065#3:277\n11400#3,3:278\n*S KotlinDebug\n*F\n+ 1 filters.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/filter/ProfanityFilter\n*L\n184#1:274\n184#1:275,2\n184#1:281\n190#1:282,3\n196#1:285\n196#1:286,5\n197#1:291\n197#1:292,5\n200#1:297,3\n202#1:300\n202#1:301,3\n185#1:277\n185#1:278,3\n*E\n"})
public final class ProfanityFilter
extends ProposalFilter.Adapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String lastLine;
    @NotNull
    private static final Set<String> PROFANE_PHRASES;
    @NotNull
    private static final Set<String> PROFANE_WORDS;
    @NotNull
    private static final Regex SPLITTER;
    private static final int MAX_PHRASE_SIZE = 4;

    public ProfanityFilter(@NotNull String lastLine) {
        Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
        super("profane word");
        this.lastLine = lastLine;
    }

    @Override
    public boolean checkRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        CharSequence charSequence = this.lastLine;
        Regex regex = SPLITTER;
        int n = 0;
        List splitLastLine = regex.split(charSequence, n);
        List lastWords = CollectionsKt.takeLast((List)splitLastLine, (int)4);
        String string = (String)CollectionsKt.lastOrNull((List)lastWords);
        if (string == null) {
            string = "";
        }
        String suggestion = string + proposal.getSuggestion();
        String line = CollectionsKt.joinToString$default((Iterable)lastWords, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + proposal.getSuggestion();
        return !this.containsProfanePhrase(line) && !this.containsProfaneWord(suggestion);
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<String>> splitCamelSnakeCaseNamesIntoWords(String $this$splitCamelSnakeCaseNamesIntoWords) {
        void $this$mapTo$iv$iv;
        CharSequence charSequence = $this$splitCamelSnakeCaseNamesIntoWords;
        Regex regex = SPLITTER;
        int n = 0;
        Iterable $this$map$iv = regex.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = NameUtilCore.splitNameIntoWords((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitNameIntoWords(...)");
            Object[] $this$map$iv2 = stringArray;
            boolean $i$f$map2 = false;
            Object[] objectArray = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            for (void item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p0;
                String string2 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string3 = p0.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                collection2.add(string3);
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    private final boolean containsProfanePhrase(String $this$containsProfanePhrase) {
        boolean bl;
        block3: {
            String splitLine = CollectionsKt.joinToString$default((Iterable)CollectionsKt.flatten((Iterable)this.splitCamelSnakeCaseNamesIntoWords($this$containsProfanePhrase)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            Iterable $this$any$iv = PROFANE_PHRASES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)splitLine, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsProfaneWord(String $this$containsProfaneWord) {
        Iterable list$iv$iv;
        List it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        List<List<String>> words = this.splitCamelSnakeCaseNamesIntoWords($this$containsProfaneWord);
        if (this.containsProfaneWord(CollectionsKt.flatten((Iterable)words))) return true;
        Iterable iterable = words;
        ProfanityFilter profanityFilter = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.getNGrams(it, 2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        if (profanityFilter.containsProfaneWord((List)destination$iv$iv)) return true;
        $this$flatMap$iv = words;
        profanityFilter = this;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.getNGrams(it, 3);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        if (!profanityFilter.containsProfaneWord((List)destination$iv$iv)) return false;
        return true;
    }

    private final boolean containsProfaneWord(List<String> $this$containsProfaneWord) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$containsProfaneWord;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PROFANE_WORDS.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getNGrams(List<String> $this$getNGrams, int n) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)(n - 1), (int)$this$getNGrams.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.joinToString$default((Iterable)$this$getNGrams.subList((int)(it - n + true), (int)(it + true)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        return (List)destination$iv$iv;
    }

    static {
        String[] stringArray = ProfanityFilter.class.getClassLoader().getResource("profane-phrases.txt");
        Intrinsics.checkNotNull((Object)stringArray);
        String[] stringArray2 = stringArray;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray2);
        stringArray2 = new String[]{"\n"};
        PROFANE_PHRASES = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)FiltersKt.access$rot13(new String(byArray, charset)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        URL uRL = ProfanityFilter.class.getClassLoader().getResource("profane-words.txt");
        Intrinsics.checkNotNull((Object)uRL);
        stringArray2 = uRL;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)stringArray2);
        stringArray2 = new String[]{"\n"};
        PROFANE_WORDS = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)FiltersKt.access$rot13(new String(byArray, charset)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        SPLITTER = new Regex("\\W+");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProfanityFilter$Companion;", "", "()V", "MAX_PHRASE_SIZE", "", "PROFANE_PHRASES", "", "", "PROFANE_WORDS", "SPLITTER", "Lkotlin/text/Regex;", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

