/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.python;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ml.inline.completion.impl.postprocessing.features.MLCompletionFeaturesCollector;
import com.intellij.ml.inline.completion.impl.postprocessing.features.MLCompletionFeaturesCollectorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.mlcompletion.PyArgumentsCompletionFeatures;
import com.jetbrains.python.codeInsight.mlcompletion.PyMlCompletionHelpers;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\rH\u0014J\u0010\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0014J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0014J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0012*\u00020\u0004H\u0016J$\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040!0 *\b\u0012\u0004\u0012\u00020\u00040 H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/ml/inline/completion/python/PythonFeaturesCollector;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/MLCompletionFeaturesCollectorBase;", "()V", "doGetReceiverClassElement", "Lcom/intellij/psi/PsiElement;", "element", "getArgumentFeatures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/MLCompletionFeaturesCollector$ArgumentFeatures;", "getBlockStatementLevel", "", "getBracketFeatures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/MLCompletionFeaturesCollector$BracketFeatures;", "getClassElement", "Ljava/lang/Class;", "getFuncElement", "getImportTarget", "getKeywordId", "text", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getNumOfPrevQualifiers", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "isClass", "", "isFunc", "isInAbstractMethodBody", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "isInConditionalStatement", "isInDocstring", "isInForStatement", "getImportSource", "withResolvedReference", "", "Lkotlin/Pair;", "intellij.ml.inline.completion.python"})
@SourceDebugExtension(value={"SMAP\nPythonFeaturesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonFeaturesCollector.kt\ncom/intellij/ml/inline/completion/python/PythonFeaturesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n800#2,11:124\n1603#2,9:135\n1855#2:144\n1856#2:147\n1612#2:148\n1#3:145\n1#3:146\n*S KotlinDebug\n*F\n+ 1 PythonFeaturesCollector.kt\ncom/intellij/ml/inline/completion/python/PythonFeaturesCollector\n*L\n102#1:124,11\n102#1:135,9\n102#1:144\n102#1:147\n102#1:148\n102#1:146\n*E\n"})
public final class PythonFeaturesCollector
extends MLCompletionFeaturesCollectorBase {
    public PythonFeaturesCollector() {
        Collection collection = CollectionsKt.listOf(PyImportElement.class);
        Pair[] pairArray = new Pair[2];
        Object[] objectArray = new String[]{"numpy", "scipy", "pandas", "sklearn", "torch", "pytorch_lightning", "tensorflow", "wandb", "pattern", "keras", "shogun", "chainer", "dask", "scrapy", "xgboost", "theano", "nltk", "dash", "plotly", "matplotlib"};
        pairArray[0] = TuplesKt.to((Object)"data_science", (Object)SetsKt.hashSetOf((Object[])objectArray));
        objectArray = new String[]{"django", "flask", "cherrypy", "pyramid", "tg", "gluon", "bottle", "tornado", "quixote"};
        pairArray[1] = TuplesKt.to((Object)"web", (Object)SetsKt.hashSetOf((Object[])objectArray));
        Map map = MapsKt.mapOf((Pair[])pairArray);
        Set set = PyMlCompletionHelpers.INSTANCE.getImportPopularity().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        super(collection, map, set);
    }

    @Override
    @Nullable
    public String getImportSource(@NotNull PsiElement $this$getImportSource) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getImportSource, (String)"<this>");
        if (!($this$getImportSource instanceof PyImportElement)) {
            return null;
        }
        PsiElement element = ((PyImportElement)$this$getImportSource).getParent();
        if (element instanceof PyFromImportStatement) {
            QualifiedName qualifiedName = ((PyFromImportStatement)element).getImportSourceQName();
            string = qualifiedName != null ? qualifiedName.getFirstComponent() : null;
        } else {
            QualifiedName qualifiedName = ((PyImportElement)$this$getImportSource).getImportedQName();
            string = qualifiedName != null ? qualifiedName.getFirstComponent() : null;
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getImportTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyImportElement pyImportElement = element instanceof PyImportElement ? (PyImportElement)element : null;
        if (pyImportElement == null || (pyImportElement = pyImportElement.getImportReferenceExpression()) == null || (pyImportElement = pyImportElement.getReference()) == null) {
            return null;
        }
        PyImportElement importReference = pyImportElement;
        Collection collection = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)importReference);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTargetCandidates(...)");
        return (PsiElement)CollectionsKt.firstOrNull((Iterable)collection);
    }

    @Override
    @Nullable
    public PsiElement doGetReceiverClassElement(@NotNull PsiElement element) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PyReferenceExpression.class);
        if (pyReferenceExpression == null) {
            return null;
        }
        PyReferenceExpression receiverReferenceExpression = pyReferenceExpression;
        PsiElement psiElement2 = receiverReferenceExpression.getReference().resolve();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement receiverDefinition = psiElement2;
        TypeEvalContext context2 = TypeEvalContext.codeInsightFallback((Project)element.getProject());
        PsiElement psiElement3 = receiverDefinition;
        if (psiElement3 instanceof PyClass ? true : psiElement3 instanceof PyFile) {
            psiElement = receiverDefinition;
        } else if (psiElement3 instanceof PyFunction) {
            PyType pyType = context2.getReturnType((PyCallable)receiverDefinition);
            psiElement = (PsiElement)(pyType != null ? pyType.getDeclarationElement() : null);
        } else if (psiElement3 instanceof PyTypedElement) {
            PyType pyType = context2.getType((PyTypedElement)receiverDefinition);
            psiElement = (PsiElement)(pyType != null ? pyType.getDeclarationElement() : null);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Override
    @Nullable
    public Boolean isInAbstractMethodBody(@NotNull PsiElement element) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyStatementList pyStatementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementList.class);
        if (pyStatementList == null) {
            return null;
        }
        PyStatementList statementList = pyStatementList;
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statementList), PyFunction.class);
        if (pyFunction == null) {
            return null;
        }
        PyFunction function = pyFunction;
        PyDecoratorList pyDecoratorList = (PyDecoratorList)function.getDecoratorList();
        if (pyDecoratorList != null) {
            PyDecoratorList it = pyDecoratorList;
            boolean bl2 = false;
            bl = it.findDecorator("abstractmethod") != null || it.findDecorator("abc.abstractmethod") != null;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Integer getNumOfPrevQualifiers(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        if (parent instanceof PyExpression) {
            return PyMlCompletionHelpers.INSTANCE.getQualifiedComponents((PyExpression)parent).size();
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getKeywordId(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return PyMlCompletionHelpers.INSTANCE.getKeywordId(text2);
    }

    @Override
    public boolean isInDocstring(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getParent() instanceof StringLiteralExpression;
    }

    @Override
    @NotNull
    public MLCompletionFeaturesCollector.ArgumentFeatures getArgumentFeatures(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyArgumentsCompletionFeatures.ArgumentsContextCompletionFeatures $this$getArgumentFeatures_u24lambda_u241 = PyArgumentsCompletionFeatures.INSTANCE.getContextArgumentFeatures(element);
        boolean bl = false;
        return new MLCompletionFeaturesCollector.ArgumentFeatures($this$getArgumentFeatures_u24lambda_u241.isInArguments(), $this$getArgumentFeatures_u24lambda_u241.isDirectlyInArgumentContext(), $this$getArgumentFeatures_u24lambda_u241.getArgumentIndex(), $this$getArgumentFeatures_u24lambda_u241.getArgumentsSize(), $this$getArgumentFeatures_u24lambda_u241.isIntoKeywordArgument(), $this$getArgumentFeatures_u24lambda_u241.getHaveNamedArgLeft(), $this$getArgumentFeatures_u24lambda_u241.getHaveNamedArgRight());
    }

    @Override
    @NotNull
    public MLCompletionFeaturesCollector.BracketFeatures getBracketFeatures(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new PyElementType[]{PyTokenTypes.GT, PyTokenTypes.LT, PyTokenTypes.LTLT, PyTokenTypes.GTGT, PyTokenTypes.LE, PyTokenTypes.GE, PyTokenTypes.GTGTEQ, PyTokenTypes.LTLTEQ, PyTokenTypes.NE_OLD, PyTokenTypes.RARROW};
        return this.getBracketFeatures(element, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public boolean isInConditionalStatement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyElementType pyElementType = PyTokenTypes.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"COLON");
        return this.isInStatement(element, PyConditionalStatementPart.class, (IElementType)pyElementType, PyStatementList.class);
    }

    @Override
    public boolean isInForStatement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyElementType pyElementType = PyTokenTypes.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"COLON");
        return this.isInStatement(element, PyForPart.class, (IElementType)pyElementType, PyStatementList.class);
    }

    @Override
    public int getBlockStatementLevel(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getBlockStatementLevel(element, PyStatementList.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<PsiElement, PsiElement>> withResolvedReference(@NotNull List<? extends PsiElement> $this$withResolvedReference) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$withResolvedReference, (String)"<this>");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)((PsiElement)CollectionsKt.first($this$withResolvedReference)).getProject(), (PsiFile)((PsiElement)CollectionsKt.first($this$withResolvedReference)).getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
        TypeEvalContext typeEvalContext2 = typeEvalContext;
        PyResolveContext pyResolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeEvalContext2);
        Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
        PyResolveContext pyResolveContext2 = pyResolveContext;
        Iterable $this$filterIsInstance$iv = $this$withResolvedReference;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PyReferenceExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PyReferenceExpression it = (PyReferenceExpression)element$iv$iv;
            boolean bl2 = false;
            if (it.getReference(pyResolveContext2).resolve() != null) {
                PsiElement reference;
                boolean bl3 = false;
                pair = new Pair((Object)it, (Object)reference);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected Class<? extends PsiElement> getClassElement() {
        return PyClass.class;
    }

    @Override
    @NotNull
    protected Class<? extends PsiElement> getFuncElement() {
        return PyFunction.class;
    }

    @Override
    protected boolean isClass(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PyClass;
    }

    @Override
    protected boolean isFunc(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PyFunction;
    }
}

