/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.completion.AlwaysMatchingCamelHumpMatcher;
import com.jetbrains.rd.ide.completion.DummyArranger;
import com.jetbrains.rd.ide.completion.FollowerLookupImpl;
import com.jetbrains.rd.ide.completion.LookupImplWrapper;
import com.jetbrains.rd.ide.completion.LookupModelWrapper;
import com.jetbrains.rd.ide.completion.LookupWrapper;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CustomLookupModel;
import com.jetbrains.rd.ide.model.LookupModel_GeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.actions.cwm.FrontendAsyncActionHost;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.completion.FrontendLookupManagerImpl;
import com.jetbrains.rdclient.completion.FrontendLookupManagerImplKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ5\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J5\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/completion/FrontendLookupManagerImpl;", "Lcom/intellij/codeInsight/lookup/impl/LookupManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lookupOrigin", "Lcom/jetbrains/rdclient/completion/FrontendLookupManagerImpl$LookupOrigin;", "createEmptyLookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isOwnLookup", "", "createForeignLookup", "items", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefix", "", "arranger", "Lcom/intellij/codeInsight/lookup/LookupArranger;", "(Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/String;Lcom/intellij/codeInsight/lookup/LookupArranger;)Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "createLookup", "Companion", "LookupOrigin", "intellij.rd.client"})
public final class FrontendLookupManagerImpl
extends LookupManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private LookupOrigin lookupOrigin;
    @NotNull
    private static final AtomicInteger lookupModelCounter = new AtomicInteger(0);

    public FrontendLookupManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.lookupOrigin = LookupOrigin.FRONTEND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LookupImpl createEmptyLookup(@NotNull Editor editor2, boolean isOwnLookup) {
        LookupImpl lookupImpl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(this.lookupOrigin == LookupOrigin.FRONTEND)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.lookupOrigin = isOwnLookup ? LookupOrigin.BACKEND_OWN : LookupOrigin.BACKEND_FOREIGN;
        try {
            lookupImpl = this.createLookup(editor2, new LookupElement[0], "", (LookupArranger)new DummyArranger());
        }
        finally {
            this.lookupOrigin = LookupOrigin.FRONTEND;
        }
        return lookupImpl;
    }

    private final LookupImpl createForeignLookup(Editor editor2, LookupElement[] items, String prefix, LookupArranger arranger) {
        FollowerLookupImpl lookup = new FollowerLookupImpl(this.project, editor2, arranger);
        if (!(items.length == 0)) {
            AlwaysMatchingCamelHumpMatcher matcher = new AlwaysMatchingCamelHumpMatcher(prefix);
            for (LookupElement item : items) {
                lookup.addItem(item, (PrefixMatcher)matcher);
            }
        }
        return (LookupImpl)lookup;
    }

    @NotNull
    public LookupImpl createLookup(@NotNull Editor editor2, @NotNull LookupElement[] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        LookupImpl lookupImpl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)arranger, (String)"arranger");
        if (this.lookupOrigin == LookupOrigin.BACKEND_FOREIGN) {
            return this.createForeignLookup(editor2, items, prefix, arranger);
        }
        LookupImpl lookupImpl2 = super.createLookup(editor2, items, prefix, arranger);
        Intrinsics.checkNotNullExpressionValue((Object)lookupImpl2, (String)"createLookup(...)");
        LookupImpl lookup = lookupImpl = lookupImpl2;
        boolean bl = false;
        if (this.lookupOrigin != LookupOrigin.BACKEND_OWN) {
            TextControlId editorId;
            Editor editor3;
            TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
            if (textControlId != null && (editor3 = FrontendTextControlHostKt.toEditorOrNull(editorId = textControlId)) != null && (editor3 = DocumentExKt.getEditorSynchronizer(editor3)) != null && (editor3 = editor3.getEditorModel()) != null) {
                Editor textControlModel = editor3;
                CustomLookupModel lookupModel = FrontendLookupManagerImpl.Companion.createCustomLookupModel(ClientId.Companion.getCurrent());
                LookupModel_GeneratedKt.getLookupModel((TextControlModel)textControlModel).getClientLookup().set((Object)lookupModel);
                LookupImplWrapper lookupImplWrapper = new LookupImplWrapper(lookup, true);
                LookupModelWrapper lookupModelWrapper2 = new LookupModelWrapper(lookupModel, LookupModel_GeneratedKt.getLookupModel((TextControlModel)textControlModel).getClientLookup(), (Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)lookup)), (Function1)createLookup.1.lookupModelWrapper.1.INSTANCE, (Function1)createLookup.1.lookupModelWrapper.2.INSTANCE);
                LookupWrapper.mirrorFrom$default((LookupWrapper)((LookupWrapper)lookupModelWrapper2), (LookupWrapper)((LookupWrapper)lookupImplWrapper), null, (int)2, null);
            }
        }
        return lookupImpl;
    }

    @NotNull
    protected LookupImpl createLookup(@NotNull Editor editor2, @NotNull LookupArranger arranger, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)arranger, (String)"arranger");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LookupImpl(editor2, project, arranger){
            @Nullable
            private final EditorSynchronizer editorSynchronizer;
            @Nullable
            private final DocumentSynchronizer documentSynchronizer;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;
            {
                this.$editor = $editor;
                this.$project = $project;
                super($project, $editor, $arranger);
                this.editorSynchronizer = DocumentExKt.getEditorSynchronizer($editor);
                Document document = $editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                this.documentSynchronizer = DocumentExKt.getDocumentSynchronizer(document, $project);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected boolean suppressHidingOnChange() {
                FrontendMarkupContributor editorMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.$editor);
                Project project = this.$editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                FrontendMarkupContributor documentMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(project, document);
                EditorSynchronizer editorSynchronizer = this.editorSynchronizer;
                if (editorSynchronizer != null ? editorSynchronizer.isReceivingChange() : false) return true;
                DocumentSynchronizer documentSynchronizer2 = this.documentSynchronizer;
                if (documentSynchronizer2 != null ? documentSynchronizer2.isReceivingChange() : false) return true;
                FrontendMarkupContributor frontendMarkupContributor = editorMarkupContributor;
                if (frontendMarkupContributor != null ? frontendMarkupContributor.isUpdating() : false) return true;
                FrontendMarkupContributor frontendMarkupContributor2 = documentMarkupContributor;
                if (frontendMarkupContributor2 == null) return false;
                boolean bl = frontendMarkupContributor2.isUpdating();
                if (!bl) return false;
                return true;
            }

            public void finishLookup(char completionChar, @Nullable LookupElement item) {
                ClientAppSession appSession = FrontendSessionsUtilKt.getFrontendProjectSession(this.$project).getAppSession();
                if (FrontendPatchEngineKt.getEngine(appSession).getHasActivePatch()) {
                    super.finishLookup(completionChar, item);
                    return;
                }
                if (this.$editor instanceof EditorImpl) {
                    String actionId = this.getChooseLookupItemActionId(completionChar);
                    AnAction completeAction = ActionManager.getInstance().getAction(actionId);
                    if (completeAction == null) {
                        FrontendLookupManagerImplKt.access$getLOG$p().error("There's no completion action for id=" + actionId);
                        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((EditorImpl)this.$editor).getDataContext());
                        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                        AnActionEvent event = anActionEvent;
                        FrontendAsyncActionHost.Companion.getInstance(appSession).execute(actionId, event);
                        return;
                    }
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)completeAction, null, (String)"unknown", (DataContext)((EditorImpl)this.$editor).getDataContext());
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    FrontendAsyncActionHost.Companion.getInstance(appSession).executeSpeculative(actionId, completeAction, actionEvent);
                } else {
                    super.finishLookup(completionChar, item);
                }
            }

            private final String getChooseLookupItemActionId(char completionChar) {
                char c = completionChar;
                return c == '\t' ? "EditorChooseLookupItemReplace" : (c == '\r' ? "EditorChooseLookupItemCompleteStatement" : "EditorChooseLookupItem");
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/completion/FrontendLookupManagerImpl$Companion;", "", "()V", "lookupModelCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "createCustomLookupModel", "Lcom/jetbrains/rd/ide/model/CustomLookupModel;", "ownerId", "Lcom/intellij/codeWithMe/ClientId;", "extractCompletionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        private final CustomLookupModel createCustomLookupModel(ClientId ownerId) {
            return new CustomLookupModel(lookupModelCounter.incrementAndGet(), ownerId.getValue());
        }

        private final CompletionItem extractCompletionItem(LookupElement element) {
            CompletionItem completionItem;
            LookupElement lookupElement = element;
            if (lookupElement instanceof LookupElementDecorator) {
                LookupElement lookupElement2 = ((LookupElementDecorator)element).getDelegate();
                Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"getDelegate(...)");
                completionItem = this.extractCompletionItem(lookupElement2);
            } else {
                completionItem = lookupElement instanceof ProtocolLookupItemBase ? ((ProtocolLookupItemBase)element).getCompletionItem() : null;
            }
            return completionItem;
        }

        public static final /* synthetic */ CompletionItem access$extractCompletionItem(Companion $this, LookupElement element) {
            return $this.extractCompletionItem(element);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/completion/FrontendLookupManagerImpl$LookupOrigin;", "", "(Ljava/lang/String;I)V", "BACKEND_FOREIGN", "BACKEND_OWN", "FRONTEND", "intellij.rd.client"})
    private static final class LookupOrigin
    extends Enum<LookupOrigin> {
        public static final /* enum */ LookupOrigin BACKEND_FOREIGN = new LookupOrigin();
        public static final /* enum */ LookupOrigin BACKEND_OWN = new LookupOrigin();
        public static final /* enum */ LookupOrigin FRONTEND = new LookupOrigin();
        private static final /* synthetic */ LookupOrigin[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LookupOrigin[] values() {
            return (LookupOrigin[])$VALUES.clone();
        }

        public static LookupOrigin valueOf(String value) {
            return Enum.valueOf(LookupOrigin.class, value);
        }

        @NotNull
        public static EnumEntries<LookupOrigin> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lookupOriginArray = new LookupOrigin[]{LookupOrigin.BACKEND_FOREIGN, LookupOrigin.BACKEND_OWN, LookupOrigin.FRONTEND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

