/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.CodeFoldingEventsModel;
import com.jetbrains.rd.ide.model.FoldRegionStateChangeEvent;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.IFrontendProtocolMarkupExtension;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelSupport;
import com.jetbrains.rdclient.daemon.highlighters.MarkupListenerManager;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingManager;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelSupport;", "()V", "createHandler", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "markupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "MyFoldingListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCodeFoldingModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n13#2:125\n13#2:126\n*S KotlinDebug\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport\n*L\n58#1:125\n33#1:126\n*E\n"})
public class FrontendCodeFoldingModelSupport
implements IProtocolHighlighterModelSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @Nullable
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session, @NotNull RdMarkupModel markupModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return null;
    }

    @Override
    @Nullable
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session, @NotNull RdMarkupModel markupModel, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Function0<Function1<FoldingInfo, Boolean>> expandedCallbackFactory = FrontendCodeFoldingManager.Companion.getInstance().getFoldingExpandedCallbackFactory();
        FrontendEditorFoldingModelAdapter foldingModelAdapter = new FrontendEditorFoldingModelAdapter(editor2, expandedCallbackFactory);
        MarkupListenerManager.Companion.getInstance().attachListener(lifetime, editor2, foldingModelAdapter);
        if (editor2 instanceof EditorEx) {
            CodeFoldingEventsModel eventsModel = (CodeFoldingEventsModel)IFrontendProtocolMarkupExtension.Companion.getExtension(markupModel, FrontendCodeFoldingModelSupportKt.access$getCODE_FOLDING_EVENTS_MODEL_EXTENSION_KEY$p());
            ((EditorEx)editor2).getFoldingModel().addListener((FoldingListener)new MyFoldingListener((EditorEx)editor2, eventsModel), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendCodeFoldingModelSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot sync foldings state because the editor doesn't implement EditorEx interface: editor.class=" + editor2.getClass().getSimpleName());
        }
        return new FrontendCodeFoldingModelHandler();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendCodeFoldingModelSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$MyFoldingListener;", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "codeFoldingEventsModel", "Lcom/jetbrains/rd/ide/model/CodeFoldingEventsModel;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/ide/model/CodeFoldingEventsModel;)V", "changesAccumulator", "", "Lcom/jetbrains/rd/ide/model/FoldRegionStateChangeEvent;", "findBackendIdForFoldRegion", "", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "(Lcom/intellij/openapi/editor/FoldRegion;)Ljava/lang/Long;", "onFoldProcessingEnd", "", "onFoldRegionStateChange", "intellij.rd.client"})
    private static final class MyFoldingListener
    implements FoldingListener {
        @NotNull
        private final EditorEx editor;
        @NotNull
        private final CodeFoldingEventsModel codeFoldingEventsModel;
        @NotNull
        private final List<FoldRegionStateChangeEvent> changesAccumulator;

        public MyFoldingListener(@NotNull EditorEx editor2, @NotNull CodeFoldingEventsModel codeFoldingEventsModel) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)codeFoldingEventsModel, (String)"codeFoldingEventsModel");
            this.editor = editor2;
            this.codeFoldingEventsModel = codeFoldingEventsModel;
            this.changesAccumulator = new ArrayList();
        }

        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            LocalChangeKt.ignoreOnReentrancy((UpdateFlag)FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0)((Function0)new Function0<Unit>(this, region){
                final /* synthetic */ MyFoldingListener this$0;
                final /* synthetic */ FoldRegion $region;
                {
                    this.this$0 = $receiver;
                    this.$region = $region;
                    super(0);
                }

                public final void invoke() {
                    Long l = MyFoldingListener.access$findBackendIdForFoldRegion(this.this$0, this.$region);
                    if (l == null) {
                        MyFoldingListener myFoldingListener = this.this$0;
                        FoldRegion foldRegion = this.$region;
                        MyFoldingListener $this$invoke_u24lambda_u241 = myFoldingListener;
                        boolean bl = false;
                        Logger $this$trace$iv = FrontendCodeFoldingModelSupport.access$getLOG$cp();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl2 = false;
                            logger.trace("backendId was not for FoldRegion (" + foldRegion.getStartOffset() + ", " + foldRegion.getEndOffset() + ")");
                        }
                        return;
                    }
                    long backendId = l;
                    MyFoldingListener.access$getChangesAccumulator$p(this.this$0).add(new FoldRegionStateChangeEvent(backendId, this.$region.isExpanded()));
                }
            }));
        }

        public void onFoldProcessingEnd() {
            if (this.changesAccumulator.isEmpty()) {
                return;
            }
            this.codeFoldingEventsModel.getFoldRegionsStatesChanged().fire(this.changesAccumulator);
            this.changesAccumulator.clear();
        }

        private final Long findBackendIdForFoldRegion(FoldRegion region) {
            Ref.ObjectRef backendId = new Ref.ObjectRef();
            this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(region.getStartOffset(), region.getEndOffset(), arg_0 -> MyFoldingListener.findBackendIdForFoldRegion$lambda$0(region, backendId, arg_0));
            return (Long)backendId.element;
        }

        private static final boolean findBackendIdForFoldRegion$lambda$0(FoldRegion $region, Ref.ObjectRef $backendId, RangeHighlighterEx it) {
            Intrinsics.checkNotNullParameter((Object)$region, (String)"$region");
            Intrinsics.checkNotNullParameter((Object)$backendId, (String)"$backendId");
            if (it.getStartOffset() == $region.getStartOffset() && it.getEndOffset() == $region.getEndOffset()) {
                Intrinsics.checkNotNull((Object)it);
                if (HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) {
                    $backendId.element = UtilKt.getBackendId((RangeHighlighter)((RangeHighlighter)it));
                    return false;
                }
            }
            return true;
        }

        public static final /* synthetic */ Long access$findBackendIdForFoldRegion(MyFoldingListener $this, FoldRegion region) {
            return $this.findBackendIdForFoldRegion(region);
        }

        public static final /* synthetic */ List access$getChangesAccumulator$p(MyFoldingListener $this) {
            return $this.changesAccumulator;
        }
    }
}

