/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rdclient.gotoType.GotoHost;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItemRendererData;
import com.jetbrains.rdclient.gotoType.ProtocolSEContributorRenderer;
import com.jetbrains.rdclient.gotoType.ProtocolSENavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolSearchEverywhereContributorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u001e0\u001dH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020$H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016J \u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereContributor;", "Lcom/intellij/ide/actions/searcheverywhere/WeightedSearchEverywhereContributor;", "Lcom/jetbrains/rdclient/gotoType/ProtocolNavigationItem;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "everywhereAction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "getEverywhereAction", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "setEverywhereAction", "(Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;)V", "gotoKey", "Lcom/jetbrains/rd/ide/model/GotoKey;", "getGotoKey", "()Lcom/jetbrains/rd/ide/model/GotoKey;", "getProject", "()Lcom/intellij/openapi/project/Project;", "shouldAccessVfsWhenPresentingItems", "", "getShouldAccessVfsWhenPresentingItems", "()Z", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "getDataForItem", "", "element", "dataId", "getElementsRenderer", "Ljavax/swing/ListCellRenderer;", "getSearchProviderId", "processSelectedItem", "selected", "modifiers", "", "searchText", "showInFindResults", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolSearchEverywhereContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolSearchEverywhereContributor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n10394#2,5:99\n1002#3,2:104\n1855#3,2:106\n*S KotlinDebug\n*F\n+ 1 ProtocolSearchEverywhereContributor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereContributor\n*L\n46#1:99,5\n47#1:104,2\n48#1:106,2\n*E\n"})
public abstract class ProtocolSearchEverywhereContributor
implements WeightedSearchEverywhereContributor<ProtocolNavigationItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private SearchEverywhereToggleAction everywhereAction;
    private final boolean shouldAccessVfsWhenPresentingItems;

    public ProtocolSearchEverywhereContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.shouldAccessVfsWhenPresentingItems = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final SearchEverywhereToggleAction getEverywhereAction() {
        return this.everywhereAction;
    }

    public final void setEverywhereAction(@Nullable SearchEverywhereToggleAction searchEverywhereToggleAction) {
        this.everywhereAction = searchEverywhereToggleAction;
    }

    public boolean showInFindResults() {
        return true;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    public abstract GotoKey getGotoKey();

    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<ProtocolNavigationItem>> consumer) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (progressIndicator.isCanceled()) {
            ProtocolSearchEverywhereContributorKt.access$getLogger$p().info("Progress is canceled. Aborting protocol search");
            return;
        }
        GotoHost gotoHost = GotoHost.Companion.getInstance(this.project);
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        if (concurrentHashMap == null || (concurrentHashMap = (JBPopup)concurrentHashMap.get(ClientId.Companion.getCurrent())) == null) {
            throw new IllegalStateException("Protocol SE Contributor requires a popup for lifetime".toString());
        }
        ConcurrentHashMap popup = concurrentHashMap;
        GotoPopupSession session = gotoHost.getSessionForPopup((Disposable)popup, this.getGotoKey());
        SearchEverywhereToggleAction searchEverywhereToggleAction = this.everywhereAction;
        String[] names = session.getItemsSync(pattern, searchEverywhereToggleAction != null ? Boolean.valueOf(searchEverywhereToggleAction.isEverywhere()) : null, progressIndicator);
        ArrayList items = new ArrayList();
        String[] $this$flatMapTo$iv = names;
        boolean $i$f$flatMapTo = false;
        int n = $this$flatMapTo$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$flatMapTo$iv[i];
            boolean bl = false;
            Iterable list$iv = session.getItemByShortName(it);
            CollectionsKt.addAll((Collection)items, (Iterable)list$iv);
        }
        List $this$sortBy$iv = items;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GotoResult it = (GotoResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-it.getSearchItemData().getMatchScore());
                    it = (GotoResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getSearchItemData().getMatchScore()));
                }
            });
        }
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GotoResult it = (GotoResult)element$iv;
            boolean bl = false;
            progressIndicator.checkCanceled();
            ProtocolSENavigationItem navigationItem = Companion.createNavigationItem(this.project, this.getShouldAccessVfsWhenPresentingItems(), pattern, it, session);
            if (consumer.process((Object)new FoundItemDescriptor((Object)navigationItem, it.getSearchItemData().getMatchScore()))) continue;
        }
    }

    public boolean processSelectedItem(@NotNull ProtocolNavigationItem selected, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)((Object)selected), (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        selected.getSearchPopup().getItemExecutedSignal().fire((Object)selected.getSearchItemData());
        return true;
    }

    public boolean getShouldAccessVfsWhenPresentingItems() {
        return this.shouldAccessVfsWhenPresentingItems;
    }

    @NotNull
    public ListCellRenderer<? super ProtocolNavigationItem> getElementsRenderer() {
        return new ProtocolSEContributorRenderer(this.project);
    }

    @Nullable
    public Object getDataForItem(@NotNull ProtocolNavigationItem element, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return element;
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereContributor$Companion;", "", "()V", "createNavigationItem", "Lcom/jetbrains/rdclient/gotoType/ProtocolSENavigationItem;", "project", "Lcom/intellij/openapi/project/Project;", "shouldAccessVfsWhenPresentingItems", "", "pattern", "", "result", "Lcom/jetbrains/rdclient/gotoType/GotoResult;", "session", "Lcom/jetbrains/rdclient/gotoType/GotoPopupSession;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProtocolSENavigationItem createNavigationItem(@NotNull Project project, boolean shouldAccessVfsWhenPresentingItems, @NotNull String pattern, @NotNull GotoResult result2, @NotNull GotoPopupSession session) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            VirtualFile vFile = ProtocolNavigationItem.Companion.calculateVirtualFile(result2.getSearchItemData(), shouldAccessVfsWhenPresentingItems, project);
            ProtocolNavigationItemRendererData rendererData = ProtocolNavigationItemRendererData.Companion.calculateRenderData(vFile, shouldAccessVfsWhenPresentingItems, project);
            return new ProtocolSENavigationItem(project, session, result2.getSearchPopup(), pattern, result2.getSearchItemData(), vFile, rendererData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

