/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.jetbrains.cloudconfig.HeaderStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/settingsSync/CloudConfigVersionContext;", "Lcom/jetbrains/cloudconfig/HeaderStorage;", "()V", "contextVersionMap", "", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "doWithVersion", "T", "filePath", "version", "function", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "get", "path", "remove", "", "store", "value", "intellij.settingsSync"})
public final class CloudConfigVersionContext
implements HeaderStorage {
    @NotNull
    private final Map<String, String> contextVersionMap = new LinkedHashMap();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    @Nullable
    public String get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.contextVersionMap.get(path);
    }

    @Override
    public void store(@NotNull String path, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.contextVersionMap.put(path, value);
    }

    @Override
    public void remove(@Nullable String path) {
        TypeIntrinsics.asMutableMap(this.contextVersionMap).remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T doWithVersion(@NotNull String filePath, @Nullable String version, @NotNull Function1<? super String, ? extends T> function) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object2;
            boolean bl = false;
            try {
                if (version != null) {
                    this.contextVersionMap.put(filePath, version);
                }
                object2 = function.invoke((Object)filePath);
            }
            finally {
                this.contextVersionMap.clear();
            }
            object = object2;
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }
}

