/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.AbstractHttpClient;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.FilesEndpoint;
import com.jetbrains.cloudconfig.HeaderStorage;
import com.jetbrains.cloudconfig.ServiceEndpoint;
import com.jetbrains.cloudconfig.VersionsEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractCloudConfigFileClient
extends AbstractHttpClient {
    protected ETagStorage eTagStorage = DUMMY_ETAG_STORAGE;
    protected HeaderStorage versionIdStorage = null;
    protected static final ETagStorage DUMMY_ETAG_STORAGE = new ETagStorage(){

        @Override
        public String get(String path) {
            return null;
        }

        @Override
        public void store(String path, String value) {
        }

        @Override
        public void remove(String path) {
        }
    };

    protected AbstractCloudConfigFileClient(String endpoint) {
        super(endpoint);
    }

    protected AbstractCloudConfigFileClient(String endpoint, Configuration config) {
        super(endpoint, config);
    }

    protected InputStream read(final String file, FilesEndpoint serviceEndpoint) throws IOException {
        return this.download("GET", this.url(file, serviceEndpoint), (Map<String, String>)new HashMap<String, String>(){
            {
                String versionId;
                this.put("Content-Type", "application/octet-stream");
                String etag = AbstractCloudConfigFileClient.this.eTagStorage.get(file);
                if (AbstractCloudConfigFileClient.this.eTagStorage != null && etag != null) {
                    this.put("If-None-Match", etag);
                }
                if ((versionId = AbstractCloudConfigFileClient.this.getVersionId(file)) != null) {
                    this.put("Version-Id", versionId);
                }
            }
        }, (statusCode, headers, stream2) -> {
            if (statusCode == 304) {
                this.closeSafely(stream2);
                return null;
            }
            this.saveEtag(headers, file);
            this.saveVersionId(headers, file);
            return stream2;
        }, false);
    }

    protected void write(final String file, InputStream content, FilesEndpoint serviceEndpoint) throws IOException {
        this.upload("PUT", this.url(file, serviceEndpoint), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/octet-stream");
                String versionId = AbstractCloudConfigFileClient.this.getVersionId(file);
                if (versionId != null) {
                    this.put("Version-Id", versionId);
                }
            }
        }, stream2 -> this.drainStream(content, stream2), (statusCode, headers, stream2) -> {
            this.saveEtag(headers, file);
            this.saveVersionId(headers, file);
            return null;
        }, 204);
    }

    public void delete(String file, FilesEndpoint serviceEndpoint) throws IOException {
        HttpURLConnection connection = this.config.openConnection(this.url(file, serviceEndpoint));
        connection.setRequestMethod("DELETE");
        this.assertSuccess(connection, 204);
        if (this.versionIdStorage != null) {
            this.versionIdStorage.remove(file);
        }
    }

    public List<String> list(String file, FilesEndpoint serviceEndpoint) throws IOException {
        return this.download("OPTIONS", this.url(file, serviceEndpoint), Collections.emptyMap(), (statusCode, headers, stream2) -> (List)GSON.fromJson((Reader)new InputStreamReader(stream2), List.class), true);
    }

    protected FileVersionInfo getLatestVersion(String file, VersionsEndpoint serviceEndpoint) throws IOException {
        return this.download("GET", this.url(file, serviceEndpoint), Collections.emptyMap(), (statusCode, headers, stream2) -> (FileVersionInfo)GSON.fromJson((Reader)new InputStreamReader(stream2), FileVersionInfo.class), true);
    }

    protected List<FileVersionInfo> getVersions(String file, VersionsEndpoint serviceEndpoint) throws Exception {
        return this.download("OPTIONS", this.url(file, serviceEndpoint), Collections.emptyMap(), (statusCode, headers, stream2) -> Arrays.asList((FileVersionInfo[])GSON.fromJson((Reader)new InputStreamReader(stream2), FileVersionInfo[].class)), true);
    }

    protected URL url(String path, ServiceEndpoint serviceEndpoint) throws IOException {
        if (serviceEndpoint != null) {
            return new URL(String.format("%s/%s/%s", this.endpoint, serviceEndpoint.subdirectory, path.replaceFirst("^/", "")));
        }
        return new URL(String.format("%s/%s", this.endpoint, path.replaceFirst("^/", "")));
    }

    private void saveEtag(Map<String, List<String>> headers, String file) {
        List<String> etag = headers.get("ETag");
        if (etag != null && etag.size() == 1) {
            this.eTagStorage.store(file, etag.get(0));
        }
    }

    private void saveVersionId(Map<String, List<String>> headers, String file) {
        List<String> versionId = headers.get("Version-Id");
        if (this.versionIdStorage != null && versionId != null && versionId.size() == 1) {
            this.versionIdStorage.store(file, versionId.get(0));
        }
    }

    private String getVersionId(String path) {
        return this.versionIdStorage != null ? this.versionIdStorage.get(path) : null;
    }
}

