/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.cache;

import ai.grazie.utils.cache.CacheValue;
import ai.grazie.utils.mpp.time.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b`\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0003\t\n\u000bJ0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lai/grazie/utils/cache/CacheCondition;", "Key", "Value", "", "toFilterOut", "", "data", "", "previous", "Aggregated", "MaxItem", "MaxTime", "utils-common"})
public interface CacheCondition<Key, Value> {
    @NotNull
    public Set<Key> toFilterOut(@NotNull Map<Key, ? extends Value> var1, @NotNull Set<? extends Key> var2);

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\bH\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/utils/cache/CacheCondition$Aggregated;", "Key", "Value", "Lai/grazie/utils/cache/CacheCondition;", "conditions", "", "(Ljava/util/List;)V", "toFilterOut", "", "data", "", "previous", "utils-common"})
    public static final class Aggregated<Key, Value>
    implements CacheCondition<Key, Value> {
        @NotNull
        private final List<CacheCondition<Key, Value>> conditions;

        public Aggregated(@NotNull List<? extends CacheCondition<Key, Value>> conditions) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            this.conditions = conditions;
        }

        @Override
        @NotNull
        public Set<Key> toFilterOut(@NotNull Map<Key, ? extends Value> data2, @NotNull Set<? extends Key> previous) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter(previous, (String)"previous");
            Set current = CollectionsKt.toMutableSet((Iterable)previous);
            for (CacheCondition<Key, ? extends Value> cacheCondition : this.conditions) {
                current.addAll((Collection)cacheCondition.toFilterOut(data2, current));
            }
            return current;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J6\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/grazie/utils/cache/CacheCondition$MaxItem;", "Key", "Value", "Lai/grazie/utils/cache/CacheCondition;", "Lai/grazie/utils/cache/CacheValue$WithTime;", "maxItems", "", "(I)V", "toFilterOut", "", "data", "", "previous", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nCacheCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheCondition.kt\nai/grazie/utils/cache/CacheCondition$MaxItem\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n515#2:37\n500#2,6:38\n1045#3:44\n1549#3:45\n1620#3,3:46\n*S KotlinDebug\n*F\n+ 1 CacheCondition.kt\nai/grazie/utils/cache/CacheCondition$MaxItem\n*L\n14#1:37\n14#1:38,6\n14#1:44\n14#1:45\n14#1:46,3\n*E\n"})
    public static final class MaxItem<Key, Value>
    implements CacheCondition<Key, CacheValue.WithTime<Value>> {
        private final int maxItems;

        public MaxItem(int maxItems) {
            this.maxItems = maxItems;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<Key> toFilterOut(@NotNull Map<Key, ? extends CacheValue.WithTime<Value>> data2, @NotNull Set<? extends Key> previous) {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter(previous, (String)"previous");
            int toFilterOutNum = data2.size() - previous.size() - this.maxItems;
            if (toFilterOutNum <= 0) {
                return SetsKt.emptySet();
            }
            Map<Key, CacheValue.WithTime<Value>> $this$filter$iv = data2;
            boolean $i$f$filter = false;
            Map<Key, CacheValue.WithTime<Value>> map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!previous.contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Iterable $this$sortedBy$iv = destination$iv$iv.entrySet();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(((CacheValue.WithTime)it.getValue()).getEpoch());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((CacheValue.WithTime)it.getValue()).getEpoch()));
                }
            }), (int)toFilterOutNum);
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getKey());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J6\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/grazie/utils/cache/CacheCondition$MaxTime;", "Key", "Value", "Lai/grazie/utils/cache/CacheCondition;", "Lai/grazie/utils/cache/CacheValue$WithTime;", "maxMillis", "", "(I)V", "toFilterOut", "", "data", "", "previous", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nCacheCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheCondition.kt\nai/grazie/utils/cache/CacheCondition$MaxTime\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,36:1\n515#2:37\n500#2,6:38\n125#3:44\n152#3,3:45\n*S KotlinDebug\n*F\n+ 1 CacheCondition.kt\nai/grazie/utils/cache/CacheCondition$MaxTime\n*L\n22#1:37\n22#1:38,6\n22#1:44\n22#1:45,3\n*E\n"})
    public static final class MaxTime<Key, Value>
    implements CacheCondition<Key, CacheValue.WithTime<Value>> {
        private final int maxMillis;

        public MaxTime(int maxMillis) {
            this.maxMillis = maxMillis;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<Key> toFilterOut(@NotNull Map<Key, ? extends CacheValue.WithTime<Value>> data2, @NotNull Set<? extends Key> previous) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter(previous, (String)"previous");
            long now = Time.INSTANCE.epochMillis$utils_common();
            long border = now - (long)this.maxMillis;
            Map $this$filter$iv = data2;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(((CacheValue.WithTime)it.getValue()).getEpoch() < border)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getKey());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }
}

