/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory;

import io.kinference.ndarray.arrays.ArrayTypes;
import io.kinference.ndarray.arrays.memory.ArrayContainer;
import io.kinference.ndarray.arrays.memory.ArrayDispatcher;
import io.kinference.ndarray.arrays.memory.ArrayStorage;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0000\u00a2\u0006\u0004\b$\u0010%J\t\u0010&\u001a\u00020\"H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/kinference/ndarray/arrays/memory/AllocatorContext;", "Lkotlin/coroutines/CoroutineContext$Element;", "modelName", "", "cycleId", "", "(Ljava/lang/String;J)V", "getCycleId", "()J", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "getModelName", "()Ljava/lang/String;", "unusedContainers", "Lio/kinference/ndarray/arrays/memory/ArrayStorage;", "usedContainers", "Lkotlin/collections/ArrayDeque;", "Lio/kinference/ndarray/arrays/memory/ArrayContainer;", "closeAllocated", "", "component1", "component2", "copy", "equals", "", "other", "", "getArrayContainers", "", "type", "Lio/kinference/ndarray/arrays/ArrayTypes;", "size", "", "count", "getArrayContainers$ndarray_core", "(Lio/kinference/ndarray/arrays/ArrayTypes;II)[Lio/kinference/ndarray/arrays/memory/ArrayContainer;", "hashCode", "toString", "Key", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nAllocatorContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocatorContext.kt\nio/kinference/ndarray/arrays/memory/AllocatorContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n1855#2,2:30\n*S KotlinDebug\n*F\n+ 1 AllocatorContext.kt\nio/kinference/ndarray/arrays/memory/AllocatorContext\n*L\n21#1:30,2\n*E\n"})
public final class AllocatorContext
implements CoroutineContext.Element {
    @NotNull
    public static final Key Key = new Key(null);
    @NotNull
    private final String modelName;
    private final long cycleId;
    @NotNull
    private final ArrayDeque<ArrayContainer> usedContainers;
    @NotNull
    private final ArrayStorage unusedContainers;

    public AllocatorContext(@NotNull String modelName, long cycleId) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        this.modelName = modelName;
        this.cycleId = cycleId;
        this.usedContainers = new ArrayDeque();
        this.unusedContainers = ArrayDispatcher.INSTANCE.getStorage$ndarray_core();
    }

    @NotNull
    public final String getModelName() {
        return this.modelName;
    }

    public final long getCycleId() {
        return this.cycleId;
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return Key;
    }

    @NotNull
    public final ArrayContainer[] getArrayContainers$ndarray_core(@NotNull ArrayTypes type, int size2, int count) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int n = 0;
        Object[] objectArray = new ArrayContainer[count];
        while (n < count) {
            int n2 = n++;
            objectArray[n2] = this.unusedContainers.getArrayContainer(type, size2);
        }
        Object[] arrayContainers = objectArray;
        CollectionsKt.addAll((Collection)((Collection)this.usedContainers), (Object[])arrayContainers);
        return arrayContainers;
    }

    public final void closeAllocated() {
        Iterable $this$forEach$iv = (Iterable)this.usedContainers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArrayContainer it = (ArrayContainer)element$iv;
            boolean bl = false;
            if (it.isOutput()) continue;
            this.unusedContainers.get(it.getArrayTypeIndex(), it.getArraySizeIndex()).addLast((Object)it);
        }
        ArrayDispatcher.INSTANCE.returnStorage$ndarray_core(this.unusedContainers);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineContext.Element.DefaultImpls.fold((CoroutineContext.Element)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)CoroutineContext.Element.DefaultImpls.get((CoroutineContext.Element)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return CoroutineContext.Element.DefaultImpls.minusKey((CoroutineContext.Element)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return CoroutineContext.Element.DefaultImpls.plus((CoroutineContext.Element)this, (CoroutineContext)context);
    }

    @NotNull
    public final String component1() {
        return this.modelName;
    }

    public final long component2() {
        return this.cycleId;
    }

    @NotNull
    public final AllocatorContext copy(@NotNull String modelName, long cycleId) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return new AllocatorContext(modelName, cycleId);
    }

    public static /* synthetic */ AllocatorContext copy$default(AllocatorContext allocatorContext, String string2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = allocatorContext.modelName;
        }
        if ((n & 2) != 0) {
            l = allocatorContext.cycleId;
        }
        return allocatorContext.copy(string2, l);
    }

    @NotNull
    public String toString() {
        return "AllocatorContext(modelName=" + this.modelName + ", cycleId=" + this.cycleId + ")";
    }

    public int hashCode() {
        int result2 = this.modelName.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.cycleId);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllocatorContext)) {
            return false;
        }
        AllocatorContext allocatorContext = (AllocatorContext)other;
        if (!Intrinsics.areEqual((Object)this.modelName, (Object)allocatorContext.modelName)) {
            return false;
        }
        return this.cycleId == allocatorContext.cycleId;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/kinference/ndarray/arrays/memory/AllocatorContext$Key;", "Lkotlin/coroutines/CoroutineContext$Key;", "Lio/kinference/ndarray/arrays/memory/AllocatorContext;", "()V", "ndarray-core"})
    public static final class Key
    implements CoroutineContext.Key<AllocatorContext> {
        private Key() {
        }

        public /* synthetic */ Key(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

