/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

final class ExtendedPrecision {
    private static final double MULTIPLIER = 1.34217729E8;
    private static final double SAFE_UPPER = 6.696928794914171E299;
    private static final double DOWN_SCALE = 9.313225746154785E-10;
    private static final double UP_SCALE = 1.073741824E9;
    private static final int EXP_MASK = 2047;
    private static final int CMP_UNSIGNED_2046 = -2147481602;
    private static final int CMP_UNSIGNED_MINUS_1 = Integer.MAX_VALUE;

    private ExtendedPrecision() {
    }

    static double productLow(double x, double y, double xy) {
        double b;
        if (ExtendedPrecision.isNotNormal(xy)) {
            return xy - xy;
        }
        double a = Math.abs(x);
        if (a + (b = Math.abs(y)) + Math.abs(xy) >= 6.696928794914171E299) {
            if (a > b) {
                return ExtendedPrecision.productLowUnscaled(x * 9.313225746154785E-10, y, xy * 9.313225746154785E-10) * 1.073741824E9;
            }
            return ExtendedPrecision.productLowUnscaled(x, y * 9.313225746154785E-10, xy * 9.313225746154785E-10) * 1.073741824E9;
        }
        return ExtendedPrecision.productLowUnscaled(x, y, xy);
    }

    static boolean isNotNormal(double a) {
        int baisedExponent = (int)(Double.doubleToRawLongBits(a) >>> 52) & 0x7FF;
        return baisedExponent + Integer.MAX_VALUE >= -2147481602;
    }

    private static double productLowUnscaled(double x, double y, double xy) {
        double hx = ExtendedPrecision.highPartUnscaled(x);
        double lx = x - hx;
        double hy = ExtendedPrecision.highPartUnscaled(y);
        double ly = y - hy;
        return ExtendedPrecision.productLow(hx, lx, hy, ly, xy);
    }

    static double squareLowUnscaled(double x, double xx) {
        double hx = ExtendedPrecision.highPartUnscaled(x);
        double lx = x - hx;
        return ExtendedPrecision.productLow(hx, lx, hx, lx, xx);
    }

    private static double productLow(double hx, double lx, double hy, double ly, double xy) {
        return lx * ly - (xy - hx * hy - lx * hy - hx * ly);
    }

    static double highPartUnscaled(double value) {
        double c = 1.34217729E8 * value;
        return c - (c - value);
    }

    static double twoSumLow(double a, double b, double sum2) {
        double bVirtual = sum2 - a;
        return a - (sum2 - bVirtual) + (b - bVirtual);
    }
}

