/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.features;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.features.MLCompletionWeigher;
import com.intellij.completion.ml.features.MLFeaturesUtil;
import com.intellij.completion.ml.performance.MLCompletionPerformanceTracker;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/features/MLCompletionWeigher;", "Lcom/intellij/codeInsight/completion/CompletionWeigher;", "()V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "DummyComparable", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nMLCompletionWeigher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionWeigher.kt\ncom/intellij/completion/ml/features/MLCompletionWeigher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n23#2:61\n*S KotlinDebug\n*F\n+ 1 MLCompletionWeigher.kt\ncom/intellij/completion/ml/features/MLCompletionWeigher\n*L\n38#1:61\n*E\n"})
public final class MLCompletionWeigher
extends CompletionWeigher {
    @NotNull
    public Comparable<?> weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompletionParameters completionParameters = location.getCompletionParameters();
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"getCompletionParameters(...)");
        LookupStorage lookupStorage = LookupStorage.Companion.get(completionParameters);
        if (lookupStorage == null) {
            return DummyComparable.EMPTY;
        }
        LookupStorage storage = lookupStorage;
        if (!storage.shouldComputeFeatures()) {
            return DummyComparable.EMPTY;
        }
        Map result = new LinkedHashMap();
        ContextFeatures contextFeatures = storage.contextProvidersResult();
        for (ElementFeatureProvider provider : ElementFeatureProvider.forLanguage((Language)storage.getLanguage())) {
            try {
                String name = provider.getName();
                MLCompletionPerformanceTracker mLCompletionPerformanceTracker = storage.getPerformanceTracker();
                Intrinsics.checkNotNull((Object)name);
                Map features2 = (Map)mLCompletionPerformanceTracker.trackElementFeaturesCalculation(name, (Function0)new Function0<Map<String, MLFeatureValue>>(provider, element, location, contextFeatures){
                    final /* synthetic */ ElementFeatureProvider $provider;
                    final /* synthetic */ LookupElement $element;
                    final /* synthetic */ CompletionLocation $location;
                    final /* synthetic */ ContextFeatures $contextFeatures;
                    {
                        this.$provider = $provider;
                        this.$element = $element;
                        this.$location = $location;
                        this.$contextFeatures = $contextFeatures;
                        super(0);
                    }

                    public final Map<String, MLFeatureValue> invoke() {
                        return this.$provider.calculateFeatures(this.$element, this.$location, this.$contextFeatures);
                    }
                });
                Intrinsics.checkNotNull((Object)features2);
                for (Map.Entry entry : features2.entrySet()) {
                    String featureName = (String)entry.getKey();
                    MLFeatureValue featureValue = (MLFeatureValue)entry.getValue();
                    String string = name + "_" + featureName;
                    Intrinsics.checkNotNull((Object)featureValue);
                    result.put(string, featureValue);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                MLCompletionWeigher $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(MLCompletionWeigher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e);
            }
        }
        return result.isEmpty() ? (Comparable)DummyComparable.EMPTY : (Comparable)new DummyComparable(result);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/features/MLCompletionWeigher$DummyComparable;", "", "", "values", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "(Ljava/util/Map;)V", "mlFeatures", "getMlFeatures", "()Ljava/util/Map;", "compareTo", "", "other", "toString", "Companion", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nMLCompletionWeigher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionWeigher.kt\ncom/intellij/completion/ml/features/MLCompletionWeigher$DummyComparable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n453#2:61\n403#2:62\n1238#3,4:63\n*S KotlinDebug\n*F\n+ 1 MLCompletionWeigher.kt\ncom/intellij/completion/ml/features/MLCompletionWeigher$DummyComparable\n*L\n46#1:61\n46#1:62\n46#1:63,4\n*E\n"})
    public static final class DummyComparable
    implements Comparable<Object> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Object> mlFeatures;
        @JvmField
        @NotNull
        public static final DummyComparable EMPTY = new DummyComparable(MapsKt.emptyMap());

        /*
         * WARNING - void declaration
         */
        public DummyComparable(@NotNull Map<String, ? extends MLFeatureValue> values) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Map<String, ? extends MLFeatureValue> map = values;
            DummyComparable dummyComparable = this;
            boolean $i$f$mapValues = false;
            void var4_5 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object = MLFeaturesUtil.INSTANCE.getRawValue((MLFeatureValue)it.getValue());
                map3.put(k, object);
            }
            dummyComparable.mlFeatures = destination$iv$iv;
        }

        @NotNull
        public final Map<String, Object> getMlFeatures() {
            return this.mlFeatures;
        }

        @Override
        public int compareTo(@NotNull Object other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return 0;
        }

        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.mlFeatures.entrySet(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ml/features/MLCompletionWeigher$DummyComparable$Companion;", "", "()V", "EMPTY", "Lcom/intellij/completion/ml/features/MLCompletionWeigher$DummyComparable;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

