/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security;

import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/security/ResourceUrl;", "", "url", "", "expiration", "Ljava/time/LocalDateTime;", "(Ljava/lang/String;Ljava/time/LocalDateTime;)V", "getExpiration", "()Ljava/time/LocalDateTime;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "client"})
public final class ResourceUrl {
    @NotNull
    private final String url;
    @NotNull
    private final LocalDateTime expiration;

    public ResourceUrl(@NotNull String url, @NotNull LocalDateTime expiration) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        this.url = url;
        this.expiration = expiration;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final LocalDateTime getExpiration() {
        return this.expiration;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final LocalDateTime component2() {
        return this.expiration;
    }

    @NotNull
    public final ResourceUrl copy(@NotNull String url, @NotNull LocalDateTime expiration) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        return new ResourceUrl(url, expiration);
    }

    public static /* synthetic */ ResourceUrl copy$default(ResourceUrl resourceUrl, String string, LocalDateTime localDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            string = resourceUrl.url;
        }
        if ((n & 2) != 0) {
            localDateTime = resourceUrl.expiration;
        }
        return resourceUrl.copy(string, localDateTime);
    }

    @NotNull
    public String toString() {
        return "ResourceUrl(url=" + this.url + ", expiration=" + this.expiration + ')';
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + this.expiration.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceUrl)) {
            return false;
        }
        ResourceUrl resourceUrl = (ResourceUrl)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)resourceUrl.url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expiration, (Object)resourceUrl.expiration);
    }
}

